/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.exchange.domain;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorAttributeContract;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorMapping;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;

public class TokenExchangeProcessorPolicy {
    private String id;
    private String name;
    private boolean actorTokenRequired;
    private TokenExchangeProcessorAttributeContract contract = new TokenExchangeProcessorAttributeContract();
    private Map<String, TokenExchangeProcessorMapping> tokenExchangeProcessorMappings = new HashMap<String, TokenExchangeProcessorMapping>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActorTokenRequired() {
        return this.actorTokenRequired;
    }

    public void setActorTokenRequired(boolean actorTokenRequired) {
        this.actorTokenRequired = actorTokenRequired;
    }

    public TokenExchangeProcessorAttributeContract getContract() {
        return this.contract;
    }

    public void setContract(TokenExchangeProcessorAttributeContract contract) {
        this.contract = contract;
    }

    public Map<String, TokenExchangeProcessorMapping> getTokenExchangeProcessorMappings() {
        return this.tokenExchangeProcessorMappings;
    }

    public void addTokenExchangeProcessorMapping(TokenExchangeProcessorMapping tokenExchangeProcessorMapping) {
        String key = this.getMappingKey(tokenExchangeProcessorMapping);
        this.tokenExchangeProcessorMappings.put(key, tokenExchangeProcessorMapping);
    }

    public final TokenExchangeProcessorMapping getTokenExchangeProcessorMapping(TokenExchangeRequest request) {
        Set subjectTokenTypeMappings;
        String actorTokenType;
        TokenExchangeProcessorMapping result = null;
        String subjectTokenType = request.getSubjectTokenType();
        String mappingKey = this.getMappingKey(subjectTokenType, actorTokenType = StringUtils.isNotBlank((String)request.getActorTokenType()) ? request.getActorTokenType() : "");
        TokenExchangeProcessorMapping mapping = this.tokenExchangeProcessorMappings.get(mappingKey);
        if (mapping != null) {
            result = mapping;
        } else if (StringUtils.isBlank((String)actorTokenType) && (subjectTokenTypeMappings = this.tokenExchangeProcessorMappings.values().stream().filter(m -> m.getSubjectTokenType().equals(subjectTokenType)).collect(Collectors.toSet())).size() == 1) {
            result = (TokenExchangeProcessorMapping)subjectTokenTypeMappings.iterator().next();
        }
        return result;
    }

    private String getMappingKey(TokenExchangeProcessorMapping tokenExchangeProcessorMapping) {
        String subjectTokenType = tokenExchangeProcessorMapping.getSubjectTokenType();
        String actorTokenType = StringUtils.isNotBlank((String)tokenExchangeProcessorMapping.getActorTokenType()) ? tokenExchangeProcessorMapping.getActorTokenType() : "";
        return this.getMappingKey(subjectTokenType, actorTokenType);
    }

    private String getMappingKey(String subjectTokenType, String actorTokenType) {
        return String.format("%s|%s", subjectTokenType, actorTokenType);
    }
}

