/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.exchange.manager.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.oauth.token.exchange.xmlbinding.TokenExchangeProcessorMappingType;
import org.sourceid.oauth.token.exchange.xmlbinding.TokenExchangeProcessorPoliciesDocument;
import org.sourceid.oauth.token.exchange.xmlbinding.TokenExchangeProcessorPoliciesType;
import org.sourceid.oauth.token.exchange.xmlbinding.TokenExchangeProcessorPolicyType;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorAttributeContract;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicies;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.ProcessorPolicy2TokenGeneratorManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.exchange.manager.exception.TokenExchangeProcessorPolicyException;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMappingType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ExtendedAttributeContractType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ExtendedAttributeType;

public class TokenExchangeProcessorPolicyManagerImpl
implements TokenExchangeProcessorPolicyManager,
AutoReloadable {
    private static final Logger logger = LogManager.getLogger(TokenExchangeProcessorPolicyManagerImpl.class);
    private static final String FILENAME = "token-exchange-processor-policy.xml";
    private final ConnectionUtil connectionUtil = new ConnectionUtil();
    private final XmlLoader xmlLoader;
    private final String directory;
    private final ClientManager clientManager;
    private final ProcessorPolicy2TokenGeneratorManager tokenGeneratorManager;
    private TokenExchangeProcessorPolicies tokenExchangeProcessorPolicies;
    private final ClientSettingManager clientSettingManager;
    private final AuthzServerManager authzServerManager;

    public TokenExchangeProcessorPolicyManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo, ClientManager clientManager, ProcessorPolicy2TokenGeneratorManager tokenGeneratorManager, ClientSettingManager clientSettingManager, AuthzServerManager authzServerManager) {
        this.xmlLoader = xmlLoader;
        this.directory = sysDirInfo.getDataDirectory();
        this.clientManager = clientManager;
        this.tokenGeneratorManager = tokenGeneratorManager;
        this.clientSettingManager = clientSettingManager;
        this.authzServerManager = authzServerManager;
        this.loadConfig();
    }

    @Override
    public synchronized TokenExchangeProcessorPolicies getTokenExchangeProcessorPolicies() {
        return this.tokenExchangeProcessorPolicies;
    }

    @Override
    public synchronized TokenExchangeProcessorPolicy getPolicyById(String id) {
        return this.tokenExchangeProcessorPolicies.getPolicy(id);
    }

    @Override
    public synchronized void saveTokenExchangeProcessorPolicies(TokenExchangeProcessorPolicies toSave) {
        AdminAuditLogger.Event event;
        this.loadConfig();
        TokenExchangeProcessorPolicies existingTokenExchangeProcessorPolicies = this.getTokenExchangeProcessorPolicies();
        String message = null;
        if (toSave.getPolicies().size() == existingTokenExchangeProcessorPolicies.getPolicies().size()) {
            event = AdminAuditLogger.Event.MODIFY;
            if (toSave.getDefaultInstanceId() != null && existingTokenExchangeProcessorPolicies.getDefaultInstanceId() != null && !toSave.getDefaultInstanceId().equals(existingTokenExchangeProcessorPolicies.getDefaultInstanceId())) {
                message = "Default instance modified to " + toSave.getDefaultInstanceId();
            }
        } else {
            event = toSave.getPolicies().size() > existingTokenExchangeProcessorPolicies.getPolicies().size() ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.DELETE;
        }
        TokenExchangeProcessorPoliciesDocument doc = TokenExchangeProcessorPoliciesDocument.Factory.newInstance();
        TokenExchangeProcessorPoliciesType policiesType = doc.addNewTokenExchangeProcessorPolicies();
        if (toSave.getPolicies().isEmpty()) {
            policiesType.setDefaultTokenExchangeProcessorPolicyId(null);
        } else {
            policiesType.setDefaultTokenExchangeProcessorPolicyId(toSave.getDefaultInstanceId());
        }
        for (TokenExchangeProcessorPolicy tepp : toSave.getPolicies().values()) {
            TokenExchangeProcessorPolicyType policyType = policiesType.addNewTokenExchangeProcessorPolicy();
            policyType.setId(tepp.getId());
            policyType.setName(tepp.getName());
            policyType.setActorTokenRequired(tepp.isActorTokenRequired());
            this.fillExtendedAttributeContractType(tepp, policyType);
            for (TokenExchangeProcessorMapping mapping : tepp.getTokenExchangeProcessorMappings().values()) {
                TokenExchangeProcessorMappingType mappingType = policyType.addNewTokenExchangeProcessorMapping();
                this.fillMappingType(mapping, mappingType);
            }
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.save(this.directory, FILENAME, (XmlObject)doc);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_TOKEN_EXCHANGE_PROCESSOR_POLICY, event, message);
        }
        this.loadConfig();
    }

    @Override
    public synchronized TokenExchangeProcessorPolicy getPolicyByClient(Client client) throws TokenExchangeProcessorPolicyException {
        if (!this.tokenExchangeProcessorPolicies.containsConfigureInstances()) {
            logger.error("Token Exchange Processor Policy not configured");
            throw new TokenExchangeProcessorPolicyException("invalid server configuration");
        }
        String policyId = client.getTokenExchangeProcessorPolicyId();
        if (StringUtils.isBlank((String)policyId) && this.tokenExchangeProcessorPolicies.hasDefaultInstanceId()) {
            policyId = this.tokenExchangeProcessorPolicies.getDefaultInstanceId();
        }
        if (StringUtils.isBlank((String)policyId)) {
            logger.error("Default Token Exchange Processor Policy not found");
            throw new TokenExchangeProcessorPolicyException("invalid server configuration");
        }
        return this.tokenExchangeProcessorPolicies.getPolicy(policyId);
    }

    @Override
    public boolean isInUse(String id) {
        if (this.tokenGeneratorManager.getMappings().stream().anyMatch(mapping -> id != null && id.equals(mapping.getSourceId()))) {
            return true;
        }
        ClientSetting clientSetting = this.clientSettingManager.getClientSetting();
        if (clientSetting != null && id != null && id.equals(clientSetting.getTokenExchangeProcessorPolicyId())) {
            return true;
        }
        String contextId = new ContextUtil().buildQualifiedId("urn:ietf:params:oauth:grant-type:token-exchange", new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, id));
        if (this.authzServerManager.getAccessTokenMappings().stream().anyMatch(mapping -> contextId.equals(mapping.getContextId()))) {
            return true;
        }
        if (id != null && this.authzServerManager.getTeppToUserKeyMapping(id) != null) {
            return true;
        }
        return !this.clientManager.getClientsByTeppId(id).isEmpty();
    }

    @Override
    public boolean isDataSourceInUse(String id) {
        return !this.getPoliciesUsingDataSource(id).isEmpty();
    }

    @Override
    public List<TokenExchangeProcessorPolicy> getPoliciesUsingDataSource(String dataSourceId) {
        return this.tokenExchangeProcessorPolicies.getPolicies().values().stream().filter(policy -> policy.getTokenExchangeProcessorMappings().values().stream().map(TokenExchangeProcessorMapping::getAttributeMapping).map(AttributeMapping::getAttributeSources).anyMatch(sources -> sources != null && dataSourceId != null && sources.stream().anyMatch(source -> dataSourceId.equals(source.getDataSourceId())))).collect(Collectors.toList());
    }

    @Override
    public boolean isTokenProcessorInUse(String pluginId) {
        return this.tokenExchangeProcessorPolicies.getPolicies().values().stream().map(TokenExchangeProcessorPolicy::getTokenExchangeProcessorMappings).flatMap(mappings -> mappings.values().stream()).anyMatch(mapping -> pluginId != null && (pluginId.equals(mapping.getActorTokenProcessorId()) || pluginId.equals(mapping.getSubjectTokenProcessorId())));
    }

    private synchronized void loadConfig() {
        TokenExchangeProcessorPoliciesDocument doc;
        TokenExchangeProcessorPolicies domain = new TokenExchangeProcessorPolicies();
        if (this.xmlLoader.xmlExists(this.directory, FILENAME)) {
            XmlObject xmlObject = this.xmlLoader.load(this.directory, FILENAME);
            doc = (TokenExchangeProcessorPoliciesDocument)xmlObject;
        } else {
            doc = TokenExchangeProcessorPoliciesDocument.Factory.newInstance();
            doc.addNewTokenExchangeProcessorPolicies();
        }
        TokenExchangeProcessorPoliciesType tepps = doc.getTokenExchangeProcessorPolicies();
        domain.setDefaultInstanceId(tepps.getDefaultTokenExchangeProcessorPolicyId());
        for (TokenExchangeProcessorPolicyType teppType : tepps.getTokenExchangeProcessorPolicyArray()) {
            TokenExchangeProcessorPolicy tepp = new TokenExchangeProcessorPolicy();
            tepp.setId(teppType.getId());
            tepp.setName(teppType.getName());
            tepp.setActorTokenRequired(teppType.getActorTokenRequired());
            this.fillAttributeContract(teppType, tepp);
            for (TokenExchangeProcessorMappingType mappingType : teppType.getTokenExchangeProcessorMappingArray()) {
                TokenExchangeProcessorMapping mapping = new TokenExchangeProcessorMapping();
                this.fillMapping(mappingType, mapping);
                tepp.addTokenExchangeProcessorMapping(mapping);
            }
            domain.addPolicy(tepp);
        }
        this.tokenExchangeProcessorPolicies = domain;
    }

    private void fillMapping(TokenExchangeProcessorMappingType mappingType, TokenExchangeProcessorMapping mapping) {
        mapping.setSubjectTokenType(mappingType.getSubjectTokenType());
        mapping.setSubjectTokenProcessorId(mappingType.getSubjectTokenProcessorId());
        mapping.setActorTokenType(mappingType.getActorTokenType());
        mapping.setActorTokenProcessorId(mappingType.getActorTokenProcessorId());
        AttributeMapping tmp = new AttributeMapping();
        this.connectionUtil.fillAttrMappingFromXml(mappingType.getAttributeMappingType(), tmp);
        mapping.setAttributeMapping(tmp);
    }

    private void fillMappingType(TokenExchangeProcessorMapping mapping, TokenExchangeProcessorMappingType mappingType) {
        mappingType.setSubjectTokenType(mapping.getSubjectTokenType());
        mappingType.setSubjectTokenProcessorId(mapping.getSubjectTokenProcessorId());
        mappingType.setActorTokenType(mapping.getActorTokenType());
        mappingType.setActorTokenProcessorId(mapping.getActorTokenProcessorId());
        AttributeMappingType attributeMappingType = mappingType.addNewAttributeMappingType();
        this.connectionUtil.fillInAttributeMappingType(attributeMappingType, mapping.getAttributeMapping());
    }

    private void fillExtendedAttributeContractType(TokenExchangeProcessorPolicy tepp, TokenExchangeProcessorPolicyType policyType) {
        TokenExchangeProcessorAttributeContract contract = tepp.getContract();
        if (contract != null) {
            ExtendedAttributeContractType extendedAttributeContractType = policyType.addNewExtendedAttributeContract();
            for (String name : contract.getMutableAttributeNames()) {
                ExtendedAttributeType extendedAttributeType = extendedAttributeContractType.addNewExtendedAttribute();
                extendedAttributeType.setAttributeName(name);
                extendedAttributeType.setMaskValue(contract.isMaskedAttribute(name));
            }
        }
    }

    private void fillAttributeContract(TokenExchangeProcessorPolicyType teppType, TokenExchangeProcessorPolicy tepp) {
        ExtendedAttributeType[] extendedAttributes;
        ExtendedAttributeContractType extendedAttributeContractType = teppType.getExtendedAttributeContract();
        if (extendedAttributeContractType != null && (extendedAttributes = extendedAttributeContractType.getExtendedAttributeArray()) != null) {
            TokenExchangeProcessorAttributeContract contract = new TokenExchangeProcessorAttributeContract();
            for (ExtendedAttributeType extendedAttribute : extendedAttributes) {
                String name = extendedAttribute.getAttributeName();
                contract.addMutableAttributeName(name);
                if (!extendedAttribute.getMaskValue()) continue;
                contract.addMaskedAttributeName(name);
            }
            tepp.setContract(contract);
        }
    }
}

