/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.IDGenerator;
import org.sourceid.oauth20.handlers.AttributesHolder;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.OAuthResumableRequestHandlerBase;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.adapter.state.ApplicationSessionStateSupport;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.IrsmSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class AccessGrantRequestHandler
extends OAuthResumableRequestHandlerBase {
    public static final String SUPPL_CTX_KEY = "AccessGrantRequestHandler.state";
    public static final String APPLICATION_SESSION_BASE_KEY = "oauth.access.grants";
    public static final String OAUTH_ISSUER_KEY = "oauth.issuer";

    @Override
    void doIt(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributesHolder userAttrs) throws AuthorizationRequestException, IOException {
        ApplicationSessionStateSupport applicationSessionStateSupport = new ApplicationSessionStateSupport(APPLICATION_SESSION_BASE_KEY, (sessionStateSupport, request, response) -> sessionStateSupport.removeAttribute("attrs", request, response));
        applicationSessionStateSupport.setAttribute("attrs", (Object)userAttrs.getUserKeyAttributes(), req, resp, true);
        String cSRFToken = IDGenerator.rndAlphaNumeric(20);
        applicationSessionStateSupport.setAttribute("csrfToken", (Object)cSRFToken, req, resp, false);
        OAuthIssuer oAuthIssuer = this.getoAuthIssuerUtils().getOAuthIssuerFromRequest(req);
        if (oAuthIssuer != null) {
            applicationSessionStateSupport.setAttribute(OAUTH_ISSUER_KEY, (Object)oAuthIssuer, req, resp, false);
        }
        this.checkRegisterIrsmSession(req, resp, otherState);
        resp.sendRedirect(AdapterPathSupport.convertPath(req, resp, "/as/oauth_access_grants.ping"));
    }

    @Override
    String getSupplementalContextKeyName() {
        return SUPPL_CTX_KEY;
    }

    @Override
    boolean isSkipAuthorization() {
        return true;
    }

    protected void checkRegisterIrsmSession(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState) {
        IdpHashableAuthnBean[] authnBeans;
        OpenIdConnectProviderPolicy providerPolicy = this.policySupport.getConnectProviderPolicyManager().getPolicy();
        if (providerPolicy.isTrackUserSessionsForLogout() && (authnBeans = (IdpHashableAuthnBean[])otherState.get("authn-bean")) != null) {
            IdpSessionRegistrySupport.registerSessionForSlo(req, resp, otherState, authnBeans, new IrsmSession(Arrays.asList("attrs")));
        }
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        OutMessageContext outMsgCtx = super.getInitialOutMsgCtx(inMsgCtx, req, resp);
        outMsgCtx.setBinding(inMsgCtx.getBinding());
        return outMsgCtx;
    }
}

