/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.authorizationdetails.domain.InvalidAuthorizationDetailException;
import org.sourceid.oauth20.device.DeviceAuthorizationState;
import org.sourceid.oauth20.device.DeviceFlowManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.InvalidRequestedScopeException;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.BaseClientAuthnRequestHandler;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.token.DeviceAuthorizationResponse;
import org.sourceid.saml20.adapter.state.KeyValueStateSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class DeviceAuthorizationRequestHandler
extends BaseClientAuthnRequestHandler {
    private static final Log log = LogFactory.getLog(DeviceAuthorizationRequestHandler.class);
    private static final int MAX_USER_CODE_GENERATION_RETRY = 4;
    public static final String DEVICE_AUTHZ_STATE_RESULT_KEY = "DEVICE-AUTHZ-RESULT-STATE";
    private final AuthzServerManager authzServerMgr;
    private final DeviceFlowManager deviceFlowManager;
    private final KeyValueStateSupport keyValueStateSupport;

    public DeviceAuthorizationRequestHandler(AuthzServerManager authzServerMgr, DeviceFlowManager deviceFlowManager, KeyValueStateSupport keyValueStateSupport, OAuthIssuerUtils oAuthIssuerUtils) {
        super(oAuthIssuerUtils);
        this.authzServerMgr = authzServerMgr;
        this.deviceFlowManager = deviceFlowManager;
        this.keyValueStateSupport = keyValueStateSupport;
    }

    @Override
    protected void doProcess(InMessageContext msgCtx, OutMessageContext outMstCtx, Client client, HttpServletRequest req, HttpServletResponse resp) throws IOException, AccessTokenRequestException {
        String currentBaseUrl;
        DeviceAuthorizationResponse deviceAuthzResponse;
        DeviceAuthorizationState state;
        String normalizedUserCode;
        Scope scope = this.getScope(msgCtx);
        AuthorizationDetails authorizationDetails = AuthorizationDetailsUtil.getAuthorizationDetails(msgCtx.getParam("authorization_details"));
        int retryCounter = 0;
        while (this.keyValueStateSupport.getValue(normalizedUserCode = this.deviceFlowManager.normalizeUserCode((state = (deviceAuthzResponse = new DeviceAuthorizationResponse(currentBaseUrl = this.getOAuthIssuerService().getIssuerValue(req), this.authzServerMgr, this.deviceFlowManager, client)).toDeviceAuthorizationState(scope, authorizationDetails)).getUserCode())) != null && retryCounter++ < 4) {
        }
        if (retryCounter > 4) {
            String log = "unable to create a unique user code after 5 retries, returning internal server error. This event should not happen under normal circumstances please consider extending the length and the character set used to generate the user-code.";
            DeviceAuthorizationRequestHandler.log.error((Object)log);
            String msg = "Internal server error, please contact your system administrator.";
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.server_error, msg, 500);
        }
        this.keyValueStateSupport.setValue(normalizedUserCode, (Object)deviceAuthzResponse.getDeviceCode());
        this.keyValueStateSupport.setValue(deviceAuthzResponse.getDeviceCode(), (Object)state);
        deviceAuthzResponse.tokenResponseToOutContext(outMstCtx);
        AuditLogger.setStatus("success");
    }

    @Override
    protected void preValidationAuditing(HttpServletRequest req, InMessageContext inMsgCtx) {
        AsAuditLogger.setInMsgCtx(req, null, "urn:ietf:params:oauth:grant-type:device_code");
    }

    @Override
    protected Collection<String> getParamsToValidateNotRepeating() {
        return Collections.singletonList(Parameters.SCOPE);
    }

    @Override
    protected void validateParameters(HttpServletRequest req, InMessageContext inMsgCtx) throws AccessTokenRequestException {
    }

    @Override
    protected void validateParametersAgainstClient(HttpServletRequest req, InMessageContext inMsgCtx, Client client) throws AccessTokenRequestException {
        if (StringUtils.isBlank((String)client.getClientId()) || !client.isEnabled()) {
            if (StringUtils.isNotBlank((String)client.getClientId()) && !client.isEnabled()) {
                AsAuditLogger.setDescription("The client is disabled.");
            }
            String msg = "Client authentication (if the client has credentials) or the " + Parameters.CLIENT_ID + " parameter is required for an authorization request using the Device Authorization grant type.";
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_client);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, msg, 401);
        }
        if (StringUtils.isNotBlank((String)client.getClientId()) && !client.isGrantTypeAllowed("urn:ietf:params:oauth:grant-type:device_code")) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.unauthorized_client);
            String msg = "urn:ietf:params:oauth:grant-type:device_code grant not allowed for this client";
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.unauthorized_client, msg, 400);
        }
        Scope scope = this.checkScope(inMsgCtx, client);
        this.checkAuthorizationDetails(inMsgCtx, client, req, scope);
        AsAuditLogger.setInMsgCtx(req, client, "urn:ietf:params:oauth:grant-type:device_code");
    }

    @Override
    protected String getRealmName() {
        return "PF AS Device Authorization Endpoint";
    }

    @Override
    protected String getEndpointName() {
        return "Device Authorization Endpoint";
    }

    private Scope checkScope(InMessageContext inMsgCtx, Client client) throws AccessTokenRequestException {
        String scopeParam = inMsgCtx.getParam(Parameters.SCOPE);
        if (StringUtils.isNotBlank((String)scopeParam)) {
            try {
                Scope requestedScope = Scope.getScope((String)scopeParam);
                ScopeUtil.validateRequestedScope(requestedScope, client);
                return requestedScope;
            }
            catch (InvalidRequestedScopeException e) {
                AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_scope);
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_scope, e.getMessage());
            }
        }
        return new Scope(new String[0]);
    }

    private Scope getScope(InMessageContext inMsgCtx) {
        Scope requestedScope = new Scope(new String[0]);
        String scopeParam = inMsgCtx.getParam(Parameters.SCOPE);
        if (StringUtils.isNotBlank((String)scopeParam)) {
            requestedScope = Scope.getScope((String)scopeParam);
        }
        return requestedScope;
    }

    private void checkAuthorizationDetails(InMessageContext inMsgCtx, Client client, HttpServletRequest request, Scope scope) throws AccessTokenRequestException {
        String authorizationDetailsParam = inMsgCtx.getParam("authorization_details");
        if (StringUtils.isNotBlank((String)authorizationDetailsParam)) {
            try {
                AuthorizationDetails authorizationDetails = new AuthorizationDetails(authorizationDetailsParam);
                AuthorizationDetailsUtil.validate(authorizationDetails, client, request, scope);
            }
            catch (IOException | InvalidAuthorizationDetailException e) {
                AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_authorization_details);
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_authorization_details, e.getMessage());
            }
        }
    }
}

