/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.IssuedAccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.oauth20.domain.PersistentGrantHelper;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.token.AccessTokenResponse;
import org.sourceid.openid.connect.IdTokenSupport;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AuthenticationSessionValidator;
import org.sourceid.saml20.domain.mgmt.impl.AuthnSessionValidationException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class HandlerUtil {
    private static final Log log = LogFactory.getLog(HandlerUtil.class);
    private static final Pattern UP_NAVIGATION_PATTERN = Pattern.compile("[/\\\\]\\.\\.([/\\\\]|\\Z)");
    private static final List<String> RESERVED_ATTRIBUTES = List.of("aud", "authorization_details", Parameters.CLIENT_ID, Parameters.CLIENT_SECRET, "exp", "expires_in", "iss", "iat", "jti", "nbf", Parameters.SCOPE, "sub", "token_type", "username");

    @Deprecated
    static void tokenResponseToOutContext(OutMessageContext outMsgCtx, AccessTokenResponse accessTokenResponse) {
        accessTokenResponse.tokenResponseToOutContext(outMsgCtx);
    }

    static void setParamWhenNotNull(OutMessageContext outCtx, String name, Object value) {
        HandlerUtil.setParamWhenNotNull(outCtx, name, value, false);
    }

    static void setParamWhenNotNull(OutMessageContext outCtx, String name, Object value, boolean mask) {
        if (value != null) {
            outCtx.setParam(name, value, mask);
        }
    }

    public static AccessTokenResponse mapAttrsAndIssue(HttpServletRequest req, InMessageContext inMsgCtx, AccessGrantAttributesHolder grantAttrsHolder, AccessGrant accessGrant, AuthzServerManager asmgr, BearerAccessTokenMgmtPluginManager tmgr, Scope scope, boolean includeScopeInResp, Client client, String sri, String grantType, AuthorizationDetails authorizationDetails, Set<String> resources) throws AuthorizationException, InvalidRequestParameterException, AttrLookupException {
        String userKey = accessGrant.getUniqueUserIdentifer();
        String ctxQualifier = accessGrant.getContextualQualifier();
        ContextUtil contextUtil = new ContextUtil();
        ContextUtil.Ctx ctx = contextUtil.splitForAccessGrant(accessGrant.getContextualQualifier());
        if (ctx != null && ctx.getQualifier() != null && ctx.getOAuthSourceId() != null) {
            ctxQualifier = contextUtil.buildQualifiedId(ctx.getQualifier(), ctx.getOAuthSourceId());
        }
        TokenManagerSelector selector = new TokenManagerSelector();
        String tokenManagerId = selector.selectTokenManagerId(selector.getEligibleTokenManagerIdsForContext(ctxQualifier), inMsgCtx, resources, scope, client);
        AttributeMap attributes = HandlerUtil.mapToAccessTokenAttrs(userKey, grantAttrsHolder, ctxQualifier, scope, client, req, tokenManagerId, asmgr, tmgr, accessGrant, grantType, authorizationDetails, resources, sri);
        HandlerUtil.extractTokenEndpointAttributesFromAttributeMap(scope, client, tokenManagerId, tmgr, attributes);
        BearerAccessTokenMgmtPluginInstance atm = (BearerAccessTokenMgmtPluginInstance)tmgr.getInstance(tokenManagerId);
        HandlerUtil.validateAndSetSri(sri, attributes, atm);
        IssuedAccessToken token = tmgr.issueAccessToken(tokenManagerId, (Map<String, AttributeValue>)attributes, scope, client, accessGrant, authorizationDetails);
        String scopeStr = includeScopeInResp ? scope.getScopeStr() : null;
        AsAuditLogger.setAccessTokenTrackingId(token.getTokenValue());
        AsAuditLogger.setOutAccessTokenHash(token.getTokenValue());
        AsAuditLogger.setAccessGrantGuid(accessGrant.getGuid());
        return new AccessTokenResponse(token.getTokenValue(), token.getTokenType(), token.getExpiresAt(), scopeStr, null, authorizationDetails);
    }

    public static AccessTokenResponse mapAndIssueTokens(HttpServletRequest req, InMessageContext inMsgCtx, AccessGrantAttributesHolder holder, AccessGrant accessGrant, Scope scope, Client client, String sri, String grantType, AuthzServerManager authzServerManager, BearerAccessTokenMgmtPluginManager atmPluginManager, ConnectProviderRuntimePolicySupport oidcPolicySupport, IdTokenSupport idTokenSupport, OAuthIssuerUtils oAuthIssuerUtils, AuthorizationDetails authorizationDetails, Set<String> resources) throws AuthorizationException, InvalidRequestParameterException, AttrLookupException, AuthnSessionValidationException {
        String userKey = accessGrant.getUniqueUserIdentifer();
        String ctxQualifier = accessGrant.getContextualQualifier();
        ContextUtil contextUtil = new ContextUtil();
        ContextUtil.Ctx ctx = contextUtil.splitForAccessGrant(accessGrant.getContextualQualifier());
        if (ctx != null && ctx.getQualifier() != null && ctx.getOAuthSourceId() != null) {
            ctxQualifier = contextUtil.buildQualifiedId(ctx.getQualifier(), ctx.getOAuthSourceId());
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        TokenManagerSelector selector = new TokenManagerSelector();
        Collection<String> eligibleTokenManagerIds = selector.getEligibleTokenManagerIdsForContext(ctxQualifier);
        String tokenManagerId = selector.selectTokenManagerId(eligibleTokenManagerIds, inMsgCtx, resources, scope, client);
        AttributeMap attributes = HandlerUtil.mapToAccessTokenAttrs(userKey, holder, ctxQualifier, scope, client, req, tokenManagerId, authzServerManager, atmPluginManager, accessGrant, grantType, authorizationDetails, resources, sri);
        BearerAccessTokenMgmtPluginManager tokenManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        BearerAccessTokenMgmtPluginInstance atm = (BearerAccessTokenMgmtPluginInstance)tokenManager.getInstance(tokenManagerId);
        AuthenticationSessionValidator authenticationSessionValidator = new AuthenticationSessionValidator(StateMgmtFactory.getSessionRevocationService());
        authenticationSessionValidator.handleSessionValidation(atm, sri);
        HandlerUtil.validateAndSetSri(sri, attributes, atm);
        DpopUtil.addJwkThumbprintConfirmationMethodToAttributeMap(attributes, inMsgCtx.getParam("dpop_jkt"));
        IssuedAccessToken token = atmPluginManager.issueAccessToken(tokenManagerId, (Map<String, AttributeValue>)attributes, scope, client, accessGrant, authorizationDetails);
        boolean oidcProviderEnabled = oidcPolicySupport.getConnectProviderPolicyManager().getPolicy() != null && oidcPolicySupport.getConnectProviderPolicyManager().getPolicy().isEnabled();
        boolean openIdScopePresent = scope.hasScope("openid");
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = oidcPolicySupport.getPolicyGroup(client, false);
        if (oidcProviderEnabled && openIdScopePresent && policyGroup != null && policyGroup.isReturnIdTokenOnRefreshGrant()) {
            String issuer = oAuthIssuerUtils.getIssuerValue(req);
            AttributeMap grantAttrs = PersistentGrantHelper.getGrantAttributeMap(userKey, holder, accessGrant, client, authzServerManager);
            String idToken = idTokenSupport.makeToken(attributes, client, scope, req, issuer, null, false, grantAttrs, sri, policyGroup);
            additionalParameters.put("id_token", idToken);
        }
        AsAuditLogger.setAccessTokenTrackingId(token.getTokenValue());
        AsAuditLogger.setOutAccessTokenHash(token.getTokenValue());
        AsAuditLogger.setAccessGrantGuid(accessGrant.getGuid());
        return new AccessTokenResponse(token.getTokenValue(), token.getTokenType(), token.getExpiresAt(), null, null, additionalParameters, null, authorizationDetails);
    }

    public static AttributeMap mapToAccessTokenAttrs(String userKey, AccessGrantAttributesHolder grantAttrsHolder, String contextQualifier, Scope scope, Client client, HttpServletRequest req, String tokenManagerId, AuthzServerManager asmgr, BearerAccessTokenMgmtPluginManager tmgr, AccessGrant accessGrant, String grantType, AuthorizationDetails authorizationDetails, Set<String> resources, String sri) throws AttrLookupException, AuthorizationException {
        BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)tmgr.getInstance(tokenManagerId);
        if (instance != null && !instance.isClientAllowed(client != null ? client.getClientId() : null)) {
            String msg = "Access to the specified token manager '" + tokenManagerId + "' is restricted";
            log.debug((Object)msg);
            throw new AuthorizationException(msg, msg);
        }
        AttributeMap ctxAttrs = new AttributeMap();
        if (scope != null) {
            ctxAttrs.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue((Collection)scope.getScopeSet()));
        }
        if (authorizationDetails != null && authorizationDetails.getDetails() != null) {
            ctxAttrs.put(SourceContextType.OAUTH_AUTHORIZATION_DETAILS.getId(), authorizationDetails.toAttributeValue());
        }
        if (CollectionUtils.isNotEmpty(resources)) {
            ctxAttrs.put(SourceContextType.OAUTH_RESOURCES.getId(), new AttributeValue(resources));
        }
        if (client != null) {
            ctxAttrs.put(SourceContextType.OAUTH_CLIENT.getId(), client.getClientId());
            HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), ctxAttrs);
        }
        ctxAttrs.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
        ctxAttrs.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        ctxAttrs.put(SourceContextType.SRI.getId(), sri);
        UserKeyToAccessTokenMapping userKeyToAccessTokenMapping = asmgr.getUserKeyToAccessTokenMapping(contextQualifier, tokenManagerId);
        if (userKeyToAccessTokenMapping == null) {
            userKeyToAccessTokenMapping = asmgr.getDefaultUserKeyToAccessTokenMapping(tokenManagerId);
        }
        if (userKeyToAccessTokenMapping != null) {
            return userKeyToAccessTokenMapping.execMapping(userKey, grantAttrsHolder, ctxAttrs, accessGrant, grantType);
        }
        log.error((Object)("Default Access Token mapping not configured for the selected token manager '" + tokenManagerId + "'."));
        return new AttributeMap();
    }

    public static AttributeMap extractTokenEndpointAttributesFromAttributeMap(Scope scope, Client client, String tokenManagerId, BearerAccessTokenMgmtPluginManager tmgr, AttributeMap allAttrs) throws AuthorizationException {
        BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)tmgr.getInstance(tokenManagerId);
        if (instance != null && !instance.isClientAllowed(client != null ? client.getClientId() : null)) {
            String msg = "Access to the specified token manager '" + tokenManagerId + "' is restricted";
            log.debug((Object)msg);
            throw new AuthorizationException(msg, msg);
        }
        AttributeMap tokenEndpointAttrs = new AttributeMap();
        Iterator iterator = allAttrs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            block5: {
                block6: {
                    entry = (Map.Entry)iterator.next();
                    if (!instance.getTokenEndpointAttributeContract().attributeExists((String)entry.getKey())) break block5;
                    Set<String> mappedScopes = instance.getTokenEndpointAttributeContract().getMappedScopes().get(entry.getKey());
                    if (mappedScopes == null) break block6;
                    if (!mappedScopes.stream().anyMatch(arg_0 -> ((Scope)scope.expanded()).hasScope(arg_0))) break block5;
                }
                tokenEndpointAttrs.put((String)entry.getKey(), (AttributeValue)entry.getValue());
            }
            if (instance.getAttributeContract().attributeExists((String)entry.getKey()) || RESERVED_ATTRIBUTES.contains(entry.getKey())) continue;
            iterator.remove();
        }
        return tokenEndpointAttrs;
    }

    public static void addExtPropertiesToAttrMap(Map<String, ParamValues> extendedPropertiesMap, AttributeMap ctxAttrs) {
        for (Map.Entry<String, ParamValues> extendedParamEntry : extendedPropertiesMap.entrySet()) {
            ParamValues paramValues = extendedParamEntry.getValue();
            if (paramValues == null || paramValues.getElements().isEmpty()) continue;
            ctxAttrs.put("extproperties." + extendedParamEntry.getKey(), new AttributeValue((Collection)paramValues.getElements()));
            ctxAttrs.put("extclientmetadata." + extendedParamEntry.getKey(), new AttributeValue((Collection)paramValues.getElements()));
        }
    }

    public static String formatExceptionMessage(Enum error, String message) {
        boolean hasError = error != null;
        boolean hasMsg = message != null;
        return (Serializable)(hasError ? error : "") + (hasError & hasMsg ? ": " : "") + (hasMsg ? message : "");
    }

    public static HttpServletRequest checkUiLocalesForRequest(InMessageContext inMsgCtx, HttpServletRequest req) {
        String uiLocals = inMsgCtx.getParam("ui_locales");
        if (StringUtils.isNotBlank((String)uiLocals)) {
            req = LocaleUtil.createLocaleWrappedRequest(req, uiLocals);
        }
        return req;
    }

    private static void validateAndSetSri(String sri, AttributeMap attributes, BearerAccessTokenMgmtPluginInstance atm) {
        if (atm != null && atm.isIssueSri() && sri != null) {
            attributes.put("pi.sri", sri);
        }
    }
}

