/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.ProxyScoping;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.partner.C2CMappingDb;
import org.sourceid.saml20.metadata.partner.C2CMappingDbEntryResult;
import org.sourceid.saml20.metadata.partner.ConnectionDb;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.authn.MappedAuthnSourcesAndApcs;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;

public class OAuthAdapterSupport
extends AuthnSourceSupportBase {
    private final AuthzServerManager authzServerMgr;
    private final ConnectionManager connectionManager;
    private final ConnectionDb connectionDb;
    private final C2CMappingDb c2CMappingDb;
    private final MetadataDirectory metadataDirectory;
    private final MetadataLocal localMetaData;
    private final ContextUtil contextUtil = new ContextUtil();

    public OAuthAdapterSupport(AuthzServerManager authzServerMgr, ConnectionManager connectionManager, ConnectionDb connectionDb, C2CMappingDb c2CMappingDb, MetadataDirectory metadataDirectory, MetadataLocal localMetaData) {
        this.authzServerMgr = authzServerMgr;
        this.connectionManager = connectionManager;
        this.connectionDb = connectionDb;
        this.c2CMappingDb = c2CMappingDb;
        this.metadataDirectory = metadataDirectory;
        this.localMetaData = localMetaData;
    }

    @Override
    protected MappedAuthnSourcesAndApcs getMappedSources(HttpServletRequest req, Map<String, Object> stateParams, BaseMessageContext messageContext, ProxyScoping proxyScoping) {
        AuthnSourceKey sourceKey;
        Client client;
        MutableBoolean allowAllContexts = new MutableBoolean();
        allowAllContexts.setValue(true);
        HashSet<String> allowedContextIds = new HashSet<String>();
        if (messageContext.getEntityId() != null && (client = MgmtFactory.getClientManager().getCachedClient(messageContext.getEntityId())) != null) {
            allowAllContexts.setValue(false);
            UserKeyToAccessTokenMapping.determineAllowedContexts(client, allowAllContexts, allowedContextIds);
        }
        HashSet<AuthnSourceKey> authnSourceKeys = new HashSet<AuthnSourceKey>();
        HashSet<String> apcIds = new HashSet<String>();
        if (MetadataLocalHelper.isEnableIdp(this.localMetaData)) {
            Collection<IdpAuthnAdapterInstance> idpAuthnAdapterInstances = this.adapterManager.getIdpAuthnAdapterNonConnectionBasedInstances();
            for (IdpAuthnAdapterInstance adapterInstance : idpAuthnAdapterInstances) {
                if (this.authzServerMgr.getAdapterToUserKeyMapping(adapterInstance.getId()) == null || !this.checkAuthnSourceKeyAllowed(sourceKey = new AdapterAuthnSourceKey(adapterInstance.getId()), allowAllContexts.booleanValue(), allowedContextIds)) continue;
                authnSourceKeys.add(sourceKey);
            }
        }
        if (MetadataLocalHelper.isEnableSp(this.localMetaData)) {
            Collection<ConnectionDbEntry> entries = this.connectionDb.getActiveEntriesWithAnSSOToOAuthAttrMapping();
            for (ConnectionDbEntry entry : entries) {
                sourceKey = new IdpConnAuthnSourceKey(entry.getId());
                if (!this.checkAuthnSourceKeyAllowed(sourceKey, allowAllContexts.booleanValue(), allowedContextIds)) continue;
                authnSourceKeys.add(sourceKey);
            }
            entries = this.connectionDb.getActiveEntriesWithAnOAuthApcId();
            for (ConnectionDbEntry entry : entries) {
                ApcToUserKeyAttrMapping apcPgMapping = this.authzServerMgr.getApcToUserKeyMapping(entry.getOAuthApcId());
                if (apcPgMapping == null || !this.checkApcIdAllowed(entry.getOAuthApcId(), allowAllContexts.booleanValue(), allowedContextIds)) continue;
                authnSourceKeys.add(new IdpConnAuthnSourceKey(entry.getId()));
            }
            for (ApcToUserKeyAttrMapping apcAttrMapping : this.authzServerMgr.getApcToUserKeyMappings()) {
                block4: for (C2CMappingDbEntryResult c2CMappingDbEntry : this.c2CMappingDb.getEntriesByContractId(apcAttrMapping.getApcId())) {
                    IdpConnection conn;
                    if (!c2CMappingDbEntry.getConnType().equals((Object)Role.IDP) || !c2CMappingDbEntry.getActive() || (conn = this.connectionManager.getIdpConnectionBySystemId(c2CMappingDbEntry.getSystemId())) == null || !this.connectionManager.passesFilterByServerSettings(conn, false) || conn.hasOAuthApcId() || conn.hasSsoToOAuthAttrMapping()) continue;
                    String idpConnVsid = VirtualIdentityUtil.resolve(null, conn, true).getVirtualEntityId(DomainMode.RUNTIME);
                    for (C2cContractAttributeMapping mapping : conn.getC2cContractMappings()) {
                        if (!mapping.getContractId().equals(apcAttrMapping.getApcId()) || mapping.isRestrictVirtualServerIds() && idpConnVsid != null && !mapping.getRestrictedVirtualServerIds().contains(idpConnVsid)) continue;
                        if (!this.checkApcIdAllowed(mapping.getContractId(), allowAllContexts.booleanValue(), allowedContextIds)) continue block4;
                        authnSourceKeys.add(new IdpConnAuthnSourceKey(c2CMappingDbEntry.getSystemId()));
                        continue block4;
                    }
                }
            }
        }
        for (ApcToUserKeyAttrMapping apcMapping : MgmtFactory.getAuthzServerManager().getApcToUserKeyMappings()) {
            if (!this.checkApcIdAllowed(apcMapping.getApcId(), allowAllContexts.booleanValue(), allowedContextIds)) continue;
            apcIds.add(apcMapping.getApcId());
        }
        return new MappedAuthnSourcesAndApcs(authnSourceKeys, apcIds);
    }

    @Override
    protected void putExtraParametersToSelectContext(Map<String, Object> extraParameters, Map<String, Object> stateParams, InMessageContext inMsgCtx) {
        String authorizationDetails;
        String scope = inMsgCtx.getParam(Parameters.SCOPE);
        if (scope != null) {
            extraParameters.put("com.pingidentity.sdk.AdapterSelector.scope", scope);
        }
        if ((authorizationDetails = inMsgCtx.getParam("authorization_details")) != null) {
            extraParameters.put("com.pingidentity.sdk.AdapterSelector.authorizationDetails", authorizationDetails);
        }
    }

    public void setCookieWithIdpId(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, IdpConnection idp) {
        this.setCookie(req, resp, stateParams, this.toCookieValue(idp));
    }

    @Override
    protected String makeNoMappingErrMsg(Map<String, Object> stateParams, String escapedParam) {
        StringBuilder sb = new StringBuilder();
        sb.append("IdpAdapterId").append(" or ").append("idp").append(" was specified as ").append(escapedParam);
        sb.append(" but no mapping exists for that adapter or idp.");
        return sb.toString();
    }

    @Override
    protected void addApplicationNameImage(Map<String, Object> stateParams, AuthnSourceKey authnSourceKey) {
        String clientId = (String)stateParams.get(Parameters.CLIENT_ID);
        Client client = MgmtFactory.getClientManager().getCachedClient(clientId);
        if (client != null) {
            if (StringUtils.isNotBlank((String)client.getName())) {
                stateParams.put("applicationName", client.getName());
            }
            if (StringUtils.isNotBlank((String)client.getLogoUrl())) {
                stateParams.put("applicationIcon", client.getLogoUrl());
            }
        }
    }

    @Override
    protected AuthnSourceKey getAuthnSourceFromStartEndpoint(HttpServletRequest req) {
        String idp = ProprietaryURLParams.getParam(req, "idp", "PartnerIdpId");
        if (idp != null) {
            IdpConnection idpConn = this.metadataDirectory.getIdpConnection(idp, false);
            if (idpConn != null) {
                return new IdpConnAuthnSourceKey(idpConn.getId());
            }
            return null;
        }
        return super.getAuthnSourceFromStartEndpoint(req);
    }

    private String getContextId(AuthnSourceKey sourceKey) {
        switch (sourceKey.getType()) {
            case ADAPTER: {
                return this.contextUtil.buildQualifiedId("authz_req", new OAuthSourceId(OAuthSourceId.Type.ADAPTER, sourceKey.getId()));
            }
            case IDP_CONN: {
                return this.contextUtil.buildQualifiedId("authz_req", new OAuthSourceId(OAuthSourceId.Type.IDP_CONNECTION, sourceKey.getId()));
            }
        }
        throw new ProcessRuntimeException("Unexpected source key type: " + sourceKey.getType());
    }

    private String getApcContextId(String apcId) {
        return this.contextUtil.buildQualifiedId("authz_req", new OAuthSourceId(OAuthSourceId.Type.APC, apcId));
    }

    private boolean checkAuthnSourceKeyAllowed(AuthnSourceKey sourceKey, boolean allowAllContexts, Set<String> allowedContextIds) {
        if (allowAllContexts) {
            return true;
        }
        return allowedContextIds.contains(this.getContextId(sourceKey));
    }

    private boolean checkApcIdAllowed(String apcId, boolean allowAllContexts, Set<String> allowedContextIds) {
        if (allowAllContexts) {
            return true;
        }
        return allowedContextIds.contains(this.getApcContextId(apcId));
    }
}

