/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.common.util.TrackedParamsUtil;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.sourceid.common.SpaceDelimitedStringUtil;
import org.sourceid.common.Util;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.handlers.AttributesHolder;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.OAuthAdapterSupport;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.model.Prompt;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.C2CMappingDb;
import org.sourceid.saml20.metadata.partner.ConnectionDb;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.servlet.QuietException;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.InvalidOidcResponseException;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumableRequestHandlerBase;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.idp.SsoRespSupport;
import org.sourceid.websso.profiles.sp.ResumeRequestFromResponseSupport;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.servlet.SessionIdUtil;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class OAuthResumableRequestHandlerBase
extends ResumableRequestHandlerBase
implements ResumeRequestFromAuthnResponseHandler {
    public static final String CONTEXT_QUALIFIER_NAME = "ctxQ";
    public static final String USER_KEY_ATTR_NAME = "UK";
    public static final String USER_ATTRS_KEY = "attrs";
    public static final String CSRF_TOKEN_KEY = "csrfToken";
    public static final String AUTHN_BEANS_KEY = "authn-bean";
    public static final String AUTHN_POLICY_KEY = "AuthnPolicy";
    public static final String FLOW_CREATION_TIME_MILLIS_KEY = "ORRHB.FlowCreationTimeMillis";
    public static final String CURRENT_SERVER_BASE_URL = "currentServerBaseUrl";
    protected final AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();
    private final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private final ConnectionDb connectionDb = MgmtFactory.getConnectionDb();
    private final C2CMappingDb c2CMappingDb = MgmtFactory.getC2CMappingDb();
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private final OAuthAdapterSupport authenticationSupport = new OAuthAdapterSupport(this.authzServerMgr, this.connectionManager, this.connectionDb, this.c2CMappingDb, this.metadataDirectory, this.localMetaData);
    protected AccessGrantManager accessGrantMgr = MgmtFactory.getAccessGrantManager();
    protected SsoRespSupport ssoRespSupport = new SsoRespSupport();
    protected ConnectProviderRuntimePolicySupport policySupport = new ConnectProviderRuntimePolicySupport();
    private final BindingService bindingSvc = MgmtFactory.getBindingService();
    private final ClientManager clientManager = MgmtFactory.getClientManager();
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();
    private final ContextUtil contextUtil = new ContextUtil();

    @Override
    public void resumeAuthn(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws IOException {
        try {
            this.resume(inMsgCtx, req, resp, outMsgCtx, otherState);
        }
        catch (IOException | RequestProcessingException e) {
            this.handleException(req, resp, inMsgCtx, outMsgCtx, otherState, e);
        }
    }

    @Override
    public void resumeSsoFromIdp(IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, InMessageContext reqInMsgCtx, OutMessageContext respOutMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue) {
        throw new UnsupportedOperationException("resumeSsoFromIdp not implemented");
    }

    @Override
    public boolean isAuthnApiHandlesException(HttpServletRequest req, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        return AuthnApiPolicyUtil.getDefault().isRedirectlessApiFlow(stateParams) || this.ssoRespSupport.isHandleFailuresLocally(outMsgCtx);
    }

    @Override
    public boolean isAuthnApiHandlesResult(HttpServletRequest req, Map<String, Object> stateParams) {
        return AuthnApiPolicyUtil.getDefault().isRedirectlessApiFlow(stateParams);
    }

    @Override
    protected void resume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException {
        OAuthIssuer oauthIssuer;
        if (inMsgCtx != null && (oauthIssuer = inMsgCtx.getOauthIssuer()) != null) {
            this.oAuthIssuerUtils.addOAuthIssuerToRequest(req, oauthIssuer);
        }
        super.resume(inMsgCtx, req, resp, outMsgCtx, otherState);
    }

    @Override
    protected void exeResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException {
        if (outMsgCtx.getParam("error") == null) {
            this.checkDoPreAuthnStep(inMsgCtx, req, resp, outMsgCtx, otherState);
            if (resp.isCommitted()) {
                return;
            }
            AttributesHolder userAttrs = (AttributesHolder)otherState.get(USER_ATTRS_KEY);
            if (userAttrs == null) {
                userAttrs = this.resumeUserAuthn(inMsgCtx, req, resp, outMsgCtx, otherState);
            }
            if (userAttrs != null) {
                this.doIt(inMsgCtx, req, resp, outMsgCtx, otherState, userAttrs);
            }
        }
    }

    protected void checkDoPreAuthnStep(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException {
    }

    @Override
    protected boolean isStateAppropriate(State state) {
        return true;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        OutMessageContext outMessageContext = new OutMessageContext(inMsgCtx.getRoleType());
        outMessageContext.setOauthIssuer(inMsgCtx.getOauthIssuer());
        return outMessageContext;
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        HashMap<String, Object> otherState = new HashMap<String, Object>();
        String clientId = inMsgCtx.getEntityId();
        otherState.put(Parameters.CLIENT_ID, clientId);
        Client client = this.clientManager.getCachedClient(clientId);
        if (client != null && StringUtils.isNotBlank((String)client.getName())) {
            otherState.put(AdapterDefaultTemplateParams.CLIENT_NAME.getParamName(), client.getName());
        }
        otherState.put("request", inMsgCtx.getParam("request", Map.class));
        otherState.put(Parameters.SCOPE, inMsgCtx.getParam(Parameters.SCOPE));
        otherState.put("authorization_details", inMsgCtx.getParam("authorization_details"));
        otherState.put(FLOW_CREATION_TIME_MILLIS_KEY, System.currentTimeMillis());
        this.addTrackedParams(req, inMsgCtx.getParam("request", Map.class), otherState);
        String policyAction = ProprietaryURLParams.getParam(req, "PolicyAction");
        otherState.put("PolicyAction", policyAction);
        String oidcUiLocales = inMsgCtx.getParam("ui_locales");
        if (StringUtils.isNotBlank((String)oidcUiLocales)) {
            otherState.put("ui_locales", oidcUiLocales);
        }
        this.resume(inMsgCtx, req, resp, outMsgCtx, otherState);
    }

    private void addTrackedParams(HttpServletRequest req, Map<String, Object> reqParamMap, Map<String, Object> stateParams) {
        this.addTrackedParams(req, stateParams);
        if (StringUtils.isNotBlank((String)req.getParameter("request_uri"))) {
            TrackedParamsUtil trackedParamsUtil = new TrackedParamsUtil();
            trackedParamsUtil.amendTrackedParamsToState(reqParamMap, stateParams);
        }
    }

    IdpConnection getIdp(OutMessageContext ssoReqMsgCtx) {
        return this.metadataDirectory.getIdpConnection(ssoReqMsgCtx.getEntityId(), true);
    }

    public boolean resumeFromException(InvalidResponseException e, OutMessageContext ssoReqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.hasOAuthSuppCtx(ssoReqMsgCtx)) {
            return false;
        }
        State state = ResumeRequestFromResponseSupport.getSupplementalFedHubState(ssoReqMsgCtx);
        if (state != null) {
            InMessageContext inMsgCtx = state.getInMsgCtx();
            OutMessageContext outMsgCtx = state.getOutMsgCtx();
            Map<String, Object> stateParams = state.getParameters();
            this.handleEx(e, inMsgCtx, outMsgCtx, stateParams, req, resp);
            boolean authnSelectionInProgress = ResumeRequestFromResponseSupport.isAuthnSelectionInProgress(stateParams);
            StateSupport.overridePath(req, this.getOriginalResumeUrl(ssoReqMsgCtx, stateParams, authnSelectionInProgress));
            if (authnSelectionInProgress) {
                outMsgCtx.getParams().remove("error");
                outMsgCtx.getParams().remove("error_description");
                stateParams.put("AuthnSelectionTreeIdpConnComplete", Boolean.TRUE);
                try {
                    this.exeResume(inMsgCtx, req, resp, outMsgCtx, stateParams);
                }
                catch (GeneralAdapterException | GeneralServiceException | RequestProcessingException e1) {
                    this.handleEx(e, inMsgCtx, outMsgCtx, stateParams, req, resp);
                }
            }
            if (!resp.isCommitted()) {
                if (ssoReqMsgCtx.getParam("error") != null) {
                    outMsgCtx.setParam("error", ssoReqMsgCtx.getParam("error"));
                    outMsgCtx.setParam("error_description", ssoReqMsgCtx.getParam("error_description"));
                }
                try {
                    this.bindingSvc.transportResponse(req, resp, inMsgCtx, outMsgCtx);
                }
                catch (BindingException | RedirectException | RenderPageException ex) {
                    String msg = "Unexpected Problem sending error response.";
                    throw new IOException(msg, e);
                }
            }
            return true;
        }
        return false;
    }

    private String getOriginalResumeUrl(OutMessageContext ssoReqMsgCtx, Map<String, Object> stateParams, boolean authnSelectionInProgress) {
        if (authnSelectionInProgress) {
            return (String)stateParams.get("authnPolicyInitialResumeUrl");
        }
        return ssoReqMsgCtx.getTargetResource();
    }

    public boolean hasOAuthSuppCtx(OutMessageContext ssoReqMsgCtx) {
        if (ssoReqMsgCtx == null) {
            return false;
        }
        Object dummy = ssoReqMsgCtx.getSupplementalContext(this.getSupplementalContextKeyName());
        return dummy != null;
    }

    public boolean resumeFromSso(OutMessageContext ssoReqMsgCtx, HttpServletRequest req, HttpServletResponse resp, IdpConnHashableAuthnBean authnBean, AttributeMap idpConnCtxAttrs) throws IOException {
        if (!this.hasOAuthSuppCtx(ssoReqMsgCtx)) {
            return false;
        }
        State state = ResumeRequestFromResponseSupport.getSupplementalFedHubState(ssoReqMsgCtx);
        if (state != null) {
            InMessageContext inMsgCtx = state.getInMsgCtx();
            OutMessageContext outMsgCtx = state.getOutMsgCtx();
            Map<String, Object> stateParams = state.getParameters();
            try {
                boolean authnSelectionInProgress = ResumeRequestFromResponseSupport.isAuthnSelectionInProgress(stateParams);
                StateSupport.overridePath(req, this.getOriginalResumeUrl(ssoReqMsgCtx, stateParams, authnSelectionInProgress));
                IdpConnection idp = this.getIdp(ssoReqMsgCtx);
                IdpConnAuthnSourceKey idpAuthnSourceKey = new IdpConnAuthnSourceKey(idp.getId());
                this.authenticationSupport.callbackToAuthnSelector(req, resp, idpAuthnSourceKey, authnBean, stateParams);
                if (authnSelectionInProgress) {
                    stateParams.put("AuthnSelectionTreeIdpConnComplete", Boolean.TRUE);
                    stateParams.put("AuthnSelectionTreeReturnedIdpConnAuthnBean", authnBean);
                } else {
                    Integer maxAge = inMsgCtx.getParam("max_age", Integer.class);
                    if (maxAge != null) {
                        long authnTime;
                        Long authnTimeObj = this.ssoRespSupport.getSamlAuthnInstantInMills(authnBean.getAssertionAttrs());
                        long l = authnTime = authnTimeObj == null ? 0L : authnTimeObj;
                        if (this.exceedsMaxAge(maxAge, authnTime, stateParams)) {
                            AuthnPolicy authnPolicy = this.getAuthnPolicy(inMsgCtx);
                            if (!authnPolicy.reauthenticate()) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("Authn instant of " + authnTime + " is older than " + maxAge + " seconds, restarting authentication with sessions ignored"));
                                }
                                this.authnPolicyWithForceAuthn(authnPolicy, inMsgCtx);
                                String resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, stateParams);
                                resp.sendRedirect(resumePath);
                                return true;
                            }
                            long diffMills = this.ellapsedTimeFromAuthn(authnTime);
                            if (authnTimeObj == null) {
                                this.log.warn((Object)"Authentication failed: max_age was specified, but no adapter returned a value for the 'org.sourceid.saml20.adapter.idp.authn.authnInst' attribute.");
                            }
                            throw this.unmeetableMaxAgeAuthorizationRequestEx(authnTime, diffMills, maxAge);
                        }
                    }
                    AttributeMap oauthContextAttributes = this.getContextAttributeMap(inMsgCtx, req, resp, stateParams);
                    this.addAuthorizationDetailsToContextAttributes(inMsgCtx, req, oauthContextAttributes);
                    IdpAuthenticationResult authnResult = new IdpAuthenticationResult(new IdpHashableAuthnBean[]{authnBean}, authnBean.getAssertionAttrs(), false, null);
                    AttributesHolder holder = this.mapOAuthAttrsFromIdp(idp, authnResult, oauthContextAttributes, idpConnCtxAttrs, inMsgCtx, outMsgCtx);
                    stateParams.put(USER_ATTRS_KEY, holder);
                    outMsgCtx.setSupplementalContext(USER_ATTRS_KEY, holder);
                    stateParams.put(AUTHN_BEANS_KEY, authnResult.getAuthnBeans());
                    this.authenticationSupport.setCookieWithIdpId(req, resp, stateParams, idp);
                }
                this.exeResume(inMsgCtx, req, resp, outMsgCtx, stateParams);
            }
            catch (Exception e) {
                this.logFailure(e, outMsgCtx);
                if (!(e.getCause() instanceof QuietException)) {
                    this.logEx(e);
                }
                this.handleEx(e, inMsgCtx, outMsgCtx, stateParams, req, resp);
            }
            if (!resp.isCommitted()) {
                if (ssoReqMsgCtx.getParam("error") != null) {
                    outMsgCtx.setParam("error", ssoReqMsgCtx.getParam("error"));
                    outMsgCtx.setParam("error_description", ssoReqMsgCtx.getParam("error_description"));
                }
                String resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, stateParams);
                resp.sendRedirect(resumePath);
            }
            return true;
        }
        return false;
    }

    private void setSuppCtxCtxQual(OutMessageContext outMsgCtx, OAuthSourceId oauthSourceId) {
        String value = this.contextUtil.buildQualifiedId("authz_req", oauthSourceId);
        outMsgCtx.setSupplementalContext(CONTEXT_QUALIFIER_NAME, value);
    }

    AttributesHolder mapOAuthAttributes(HttpServletRequest req, IdpAuthenticationResult authnResult, AttributeMap contextAttributes, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) throws RequestProcessingException {
        AttributeMap authnAttrs = authnResult.getAuthnAttrs();
        try {
            if (authnResult.isFromAuthnSelectionApc()) {
                String apcId = authnResult.getSourceMappingId();
                ApcToUserKeyAttrMapping attrMapping = this.authzServerMgr.getApcToUserKeyMapping(apcId);
                UserKeyAttributes userKeyAttributes = attrMapping.execMapping(authnAttrs, contextAttributes, this.isSkipAuthorization());
                this.setSuppCtxCtxQual(outMsgCtx, new OAuthSourceId(OAuthSourceId.Type.APC, apcId));
                return new AttributesHolder(authnResult, userKeyAttributes);
            }
            AuthnSourceKey authnSourceKey = authnResult.getLastAuthnSourceKey();
            if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
                IdpConnection idp = this.metadataDirectory.getIdpConnectionBySystemId(authnSourceKey.getId(), true);
                org.sourceid.websso.profiles.sp.SsoRespSupport spRespSupport = new org.sourceid.websso.profiles.sp.SsoRespSupport(MetaDataFactory.getLocalMetaData());
                return this.mapOAuthAttrsFromIdp(idp, authnResult, contextAttributes, spRespSupport.makeIdpConnContextAttributes(authnResult.getMappedIdpConnBean(), req), inMsgCtx, outMsgCtx);
            }
            String instanceId = authnSourceKey.getId();
            UserKeyAttrMapping attrMapping = this.authzServerMgr.getAdapterToUserKeyMapping(instanceId);
            UserKeyAttributes userKeyAttributes = attrMapping.execMapping(authnResult.getAuthnAttrs(), contextAttributes, this.isSkipAuthorization());
            this.setSuppCtxCtxQual(outMsgCtx, new OAuthSourceId(OAuthSourceId.Type.ADAPTER, authnResult.getLastAuthnSourceKey().getId()));
            return new AttributesHolder(authnResult, userKeyAttributes);
        }
        catch (AttrLookupException | AuthorizationException e) {
            throw new RequestProcessingException(e.getMessage(), e);
        }
    }

    private AttributesHolder mapOAuthAttrsFromIdp(IdpConnection idp, IdpAuthenticationResult authnResult, AttributeMap oauthContextAttributes, AttributeMap idpConnCtxAttrs, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) throws AttrLookupException, AuthorizationException {
        AttributeMap assertionAttrs;
        UserKeyAttributes resourceOwnerAttrs = null;
        if (idp.hasSsoToOAuthAttrMapping()) {
            assertionAttrs = authnResult.getAuthnAttrs();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Mapping attributes from IdP connection '" + idp.getEntityId() + "' to persistent grant using its OAuth attribute mapping."));
            }
        } else {
            if (idp.hasOAuthApcId()) {
                String apcId = idp.getOAuthApcId();
                return this.mapIdpConnToUserKey(apcId, idp, authnResult, oauthContextAttributes, idpConnCtxAttrs, outMsgCtx);
            }
            if (idp.hasC2cContractMappings()) {
                MutableBoolean allowAllContexts = new MutableBoolean();
                HashSet<String> allowedContextIds = new HashSet<String>();
                this.determineAllowedContexts(inMsgCtx, allowAllContexts, allowedContextIds);
                IdpConnHashableAuthnBean bean = authnResult.getMappedIdpConnBean();
                String idpConnVsid = bean != null ? bean.getVirtualServerId() : null;
                for (C2cContractAttributeMapping c2cAttrMapping : idp.getC2cContractMappings()) {
                    if (c2cAttrMapping.isRestrictVirtualServerIds() && idpConnVsid != null && !c2cAttrMapping.getRestrictedVirtualServerIds().contains(idpConnVsid)) continue;
                    String c2cId = c2cAttrMapping.getContractId();
                    if (MgmtFactory.getAuthzServerManager().getApcToUserKeyMapping(c2cId) == null || !allowAllContexts.booleanValue() && !allowedContextIds.contains(this.getApcContextId(c2cId))) continue;
                    return this.mapIdpConnToUserKey(c2cId, idp, authnResult, oauthContextAttributes, idpConnCtxAttrs, outMsgCtx);
                }
                throw new AuthorizationException("Authorization failed", "No policy contract found mapped to an OAuth grant");
            }
            throw new AuthorizationException("Authorization failed", "Unable to map attributes to persistent grant");
        }
        resourceOwnerAttrs = idp.mapOAuthAttributesFromSso(assertionAttrs, oauthContextAttributes, this.isSkipAuthorization());
        this.setSuppCtxCtxQual(outMsgCtx, new OAuthSourceId(OAuthSourceId.Type.IDP_CONNECTION, idp.getId()));
        return new AttributesHolder(authnResult, resourceOwnerAttrs);
    }

    private void determineAllowedContexts(InMessageContext inMsgCtx, MutableBoolean allowAllContexts, Set<String> allowedContextIds) {
        allowAllContexts.setValue(true);
        if (inMsgCtx.getEntityId() == null) {
            return;
        }
        Client client = MgmtFactory.getClientManager().getCachedClient(inMsgCtx.getEntityId());
        if (client == null) {
            return;
        }
        allowAllContexts.setValue(false);
        UserKeyToAccessTokenMapping.determineAllowedContexts(client, allowAllContexts, allowedContextIds);
    }

    private String getApcContextId(String apcId) {
        return this.contextUtil.buildQualifiedId("authz_req", new OAuthSourceId(OAuthSourceId.Type.APC, apcId));
    }

    private AttributesHolder mapIdpConnToUserKey(String apcId, IdpConnection idp, IdpAuthenticationResult authnResult, AttributeMap oauthContextAttributes, AttributeMap idpConnCtxAttrs, OutMessageContext outMsgCtx) throws AttrLookupException, AuthorizationException {
        AttributeMap assertionAttrs = authnResult.getAuthnAttrs();
        ApcToUserKeyAttrMapping apc2UserKeyMapping = MgmtFactory.getAuthzServerManager().getApcToUserKeyMapping(apcId);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Mapping attributes from IdP connection '" + idp.getEntityId() + "' to APC '" + apcId + "'."));
        }
        AttributeMap apcAttrs = idp.executeC2cMapping(assertionAttrs, apcId, idpConnCtxAttrs);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Mapping attributes from APC '" + idp.getEntityId() + "' to persistent grant."));
        }
        UserKeyAttributes resourceOwnerAttrs = apc2UserKeyMapping.execMapping(apcAttrs, oauthContextAttributes, this.isSkipAuthorization());
        this.setSuppCtxCtxQual(outMsgCtx, new OAuthSourceId(OAuthSourceId.Type.APC, apcId));
        IdpAuthenticationResult apcIdpAuthnResult = new IdpAuthenticationResult(authnResult.getAuthnBeans(), apcAttrs, authnResult.isFromAuthnSelectionApc(), authnResult.getSourceMappingId());
        return new AttributesHolder(apcIdpAuthnResult, resourceOwnerAttrs);
    }

    private AuthorizationRequestException unmeetableMaxAgeAuthorizationRequestEx(long authnInstantInMills, long diffMills, int maxAge) {
        String age = authnInstantInMills == 0L ? "unknown" : String.valueOf(diffMills / 1000L);
        String msg = "Unable to accommodate the requested maximum authentication age - the requested max_age was " + maxAge + " while the actual age is " + age + " (in seconds)";
        return new AuthorizationRequestException(AuthorizationRequestException.Error.access_denied, msg);
    }

    private AuthnPolicy authnPolicyWithForceAuthn(AuthnPolicy authnPolicy, InMessageContext inMsgCtx) {
        authnPolicy = new AuthnPolicy(authnPolicy.allowUserInteraction(), true, authnPolicy.getRequestAuthnContexts());
        inMsgCtx.setParam(AUTHN_POLICY_KEY, authnPolicy);
        return authnPolicy;
    }

    private boolean exceedsMaxAge(Integer maxAge, long authTime, Map<String, Object> otherState) {
        long expiryTime = authTime + TimeUnit.SECONDS.toMillis(maxAge.intValue());
        long requestTime = System.currentTimeMillis();
        Long flowCreationTime = (Long)otherState.get(FLOW_CREATION_TIME_MILLIS_KEY);
        if (flowCreationTime != null) {
            requestTime = flowCreationTime;
        }
        return requestTime > expiryTime;
    }

    private long ellapsedTimeFromAuthn(long authnTime) {
        return System.currentTimeMillis() - authnTime;
    }

    AttributesHolder resumeUserAuthn(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws IOException, AuthnAdapterException, RequestProcessingException {
        IdpAuthenticationResult authnResult;
        AuthnPolicy authnPolicy;
        boolean lookupAuthnAgain;
        outMsgCtx.setSupplementalContext(this.getSupplementalContextKeyName(), Boolean.TRUE);
        do {
            lookupAuthnAgain = false;
            authnPolicy = this.getAuthnPolicy(inMsgCtx);
            String resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, otherState);
            req = HandlerUtil.checkUiLocalesForRequest(inMsgCtx, req);
            String loginHint = inMsgCtx.getParam("login_hint");
            if (StringUtils.isNotBlank((String)loginHint)) {
                otherState.put("suid", loginHint);
            }
            try {
                long authnTime;
                Integer maxAge;
                AsAuditLogger.setPartnerId(inMsgCtx.getEntityId());
                authnResult = this.authenticationSupport.lookupAuthNs(req, resp, authnPolicy, resumePath, otherState, inMsgCtx, outMsgCtx, this, this.isAdapterLogoutRequired());
                if (resp.isCommitted() || authnResult == null || Util.isEmpty(authnResult.getAuthnAttrs()) || (maxAge = inMsgCtx.getParam("max_age", Integer.class)) == null) continue;
                Long authnInstant = this.ssoRespSupport.getLatestAuthnInstantValue(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans());
                long l = authnTime = authnInstant == null ? 0L : authnInstant;
                if (!this.exceedsMaxAge(maxAge, authnTime, otherState)) continue;
                if (!authnPolicy.reauthenticate()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Authn instant of " + authnTime + " is older than " + maxAge + " seconds, restarting authentication with sessions ignored"));
                    }
                    authnPolicy = this.authnPolicyWithForceAuthn(authnPolicy, inMsgCtx);
                    lookupAuthnAgain = true;
                    this.authenticationSupport.cleanUpStateParams(otherState);
                    resumePath = this.stateSupport.insertNonce(resumePath);
                    StateSupport.overridePath(req, resumePath);
                    continue;
                }
                long diffMills = this.ellapsedTimeFromAuthn(authnTime);
                if (authnInstant == null) {
                    this.log.warn((Object)"Authentication failed: max_age was specified, but no adapter returned a value for the 'org.sourceid.saml20.adapter.idp.authn.authnInst' attribute.");
                }
                throw this.unmeetableMaxAgeAuthorizationRequestEx(authnTime, diffMills, maxAge);
            }
            catch (AuthnAdapterException.NoMappedAdapters e) {
                this.log.error((Object)"There are no mapped authentication sources to choose from. Please map an IdP Adapter or IdP connection first.");
                AuthnAdapterException exception = new AuthnAdapterException("There are no authentication methods available for OAuth.", (Throwable)e);
                exception.setAllowMessagePropagation(true);
                throw exception;
            }
            catch (AuthorizationException | AuthnProcessorException e) {
                throw new RequestProcessingException(e.getMessage(), e);
            }
        } while (lookupAuthnAgain);
        if (!resp.isCommitted()) {
            if (authnResult == null || Util.isEmpty(authnResult.getAuthnAttrs())) {
                String errorDescription;
                AuthorizationRequestException.Error errorCode;
                boolean allowUserInteraction = authnPolicy.allowUserInteraction();
                if (allowUserInteraction) {
                    errorCode = AuthorizationRequestException.Error.access_denied;
                    errorDescription = "Authentication failed.";
                } else {
                    errorCode = AuthorizationRequestException.Error.login_required;
                    errorDescription = "Authentication is required.";
                }
                AsAuditLogger.setPartnerId(inMsgCtx.getEntityId());
                AsAuditLogger.setDescription(errorCode);
                throw new AuthorizationRequestException(errorCode, errorDescription);
            }
            AttributeMap contextAttributes = this.getContextAttributeMap(inMsgCtx, req, resp, otherState);
            AuthorizationDetails authorizationDetails = this.addAuthorizationDetailsToContextAttributes(inMsgCtx, req, contextAttributes);
            AuthorizationDetailsUtil.updateOtherState(otherState, authorizationDetails);
            AttributesHolder attributesHolder = this.mapOAuthAttributes(req, authnResult, contextAttributes, inMsgCtx, outMsgCtx);
            otherState.put(USER_ATTRS_KEY, attributesHolder);
            outMsgCtx.setSupplementalContext(USER_ATTRS_KEY, attributesHolder);
            otherState.put(AUTHN_BEANS_KEY, authnResult.getAuthnBeans());
            String baseUrl = MetaDataFactory.getLocalMetaData().getBaseUrl();
            String currentBaseUrl = this.oAuthIssuerUtils.getIssuerValue(req);
            if (!baseUrl.equals(currentBaseUrl)) {
                otherState.put(CURRENT_SERVER_BASE_URL, currentBaseUrl);
            }
            return attributesHolder;
        }
        return null;
    }

    private AuthorizationDetails addAuthorizationDetailsToContextAttributes(InMessageContext inMsgCtx, HttpServletRequest req, AttributeMap contextAttributes) throws AuthorizationRequestException {
        String requestedAuthorizationDetailsString = inMsgCtx.getParam("authorization_details");
        if (StringUtils.isNotBlank((String)requestedAuthorizationDetailsString)) {
            try {
                String requestedScopeStr = inMsgCtx.getParam(Parameters.SCOPE);
                Scope requestedScope = Scope.getScope((String)requestedScopeStr);
                AuthorizationDetails requestedAuthorizationDetails = new AuthorizationDetails(requestedAuthorizationDetailsString);
                AuthorizationDetailsUtil.enrich(requestedAuthorizationDetails, req, inMsgCtx.getEntityId(), requestedScope);
                contextAttributes.put(SourceContextType.OAUTH_AUTHORIZATION_DETAILS.getId(), requestedAuthorizationDetails.toAttributeValue());
                return requestedAuthorizationDetails;
            }
            catch (IOException e) {
                this.log.debug((Object)("unable to add context attribute: " + requestedAuthorizationDetailsString), (Throwable)e);
            }
        }
        return null;
    }

    protected boolean isAdapterLogoutRequired() {
        OpenIdConnectProviderPolicy providerPolicy = this.policySupport.getConnectProviderPolicyManager().getPolicy();
        return providerPolicy.isTrackUserSessionsForLogout();
    }

    private AttributeMap getContextAttributeMap(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams) {
        String claimsLocalesString;
        String requestedScopeStr = inMsgCtx.getParam(Parameters.SCOPE);
        Scope requestedScope = Scope.getScope((String)requestedScopeStr);
        AttributeMap contextAttributes = new AttributeMap();
        contextAttributes.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue((Collection)requestedScope.getScopeSet()));
        contextAttributes.put(SourceContextType.OAUTH_CLIENT.getId(), new AttributeValue(inMsgCtx.getEntityId()));
        contextAttributes.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(req.getRemoteAddr()));
        contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        contextAttributes.put(SourceContextType.SRI.getId(), SessionIdUtil.getInstance().getExtendedSriV2(req, resp, stateParams));
        if (StringUtils.isNotBlank((String)inMsgCtx.getEntityId())) {
            Client client = this.clientManager.getCachedClient(inMsgCtx.getEntityId());
            String defaultPersistentGrantLifetime = String.valueOf(PersistentGrantLifetimeHelper.getPersistentGrantExpirationTimeSettingInMins(client, this.authzServerMgr));
            contextAttributes.put(SourceContextType.OAUTH_DEFAULT_PERSISTENT_GRANT_LIFETIME.getId(), defaultPersistentGrantLifetime);
        }
        if (StringUtils.isNotBlank((String)(claimsLocalesString = inMsgCtx.getParam("claims_locales")))) {
            List claimsLocales = SpaceDelimitedStringUtil.fromString((String)claimsLocalesString);
            contextAttributes.put(SourceContextType.CLAIMS_LOCALES.getId(), new AttributeValue((Collection)claimsLocales));
        }
        this.addExtendedClientMetadataToAttrMap(inMsgCtx, contextAttributes);
        return contextAttributes;
    }

    private void addExtendedClientMetadataToAttrMap(InMessageContext inMsgCtx, AttributeMap contextAttributes) {
        String partnerId = inMsgCtx.getEntityId();
        Client client = this.clientManager.getCachedClient(partnerId);
        if (client != null) {
            HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), contextAttributes);
        }
    }

    abstract void doIt(InMessageContext var1, HttpServletRequest var2, HttpServletResponse var3, OutMessageContext var4, Map<String, Object> var5, AttributesHolder var6) throws AuthorizationRequestException, IOException;

    abstract String getSupplementalContextKeyName();

    abstract boolean isSkipAuthorization();

    @Override
    protected void logEx(Exception e) {
        if (e.getCause() == null && AuthorizationRequestException.class.isInstance(e)) {
            this.log.debug((Object)("Normal exception being handled during OAuth request processing: " + e));
        } else {
            super.logEx(e);
        }
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String message;
        this.ssoRespSupport.handleException(e, inMsgCtx, outMsgCtx, stateParams, req, resp, Role.IDP);
        if (resp.isCommitted()) {
            return;
        }
        outMsgCtx.getParams().clear();
        if (e instanceof AuthorizationException) {
            outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.access_denied);
            outMsgCtx.setParam("error_description", LocaleUtil.getLocalizedString(req, "pingfederate-messages", ((AuthorizationException)e).getErrorDetail(), null));
        } else if (e instanceof InvalidRequestParameterException) {
            outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.invalid_request);
            outMsgCtx.setParam("error_description", e.getMessage());
        } else if (e.getCause() != null && e.getCause() instanceof AuthorizationException) {
            outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.access_denied);
            outMsgCtx.setParam("error_description", LocaleUtil.getLocalizedString(req, "pingfederate-messages", ((AuthorizationException)e.getCause()).getErrorDetail(), null));
        } else if (e instanceof AuthorizationRequestException) {
            AuthorizationRequestException authzReqEx = (AuthorizationRequestException)e;
            if (authzReqEx.getDescription() != null) {
                outMsgCtx.setParam("error_description", authzReqEx.getDescription());
            }
            if (authzReqEx.getError() != null) {
                outMsgCtx.setParam("error", (Object)authzReqEx.getError());
            } else if (!AuthnApiSupport.getDefault().isApiRequest(req)) {
                resp.sendError(400, e.getMessage());
            }
        } else if (e instanceof InvalidOidcResponseException) {
            outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.access_denied);
            outMsgCtx.setParam("error_description", e.getMessage());
        } else if (e instanceof InvalidSsoResponseException) {
            List<String> secondLevelStatusCodes = ((InvalidSsoResponseException)e).getSecondLevelStatusCodes();
            if (secondLevelStatusCodes.contains("urn:oasis:names:tc:SAML:2.0:status:NoPassive")) {
                outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.login_required);
            } else if (secondLevelStatusCodes.contains("urn:oasis:names:tc:SAML:2.0:status:AuthnFailed")) {
                outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.access_denied);
            } else {
                outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.server_error);
            }
            outMsgCtx.setParam("error_description", e.getMessage());
        } else if (e instanceof RequestProcessingException) {
            outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.server_error);
            if (e.getCause() != null && e.getCause() instanceof AuthnAdapterException) {
                message = e.getMessage() != null ? e.getMessage() : e.toString();
                outMsgCtx.setParam("error_description", message);
            }
        } else if (e instanceof AuthnAdapterException) {
            outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.server_error);
            message = "Unexpected Runtime Authn Adapter Integration Problem.";
            if (((AuthnAdapterException)((Object)e)).isAllowMessagePropagation()) {
                message = e.getMessage();
            }
            outMsgCtx.setParam("error_description", message);
        } else {
            outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.server_error);
        }
        if (StringUtils.isBlank((String)outMsgCtx.getAdapterId())) {
            String adapterId = AuthnPolicyUtil.getDefault().getNonConnBasedAdapterId(req, stateParams);
            outMsgCtx.setAdapterId(adapterId == null ? "Unknown" : adapterId);
        }
        if (AuthnApiSupport.getDefault().isApiRequest(req) && InternalAuthnApiSupport.getDefault().getAuthnAPIOAuthFlowID(req) == null) {
            this.sendAuthnApiErrorResponse(outMsgCtx, req, resp);
        }
    }

    private void sendAuthnApiErrorResponse(OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AuthorizationRequestException.Error error = (AuthorizationRequestException.Error)((Object)outMsgCtx.getParams().get("error"));
        if (error == null) {
            error = AuthorizationRequestException.Error.server_error;
        }
        String errorDescription = outMsgCtx.getParam("error_description");
        AuthnApiSupport.getDefault().writeErrorResponse(req, resp, CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(new AuthnErrorDetail.Builder().code(error.toString()).message(errorDescription).userMessage(errorDescription).build()).build());
    }

    protected Prompt getPrompt(InMessageContext inCtx) throws AuthorizationRequestException {
        String rawPrompt = inCtx.getParam("prompt", String.class);
        return new Prompt(rawPrompt);
    }

    AuthnPolicy getAuthnPolicy(InMessageContext inCtx) throws AuthorizationRequestException {
        AuthnPolicy authnPolicy = inCtx.getParam(AUTHN_POLICY_KEY, AuthnPolicy.class);
        if (authnPolicy == null) {
            Prompt prompt = this.getPrompt(inCtx);
            String acrValues = inCtx.getParam("acr_values");
            List contexts = new ArrayList();
            if (acrValues != null) {
                contexts = SpaceDelimitedStringUtil.fromString((String)acrValues);
            }
            authnPolicy = new AuthnPolicy(!prompt.isNone(), prompt.isLogin(), prompt.isCreate(), contexts);
        }
        return authnPolicy;
    }

    public OAuthIssuerUtils getoAuthIssuerUtils() {
        return this.oAuthIssuerUtils;
    }
}

