/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.common.util.Base64URL;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.websso.Protocol;

public class OAuthSourceId {
    private final Type type;
    private final String id;

    public OAuthSourceId(Type type, String id) {
        this.type = type;
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public String getRealId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthSourceId other = (OAuthSourceId)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        String prefix = this.type.prefix;
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix);
        }
        if (this.id != null) {
            builder.append(this.id);
        }
        return builder.toString();
    }

    public static OAuthSourceId fromString(String rawId, String qualifier) {
        Type type = null;
        if (rawId.startsWith(Type.IDP_CONNECTION.getPrefix())) {
            type = Type.IDP_CONNECTION;
        } else if (rawId.startsWith(Type.LEGACY_IDP_CONNECTION.getPrefix())) {
            type = Type.LEGACY_IDP_CONNECTION;
        } else if (rawId.startsWith(Type.APC.getPrefix())) {
            type = Type.APC;
        } else if (qualifier.equals("authz_req")) {
            type = Type.ADAPTER;
        } else if (qualifier.equals("password")) {
            type = Type.PCV;
        } else if (qualifier.equals("urn:ietf:params:oauth:grant-type:token-exchange")) {
            type = Type.TOKEN_EXCHANGE_PROCESSOR_POLICY;
        } else {
            throw new IllegalArgumentException();
        }
        String prefix = type.getPrefix();
        String realId = rawId;
        if (prefix != null) {
            realId = rawId.substring(prefix.length());
        }
        return new OAuthSourceId(type, realId);
    }

    public static IdpConnection getIdpConnFromLegacyId(OAuthSourceId sourceId) {
        if (sourceId.getType() != Type.LEGACY_IDP_CONNECTION) {
            return null;
        }
        MetadataDirectory mdDir = MetaDataFactory.getMetadataDirectory();
        byte[] connSourceId = Base64URL.decode((String)sourceId.getRealId());
        String entityId = null;
        try {
            entityId = mdDir.getEntityId(connSourceId, Protocol.values());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entityId != null) {
            return mdDir.getIdpConnection(entityId, false);
        }
        return null;
    }

    public static enum Type {
        ADAPTER(null),
        PCV(null),
        LEGACY_IDP_CONNECTION("idp."),
        IDP_CONNECTION("idp.v2."),
        APC("apc."),
        TOKEN_EXCHANGE_PROCESSOR_POLICY(null);

        private final String prefix;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

