/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.common.util.SizeBoundedLinkedHashMap;
import java.util.Map;

public class PollingIntervalRegulator {
    private static final int TIME = 0;
    private static final int COUNT = 1;
    private final Map<String, long[]> stateMap;
    private final int warningCount;
    private final int allowanceMills;

    public PollingIntervalRegulator(int maxEntries, int warningCount, int allowanceMills) {
        this.warningCount = warningCount;
        this.allowanceMills = allowanceMills;
        this.stateMap = new SizeBoundedLinkedHashMap<String, long[]>(maxEntries, true, maxEntries);
    }

    public Situation regulate(String id, int expectedIntervalSeconds) {
        return this.regulate(id, expectedIntervalSeconds, System.currentTimeMillis());
    }

    synchronized Situation regulate(String id, int expectedIntervalSeconds, long now) {
        Situation theSituation = Situation.OK;
        long expectedIntervalMs = expectedIntervalSeconds * 1000;
        long[] lastRequestData = this.stateMap.get(id);
        lastRequestData = lastRequestData == null ? new long[2] : lastRequestData;
        long[] currentRequestData = new long[2];
        currentRequestData[0] = now;
        long elapsedMills = currentRequestData[0] - lastRequestData[0];
        if (elapsedMills < expectedIntervalMs - (long)this.allowanceMills) {
            currentRequestData[1] = lastRequestData[1] + 1L;
            theSituation = currentRequestData[1] > (long)this.warningCount ? Situation.FAIL : Situation.WARN;
        }
        this.stateMap.put(id, currentRequestData);
        return theSituation;
    }

    public synchronized void done(String id) {
        this.stateMap.remove(id);
    }

    public static enum Situation {
        OK,
        WARN,
        FAIL;

    }
}

