/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.common.util.Base64URL;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.dpop.InvalidDpopProofException;
import org.sourceid.oauth20.dpop.UseDpopNonceException;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.BaseClientAuthnRequestHandler;
import org.sourceid.oauth20.handlers.GeneralOAuthError;
import org.sourceid.openid.connect.AuthorizationRequestSupport;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.ArtifactPersistenceServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestHandlerBase;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class PushedAuthorizationRequestHandler
extends RequestHandlerBase {
    public static final String BASE_URN = "urn:ietf:params:oauth:request_uri:";
    private final ArtifactPersistenceService persistenceSvc = StateMgmtFactory.getArtifactPersistenceService();
    private final AuthorizationRequestSupport authzReqSupport = new AuthorizationRequestSupport();
    private final ClientManager clientManager = MgmtFactory.getClientManager();
    private final AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        return new OutMessageContext(inMsgCtx.getRoleType());
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        String clientId = inMsgCtx.getEntityId();
        Client client = this.clientManager.getCachedClient(clientId);
        try {
            this.authzReqSupport.generalRequestProcessing(client, inMsgCtx, outMsgCtx, req);
            this.validateDpopProof(req, inMsgCtx);
            ArtifactPersistenceService.Message message = new ArtifactPersistenceService.Message(inMsgCtx.getParams());
            ParServerPolicy parServerPolicy = this.authzServerManager.getParServerPolicy();
            message.setMessageHandleLength(parServerPolicy.getReferenceLength());
            int timeoutSeconds = parServerPolicy.getTimeoutSeconds();
            message.setEntityId(clientId);
            ArtifactPersistenceService.Handle handle = this.persistenceSvc.saveArtifact(message, timeoutSeconds);
            String requestUri = BASE_URN + Base64URL.encodeToString((byte[])handle.getMessageHandle());
            outMsgCtx.setParam("request_uri", requestUri);
            outMsgCtx.setParam("expires_in", timeoutSeconds);
        }
        catch (ArtifactPersistenceServiceException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.server_error, "Unable to store PAR message", e);
        }
        finally {
            DpopUtil.addDpopNonceToHeader(req, client.isRequireDpop(), (arg_0, arg_1) -> ((HttpServletResponse)resp).setHeader(arg_0, arg_1));
        }
        resp.setStatus(201);
        AuditLogger.setStatus("success");
        AsAuditLogger.setInMsgCtx(client, inMsgCtx);
        AsAuditLogger.setOutMsgCtx(outMsgCtx);
        AsAuditLogger.log("PAR successfully received");
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) {
        if (!(e instanceof GeneralOAuthError)) {
            throw new ProcessRuntimeException("Unexpected error occurred handling Pushed Authorization Request", e);
        }
        BaseClientAuthnRequestHandler.errorCondition(resp, outMsgCtx, (GeneralOAuthError)((Object)e), this.log, "Pushed Authorization Request", "AS");
    }

    @Override
    protected void handleException(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, Exception e) {
        this.handleEx(e, inMsgCtx, outMsgCtx, stateParams, req, resp);
    }

    private void validateDpopProof(HttpServletRequest req, InMessageContext inMsgCtx) throws AccessTokenRequestException {
        String jwkThumbprintFromDpopProof;
        try {
            jwkThumbprintFromDpopProof = DpopUtil.validateDpopProofInHeader(req, false);
        }
        catch (InvalidDpopProofException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_dpop_proof, e.getMessage());
        }
        catch (UseDpopNonceException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.use_dpop_nonce, e.getMessage());
        }
        String dpopJktFromRequest = inMsgCtx.getParam("dpop_jkt");
        if (jwkThumbprintFromDpopProof != null && dpopJktFromRequest == null) {
            inMsgCtx.setParam("dpop_jkt", jwkThumbprintFromDpopProof);
            return;
        }
        if (jwkThumbprintFromDpopProof != null && !DpopUtil.isJwkThumbprintMatching(jwkThumbprintFromDpopProof, dpopJktFromRequest)) {
            AsAuditLogger.setDescription("The public key in DPoP proof does not match the dpop_jkt parameter");
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_dpop_proof, "The public key in DPoP proof does not match the dpop_jkt parameter");
        }
    }
}

