/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.common.security.LockingService;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantCriteria;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.IssuedAccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwa.AlgorithmFactory;
import org.jose4j.jwa.AlgorithmFactoryFactory;
import org.jose4j.jwe.KeyManagementAlgorithm;
import org.jose4j.jws.JsonWebSignatureAlgorithm;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.lang.InvalidAlgorithmException;
import org.sourceid.common.Util;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.authorizationdetails.domain.InvalidAuthorizationDetailException;
import org.sourceid.oauth20.consent.OAuthConsentManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.InvalidRequestedScopeException;
import org.sourceid.oauth20.domain.PersistentGrantHelper;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.dpop.InvalidDpopProofException;
import org.sourceid.oauth20.dpop.UseDpopNonceException;
import org.sourceid.oauth20.exchange.manager.TokenExchangeGeneratorPolicyManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.AuthenticationClaimHolder;
import org.sourceid.oauth20.handlers.BaseClientAuthnRequestHandler;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.ServerErrorException;
import org.sourceid.oauth20.handlers.process.AuthzCodeGrantProcessor;
import org.sourceid.oauth20.handlers.process.ClientCredentialsGrantProcessor;
import org.sourceid.oauth20.handlers.process.DeviceCodeGrantProcessor;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.handlers.process.JwtGrantProcessor;
import org.sourceid.oauth20.handlers.process.RefreshTokenGrantProcessor;
import org.sourceid.oauth20.handlers.process.ResourceOwnerPwdCredsGrantProcessor;
import org.sourceid.oauth20.handlers.process.SAML2GrantProcessor;
import org.sourceid.oauth20.handlers.process.TokenExchangeGrantProcessor;
import org.sourceid.oauth20.handlers.process.ValidateBearerAccessTokenProcessor;
import org.sourceid.oauth20.handlers.process.exchange.execution.TokenExchangeExecutionStrategy;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.GrantTypes;
import org.sourceid.oauth20.protocol.HttpsJwksCache;
import org.sourceid.oauth20.protocol.InternalPersistentGrantAttributes;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.token.AccessTokenResponse;
import org.sourceid.oauth20.token.JdbcGrantAttrForeignKeyException;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.oauth20.token.refresh.RefreshToken;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.oauth20.utils.ResourceIndicatorsUtils;
import org.sourceid.openid.ciba.handlers.CibaGrantProcessor;
import org.sourceid.openid.connect.IdTokenSupport;
import org.sourceid.openid.connect.OfflineAccessSupport;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.state.KeyValueStateSupport;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.SystemAttrLookupException;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class TokenEndpointRequestHandler
extends BaseClientAuthnRequestHandler {
    private static final List<String> ALLOWED_OFFLINE_ACCESS_GRANT_TYPES = Arrays.asList("authorization_code");
    public static final String ACCOUNT_LOCKED = "Account Locked";
    public static final String PASSWORD_LOCKED = "Password Locked";
    private final ClientManager clientMgr = GlobalRegistry.getService(ClientManager.class);
    private final BearerAccessTokenMgmtPluginManager tokenMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private final AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();
    private final AccessGrantManager accessGrantMgr = MgmtFactory.getAccessGrantManager();
    private final TokenExchangeProcessorPolicyManager processorPolicyMgr = MgmtFactory.getTokenExchangeProcessorPolicyManager();
    private final TokenExchangeGeneratorPolicyManager generatorPolicyMgr = MgmtFactory.getTokenExchangeGeneratorPolicyManager();
    private final TokenExchangeExecutionStrategy tokenExchangeExecutionStrategy = MgmtFactory.getTokenExchangeExecutionStrategy();
    private final ConnectProviderRuntimePolicySupport connectProviderRuntimePolicySupport;
    private final ArtifactPersistenceService artifactPersistenceService = StateMgmtFactory.getArtifactPersistenceService();
    private final PasswordCredentialValidatorManager credentialValidatorManager = MgmtFactory.getCredentialValidatorManager();
    private final OAuthConsentManager oAuthConsentManager = MgmtFactory.getOAuthConsentManager();
    private final IdTokenSupport idTokenSupport = new IdTokenSupport();
    private final OfflineAccessSupport offlineAccessSupport = new OfflineAccessSupport();
    private final ContextUtil contextUtil = new ContextUtil();
    private final Map<String, GrantProcessor> nativeProcessors = new HashMap<String, GrantProcessor>();

    public TokenEndpointRequestHandler() {
        super(OAuthIssuerUtils.getInstance());
        this.nativeProcessors.put("authorization_code", new AuthzCodeGrantProcessor(this.artifactPersistenceService, this.authzServerMgr, this.clientMgr));
        LockingService ropcLockingService = MgmtFactory.getAccountLockingService().getInstance(ResourceOwnerPwdCredsGrantProcessor.class.getSimpleName());
        this.nativeProcessors.put("password", new ResourceOwnerPwdCredsGrantProcessor(this.authzServerMgr, this.credentialValidatorManager, ropcLockingService));
        this.nativeProcessors.put("client_credentials", new ClientCredentialsGrantProcessor(this.authzServerMgr));
        ConnectProviderRuntimePolicySupport oidcPolicySupport = new ConnectProviderRuntimePolicySupport();
        this.nativeProcessors.put("refresh_token", new RefreshTokenGrantProcessor(this.tokenMgr, this.authzServerMgr, this.accessGrantMgr, this.clientMgr, oidcPolicySupport, this.idTokenSupport, this.getOAuthIssuerService(), this.oAuthConsentManager));
        this.nativeProcessors.put("urn:pingidentity.com:oauth2:grant_type:validate_bearer", new ValidateBearerAccessTokenProcessor(this.tokenMgr));
        this.nativeProcessors.put("urn:ietf:params:oauth:grant-type:saml2-bearer", new SAML2GrantProcessor(this.authzServerMgr));
        this.nativeProcessors.put("urn:ietf:params:oauth:grant-type:jwt-bearer", new JwtGrantProcessor(this.authzServerMgr, HttpsJwksCache.getInstance()));
        this.nativeProcessors.put("urn:openid:params:grant-type:ciba", new CibaGrantProcessor(this.clientMgr, this.authzServerMgr, this.oAuthConsentManager));
        ConfigStore config = ConfigStoreFarm.getConfig("oauth-device-flow");
        KeyValueStateSupport keyValueStateSupport = new KeyValueStateSupport();
        this.nativeProcessors.put("urn:ietf:params:oauth:grant-type:device_code", new DeviceCodeGrantProcessor(this.clientMgr, this.authzServerMgr, keyValueStateSupport, MgmtFactory.getDeviceFlowManager(), config));
        TokenExchangeGrantProcessor tokenExchange = new TokenExchangeGrantProcessor(this.processorPolicyMgr, this.generatorPolicyMgr, this.clientMgr, this.tokenMgr, this.tokenExchangeExecutionStrategy, this.authzServerMgr);
        this.nativeProcessors.put("urn:ietf:params:oauth:grant-type:token-exchange", tokenExchange);
        this.connectProviderRuntimePolicySupport = new ConnectProviderRuntimePolicySupport();
    }

    @Override
    protected void doProcess(InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Client client, HttpServletRequest req, HttpServletResponse resp) throws IOException, AccessTokenRequestException {
        try {
            String jwkThumbprint = DpopUtil.validateDpopProofInHeader(req, client.isRequireDpop());
            if (jwkThumbprint != null) {
                inMsgCtx.setParam("dpop_jkt", jwkThumbprint);
            }
            AccessTokenResponse accessTokenResponse = null;
            String grantType = inMsgCtx.getParam("grant_type");
            GrantProcessor processor = this.nativeProcessors.get(grantType);
            if (processor == null) {
                AsAuditLogger.setDescription(AccessTokenRequestException.Error.unsupported_grant_type);
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.unsupported_grant_type);
            }
            GrantContext context = this.processGrant(processor, inMsgCtx, req, resp, client, grantType);
            Scope scope = context.getScope();
            AuthorizationDetails authorizationDetails = context.getAuthorizationDetails();
            AccessGrant accessGrant = null;
            RefreshToken refreshToken = null;
            AttributeMap attributes = null;
            String expectedClientId = context.getContextClientId();
            if (expectedClientId != null) {
                Client expectedClient;
                AsAuditLogger.setPartnerId(expectedClientId);
                try {
                    expectedClient = this.clientMgr.getCachedClient(expectedClientId);
                }
                catch (ClientManager.ClientManagementException e) {
                    AsAuditLogger.log("Database Exception");
                    throw e;
                }
                if (expectedClient == null || !expectedClient.isEnabled()) {
                    if (expectedClient != null && !expectedClient.isEnabled()) {
                        AsAuditLogger.setDescription("The client is disabled.");
                    }
                    throw this.invalidClient("The client is no longer valid");
                }
                if (expectedClient.hasCredentials()) {
                    throw this.invalidClientCreds();
                }
                client = expectedClient;
            }
            AttributeMap tokenEndpointAttributes = new AttributeMap();
            if (context.canIssuePersistentGrant()) {
                String userKey = context.getUserKey();
                if (StringUtils.isBlank((String)userKey)) {
                    AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_grant);
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "No user key found in the context of this grant.");
                }
                boolean refreshGrantTypeAllowed = client.isGrantTypeAllowed("refresh_token");
                boolean issuePersistentGrantInContextOverride = PersistentGrantLifetimeHelper.isIssuePersistentGrantInContextOverride(context.getAccessGrantAttributes());
                boolean skipOfflineAccessRTIssuance = this.skipOfflineAccessRTIssuance(grantType, client, scope);
                if (!skipOfflineAccessRTIssuance && refreshGrantTypeAllowed && issuePersistentGrantInContextOverride) {
                    boolean reuseAccessGrant;
                    refreshToken = TokenUtil.generateNewRefreshToken(this.authzServerMgr, client);
                    boolean bl = reuseAccessGrant = client.isOverrideReusePersistentGrantType() ? client.isReusePersistentGrantTypeAllowed(grantType) : this.authzServerMgr.reuseExistingPersistentGrant(grantType);
                    if (reuseAccessGrant) {
                        AccessGrantCriteria accessGrantCriteria = new AccessGrantCriteria(userKey, scope, client.getClientId(), grantType, context.getContextQualifer(), authorizationDetails);
                        accessGrant = this.accessGrantMgr.getByAccessGrantCriteria(accessGrantCriteria);
                        if (accessGrant != null && !PersistentGrantLifetimeHelper.isWithinIdleTimeoutWindow(accessGrant)) {
                            this.accessGrantMgr.revokeGrant(accessGrant.getGuid());
                            accessGrant = null;
                        }
                        if (accessGrant != null) {
                            this.validateDpopProofOnReuseAccessGrant(client, inMsgCtx, accessGrant.getGuid());
                            refreshToken.store(accessGrant, context.getAccessGrantAttributes(), this.authzServerMgr, client);
                            this.accessGrantMgr.updateRefreshToken(accessGrant);
                            AccessGrantAttributesHolder accessGrantAttributesHolder = this.setSriInGrantAttributes(context);
                            if (!client.hasCredentials()) {
                                DpopUtil.addJwkThumbprintToAccessGrantAttributesHolder(accessGrantAttributesHolder, inMsgCtx.getParam("dpop_jkt"));
                            }
                            this.setResourcesInGrantAttributes(accessGrantAttributesHolder, context);
                            this.accessGrantMgr.updateGrantAttributes(accessGrant.getGuid(), accessGrantAttributesHolder);
                        }
                    }
                    if (accessGrant == null) {
                        String accessGrantQualifiedId = this.contextUtil.buildQualifiedIdForAccessGrant(context.getContextQualifer());
                        accessGrant = new AccessGrant(userKey, scope, client.getClientId(), grantType, accessGrantQualifiedId);
                        accessGrant.setAuthorizationDetails(authorizationDetails);
                        refreshToken.store(accessGrant, context.getAccessGrantAttributes(), this.authzServerMgr, client);
                        String persistentGrantLifetime = PersistentGrantLifetimeHelper.getPersistentGrantLifetimeInContextOverride(context.getAccessGrantAttributes());
                        PersistentGrantLifetimeHelper.setExpirationOnGrant(accessGrant, client, persistentGrantLifetime);
                        AccessGrantAttributesHolder accessGrantAttributesHolder = this.setSriInGrantAttributes(context);
                        if (!client.hasCredentials()) {
                            DpopUtil.addJwkThumbprintToAccessGrantAttributesHolder(accessGrantAttributesHolder, inMsgCtx.getParam("dpop_jkt"));
                        }
                        this.setResourcesInGrantAttributes(accessGrantAttributesHolder, context);
                        this.accessGrantMgr.saveGrant(accessGrant, accessGrantAttributesHolder);
                    }
                    AsAuditLogger.setAccessGrantGuid(accessGrant.getGuid());
                }
                attributes = HandlerUtil.mapToAccessTokenAttrs(userKey, context.getAccessGrantAttributes(), context.getContextQualifer(), context.getScope(), client, req, context.getTokenManagerId(), this.authzServerMgr, this.tokenMgr, accessGrant, grantType, context.getAuthorizationDetails(), context.getResourcesForMapping(), context.getSri());
                tokenEndpointAttributes = HandlerUtil.extractTokenEndpointAttributesFromAttributeMap(context.getScope(), client, context.getTokenManagerId(), this.tokenMgr, attributes);
                AuditLogger.setUserName(userKey);
                this.ensureAttributesExist(attributes);
                AsAuditLogger.setAttributes(attributes);
            } else if (context.hasAccessTokenResponse()) {
                accessTokenResponse = (AccessTokenResponse)context.getAccessTokenResponse();
            } else {
                attributes = context.getAttributes();
                tokenEndpointAttributes = HandlerUtil.extractTokenEndpointAttributesFromAttributeMap(context.getScope(), client, context.getTokenManagerId(), this.tokenMgr, attributes);
                this.ensureAttributesExist(attributes);
                AsAuditLogger.setAttributes(attributes);
            }
            if (accessTokenResponse == null) {
                try {
                    boolean issueNewIdToken;
                    BearerAccessTokenMgmtPluginInstance atmPluginInstance;
                    String sri = context.getSri();
                    BearerAccessTokenMgmtPluginInstance bearerAccessTokenMgmtPluginInstance = atmPluginInstance = context.getTokenManagerId() == null ? null : (BearerAccessTokenMgmtPluginInstance)this.tokenMgr.getInstance(context.getTokenManagerId());
                    if (attributes != null && sri != null && atmPluginInstance != null && atmPluginInstance.isIssueSri()) {
                        attributes.put("pi.sri", sri);
                    }
                    DpopUtil.addJwkThumbprintConfirmationMethodToAttributeMap(attributes, inMsgCtx.getParam("dpop_jkt"));
                    IssuedAccessToken token = this.tokenMgr.issueAccessToken(context.getTokenManagerId(), (Map<String, AttributeValue>)attributes, scope, client, accessGrant, authorizationDetails);
                    String tokenValue = token.getTokenValue();
                    String type = token.getTokenType();
                    Long expAt = token.getExpiresAt();
                    Map<String, Object> params = context.getAdditionalParameters();
                    AuthenticationClaimHolder authenticationClaimHolder = context.getAuthenticationClaims();
                    boolean bl = issueNewIdToken = this.checkReissueForHybridFlow(client, context) || this.checkReissueForNewClientSecret(req, client, scope, authenticationClaimHolder);
                    if (issueNewIdToken || context.isAllowIdToken() && scope.hasScope("openid")) {
                        String oidcPolicyId;
                        String issuer = this.getOAuthIssuerService().getIssuerValue(req);
                        AttributeMap grantAttrs = new AttributeMap();
                        if (context.getAccessGrantAttributes() != null) {
                            grantAttrs = PersistentGrantHelper.getGrantAttributeMap(context.getUserKey(), context.getAccessGrantAttributes(), accessGrant, client, this.authzServerMgr);
                        }
                        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (oidcPolicyId = context.getOidcPolicyId()) != null ? this.connectProviderRuntimePolicySupport.getConnectProviderPolicyManager().getPolicy().getPolicyGroup(oidcPolicyId) : this.connectProviderRuntimePolicySupport.getPolicyGroup(client);
                        String idToken = this.idTokenSupport.makeToken(attributes, client, scope, req, issuer, authenticationClaimHolder, false, grantAttrs, sri, policyGroup);
                        params = new HashMap<String, Object>(params);
                        params.put("id_token", idToken);
                    }
                    String scopeInResp = context.includeScopeInResponse() ? this.getResponseScopeString(context, scope) : null;
                    String requestedTokenType = StringUtils.isNotBlank((String)context.getRequestedTokenType()) ? context.getRequestedTokenType() : null;
                    String refreshTokenValue = refreshToken != null ? refreshToken.getValue() : null;
                    params = new HashMap<String, Object>(params);
                    if (atmPluginInstance != null) {
                        Set<String> multiValuedSet = atmPluginInstance.getTokenEndpointAttributeContract().getMultiValued();
                        ArrayList<String> multiValuedList = multiValuedSet != null ? new ArrayList<String>(multiValuedSet) : Collections.emptyList();
                        SimpleJsonRespWriter.prepareAttributeMap(tokenEndpointAttributes, params, multiValuedList);
                    }
                    accessTokenResponse = new AccessTokenResponse(tokenValue, type, expAt, scopeInResp, refreshTokenValue, params, requestedTokenType, authorizationDetails);
                    AsAuditLogger.setAccessTokenTrackingId(token.getTokenValue());
                    AsAuditLogger.setOutAccessTokenHash(token.getTokenValue());
                    if (StringUtils.isNotBlank((String)refreshTokenValue)) {
                        AsAuditLogger.setOutRefreshTokenHash(refreshTokenValue);
                    }
                }
                catch (RuntimeException re) {
                    AsAuditLogger.setDescription(AccessTokenRequestException.Error.server_error);
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.server_error, re.getMessage(), re);
                }
            }
            accessTokenResponse.tokenResponseToOutContext(outMsgCtx);
            this.auditLogSuccess(outMsgCtx, grantType);
        }
        catch (AccessGrantManagementException | JdbcGrantAttrForeignKeyException a) {
            AuditLogger.setStatus("failure");
            AsAuditLogger.setDescription("Access Grant Management Exception");
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("error", a.getMessage());
            AsAuditLogger.setOutMsgCtxWithErrors(error);
            AsAuditLogger.log("AccessGrantManagement Exception thrown: " + (RuntimeException)a);
            throw a;
        }
        catch (AttrLookupException | AuthorizationException e) {
            if (e.getCause() instanceof RuntimeException || e instanceof SystemAttrLookupException) {
                throw new ServerErrorException(e.getMessage());
            }
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, e.getMessage(), e);
        }
        catch (InvalidDpopProofException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_dpop_proof, e.getMessage());
        }
        catch (UseDpopNonceException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.use_dpop_nonce, e.getMessage());
        }
        finally {
            DpopUtil.addDpopNonceToHeader(req, client.isRequireDpop(), (arg_0, arg_1) -> ((HttpServletResponse)resp).setHeader(arg_0, arg_1));
        }
    }

    private boolean skipOfflineAccessRTIssuance(String grantType, Client client, Scope scope) {
        if (!ALLOWED_OFFLINE_ACCESS_GRANT_TYPES.contains(grantType)) {
            return false;
        }
        if (!this.offlineAccessSupport.isRequireOfflineAccessScopeToIssueRefreshToken(client)) {
            return false;
        }
        return !scope.hasScope("offline_access");
    }

    private AccessGrantAttributesHolder setSriInGrantAttributes(GrantContext<AccessTokenResponse> context) {
        AccessGrantAttributesHolder accessGrantAttributesHolder = context.getAccessGrantAttributes();
        if (context.getSri() != null) {
            AttributeMap extendedGrantAttrMap = new AttributeMap();
            AttributeMap authnContextAttrMap = null;
            if (accessGrantAttributesHolder != null) {
                if (accessGrantAttributesHolder.getExtendedGrantAttrs() != null) {
                    extendedGrantAttrMap = accessGrantAttributesHolder.getExtendedGrantAttrs();
                    extendedGrantAttrMap.putIfAbsent((Object)"pi.sri", (Object)new AttributeValue(context.getSri()));
                    return accessGrantAttributesHolder;
                }
                if (accessGrantAttributesHolder.getAuthnContextAttrs() != null) {
                    authnContextAttrMap = accessGrantAttributesHolder.getAuthnContextAttrs();
                }
            }
            extendedGrantAttrMap.put("pi.sri", context.getSri());
            accessGrantAttributesHolder = new AccessGrantAttributesHolder(extendedGrantAttrMap, authnContextAttrMap);
        }
        return accessGrantAttributesHolder;
    }

    private String getResponseScopeString(GrantContext<AccessTokenResponse> context, Scope scope) {
        if (StringUtils.isBlank((String)context.getTokenManagerId())) {
            return scope.getScopeStr();
        }
        return ((BearerAccessTokenMgmtPluginInstance)this.tokenMgr.getInstance(context.getTokenManagerId())).isExpandScopeGroups() ? scope.expanded().getScopeStr() : scope.getScopeStr();
    }

    private String validateGrantType(InMessageContext inMsgCtx) throws AccessTokenRequestException {
        String grantType = inMsgCtx.getParam("grant_type");
        if (StringUtils.isBlank((String)grantType)) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_request);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "grant_type is required");
        }
        if (this.nativeProcessors.containsKey(grantType)) {
            return grantType;
        }
        AsAuditLogger.setDescription(AccessTokenRequestException.Error.unsupported_grant_type);
        throw new AccessTokenRequestException(AccessTokenRequestException.Error.unsupported_grant_type);
    }

    private Scope checkScope(InMessageContext inMsgCtx, Client client) throws AccessTokenRequestException {
        try {
            Scope requestedScope = Scope.getScope((String)inMsgCtx.getParam(Parameters.SCOPE));
            ScopeUtil.validateRequestedScope(requestedScope, client);
            return requestedScope;
        }
        catch (InvalidRequestedScopeException e) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_scope);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_scope, e.getMessage());
        }
    }

    private void checkAuthorizationDetails(InMessageContext inMsgCtx, Client client, HttpServletRequest request, Scope scope) throws AccessTokenRequestException {
        try {
            String authorizationDetailsStr = inMsgCtx.getParam("authorization_details");
            if (authorizationDetailsStr != null) {
                AuthorizationDetails authorizationDetails = new AuthorizationDetails(authorizationDetailsStr);
                AuthorizationDetailsUtil.validate(authorizationDetails, client, request, scope);
            }
        }
        catch (IOException | InvalidAuthorizationDetailException e) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_authorization_details);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_authorization_details, e.getMessage());
        }
    }

    private void ensureAttributesExist(AttributeMap attributes) throws AccessTokenRequestException {
        if (Util.isEmpty(attributes)) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_grant);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "No attributes found in the context of this grant.");
        }
    }

    private AccessTokenRequestException invalidClientCreds() {
        return this.invalidClient("Invalid client or client credentials.");
    }

    private AccessTokenRequestException invalidClient(String msg) {
        AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_client);
        return new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, msg, 401);
    }

    private GrantContext processGrant(GrantProcessor processor, InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        try {
            return processor.processGrant(ctx, req, resp, client, grantType);
        }
        catch (AccessTokenRequestException e) {
            if (AsAuditLogger.isDescriptionBlank()) {
                if (StringUtils.isEmpty((String)e.getMessage())) {
                    AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_grant);
                } else {
                    AsAuditLogger.setDescription(e.getMessage());
                }
            }
            throw e;
        }
    }

    private void auditLogSuccess(OutMessageContext outMsgCtx, String grantType) {
        AuditLogger.setStatus("success");
        if ("urn:pingidentity.com:oauth2:grant_type:validate_bearer".equals(grantType)) {
            String attrs = outMsgCtx.getParam("access_token");
            AuditLogger.setAttributes(attrs);
            AsAuditLogger.log("Token Validated");
        } else {
            AsAuditLogger.log("Token Issued");
        }
    }

    @Override
    protected void preValidationAuditing(HttpServletRequest req, InMessageContext inMsgCtx) {
        AsAuditLogger.setInMsgCtx(req, null, inMsgCtx.getParam("grant_type"));
    }

    @Override
    protected Collection<String> getParamsToValidateNotRepeating() {
        return Arrays.asList("redirect_uri", Parameters.SCOPE, "code", "grant_type", "assertion", "device_code");
    }

    @Override
    protected void validateParameters(HttpServletRequest req, InMessageContext inMsgCtx) throws AccessTokenRequestException {
        String grantType = this.validateGrantType(inMsgCtx);
        try {
            ResourceIndicatorsUtils.validateResources(inMsgCtx.getParam("resource", Set.class));
        }
        catch (RequestProcessingException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_target, e.getMessage(), e);
        }
        AsAuditLogger.setInMessageType(grantType);
        AsAuditLogger.setGrantType(grantType);
        AuditLogger.setUserName(req.getParameter("username"));
    }

    @Override
    protected void validateParametersAgainstClient(HttpServletRequest req, InMessageContext inMsgCtx, Client client) throws AccessTokenRequestException {
        if (StringUtils.isNotEmpty((String)client.getClientId()) && (GrantTypes.isExtensionGrantType(inMsgCtx.getParam("grant_type")) && !client.isExtensionGrantTypeAllowed() || !GrantTypes.isExtensionGrantType(inMsgCtx.getParam("grant_type")) && !client.isGrantTypeAllowed(inMsgCtx.getParam("grant_type")))) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.unauthorized_client);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.unauthorized_client, 400);
        }
        Scope scope = this.checkScope(inMsgCtx, client);
        this.checkAuthorizationDetails(inMsgCtx, client, req, scope);
    }

    @Override
    protected String getRealmName() {
        return "PF AS Token Endpoints";
    }

    @Override
    protected String getEndpointName() {
        return "token endpoint";
    }

    private boolean checkReissueForHybridFlow(Client client, GrantContext<AccessTokenResponse> context) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.connectProviderRuntimePolicySupport.getPolicyGroup(client, false);
        return policyGroup != null && context.getAuthRequestResponseType() != null && context.getAuthRequestResponseType().has("id_token") && policyGroup.isReissueIdTokenHybridFlows() && context.getAuthenticationClaims() != null;
    }

    private boolean checkReissueForNewClientSecret(HttpServletRequest req, Client client, Scope scope, AuthenticationClaimHolder authenticationClaimHolder) {
        if (!scope.hasScope("openid") || authenticationClaimHolder == null) {
            return false;
        }
        byte[] secretFromRequestAttribute = ClientSecretUtils.getSecretFromRequestAttribute(req);
        if (secretFromRequestAttribute == null) {
            return false;
        }
        AlgorithmFactoryFactory algoFactoryFactory = AlgorithmFactoryFactory.getInstance();
        AlgorithmFactory jwsAlgoFactory = algoFactoryFactory.getJwsAlgorithmFactory();
        AlgorithmFactory jweAlgoFactory = algoFactoryFactory.getJweKeyManagementAlgorithmFactory();
        try {
            boolean isIdTokenEncryptionAlgorithmSymmetric;
            String idTokenSigningAlgorithm = client.getIdTokenSigningAlgorithm();
            boolean isIdTokenSigningAlgorithmSymmetric = idTokenSigningAlgorithm != null && ((JsonWebSignatureAlgorithm)jwsAlgoFactory.getAlgorithm(idTokenSigningAlgorithm)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            String idTokenEncryptionAlgorithm = client.getIdTokenEncryptionAlgorithm();
            boolean bl = isIdTokenEncryptionAlgorithmSymmetric = idTokenEncryptionAlgorithm != null && ((KeyManagementAlgorithm)jweAlgoFactory.getAlgorithm(idTokenEncryptionAlgorithm)).getKeyPersuasion() == KeyPersuasion.SYMMETRIC;
            if (!isIdTokenEncryptionAlgorithmSymmetric && !isIdTokenSigningAlgorithmSymmetric) {
                return false;
            }
        }
        catch (InvalidAlgorithmException e) {
            return false;
        }
        return !client.isPrimarySecret(new String(secretFromRequestAttribute, StandardCharsets.UTF_8));
    }

    private void validateDpopProofOnReuseAccessGrant(Client client, InMessageContext inMsgCtx, String accessGrantGuid) throws AccessTokenRequestException {
        if (client.hasCredentials()) {
            return;
        }
        AccessGrantAttributesHolder holder = this.accessGrantMgr.getGrantAttributes(accessGrantGuid);
        String jwkThumbprintFromAccessGrant = DpopUtil.getJwkThumbprintFromAccessGrantAttributesHolder(holder);
        if (jwkThumbprintFromAccessGrant == null) {
            return;
        }
        String jwkThumbprintFromTokenRequest = inMsgCtx.getParam("dpop_jkt");
        if (!DpopUtil.isJwkThumbprintMatching(jwkThumbprintFromAccessGrant, jwkThumbprintFromTokenRequest)) {
            AsAuditLogger.setDescription("The public key in DPoP proof does not match the public key from the access grant");
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_dpop_proof, "The public key in DPoP proof does not match the public key from the access grant");
        }
    }

    private void setResourcesInGrantAttributes(AccessGrantAttributesHolder accessGrantAttributesHolder, GrantContext<AccessTokenResponse> context) {
        Set<String> resources = context.getResourcesForAccessGrant();
        if (CollectionUtils.isNotEmpty(resources)) {
            accessGrantAttributesHolder.getExtendedGrantAttrs().put(InternalPersistentGrantAttributes.RESOURCES.getKey(), new AttributeValue(resources));
        }
    }
}

