/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.common.util.HierarchicalUriComparison;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.sdk.oauth20.Scope;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.internal.HttpRequestLoggingUtil;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.servlet.reqparam.InvalidResourceParameterException;
import org.sourceid.websso.wrapper.InMessageContext;

public class TokenManagerSelector {
    private static final String CONFIG_ITEM_ALLOW_MULTIPLE_ATM_MATCHES = "allowMultipleAtmMatches";
    private static final Logger logger = LogManager.getLogger(TokenManagerSelector.class);
    private final AuthzServerManager authzServerManager;
    private final BearerAccessTokenMgmtPluginManager tokenPluginManager;
    private final OAuthIssuerUtils oAuthIssuerUtils;
    private final ConnectProviderRuntimePolicySupport oidcSupport;
    private final ConfigStore configStore;

    public TokenManagerSelector(AuthzServerManager authzServerManager, BearerAccessTokenMgmtPluginManager tokenPluginManager, OAuthIssuerUtils oAuthIssuerUtils, ConnectProviderRuntimePolicySupport oidcSupport, ConfigStore configStore) {
        this.authzServerManager = authzServerManager;
        this.tokenPluginManager = tokenPluginManager;
        this.oAuthIssuerUtils = oAuthIssuerUtils;
        this.oidcSupport = oidcSupport;
        this.configStore = configStore;
    }

    public TokenManagerSelector() {
        this(MgmtFactory.getAuthzServerManager(), MgmtFactory.getBearerAccessTokenMgmtPluginMgr(), OAuthIssuerUtils.getInstance(), new ConnectProviderRuntimePolicySupport(), ConfigStoreFarm.getConfig("org.sourceid.oauth20.handlers.TokenManagerSelector"));
    }

    public Collection<String> getEligibleTokenManagerIdsForContext(String context) {
        return this.authzServerManager.getUserKeyToAccessTokenMappings().stream().filter(mapping -> mapping.isDefaultContextMapping() || mapping.getContextId().equals(context)).map(AccessTokenMapping::getTokenManagerId).collect(Collectors.toSet());
    }

    public String selectTokenManagerId(InMessageContext inMsgCtx, Scope scope, Client client) throws InvalidRequestParameterException {
        TokenManagerSelectionQuery query = new TokenManagerSelectionQueryBuilder().setRequestedAtmId(inMsgCtx.getParam("access_token_manager_id")).setAudience(inMsgCtx.getParam("aud")).setResources(inMsgCtx.getParam("resource", Set.class)).setScope(scope).setClient(client).setIsValidation(false).build();
        List<String> atmIds = this.selectTokenManagerIds(query);
        return atmIds.isEmpty() ? null : atmIds.get(0);
    }

    public List<String> selectTokenManagerIdsForValidation(InMessageContext inMsgCtx, Scope scope, Client client) throws InvalidRequestParameterException {
        TokenManagerSelectionQuery query = new TokenManagerSelectionQueryBuilder().setRequestedAtmId(inMsgCtx.getParam("access_token_manager_id")).setAudience(inMsgCtx.getParam("aud")).setResources(inMsgCtx.getParam("resource", Set.class)).setScope(scope).setClient(client).setIsValidation(true).build();
        return this.selectTokenManagerIds(query);
    }

    public String selectTokenManagerId(Collection<String> eligibleTokenMgrIds, InMessageContext inCtx, Set<String> resources, Scope scope, Client client) throws InvalidRequestParameterException {
        TokenManagerSelectionQuery query = new TokenManagerSelectionQueryBuilder().setEligibleTokenMgrIds(eligibleTokenMgrIds).setRequestedAtmId(inCtx.getParam("access_token_manager_id")).setAudience(inCtx.getParam("aud")).setResources(resources).setScope(scope).setClient(client).setIsValidation(false).build();
        List<String> atmIds = this.selectTokenManagerIds(query);
        return atmIds.isEmpty() ? null : atmIds.get(0);
    }

    public String selectTokenManagerId(Collection<String> eligibleTokenMgrIds, String requestedAtmId, String audience, Set<String> resources, Scope scope, Client client) throws InvalidRequestParameterException {
        TokenManagerSelectionQuery query = new TokenManagerSelectionQueryBuilder().setEligibleTokenMgrIds(eligibleTokenMgrIds).setRequestedAtmId(requestedAtmId).setAudience(audience).setResources(resources).setScope(scope).setClient(client).setIsValidation(false).build();
        List<String> atmIds = this.selectTokenManagerIds(query);
        return atmIds.isEmpty() ? null : atmIds.get(0);
    }

    public String selectTokenManagerId(TokenManagerSelectionQuery query) throws InvalidRequestParameterException {
        List<String> atmIds = this.selectTokenManagerIds(query);
        return atmIds.isEmpty() ? null : atmIds.get(0);
    }

    public List<String> selectTokenManagerIds(TokenManagerSelectionQuery query) throws InvalidRequestParameterException {
        String matchedAtmId;
        String msg;
        String msg2;
        List<String> matchedAtmIds;
        Collection<String> eligibleTokenMgrIds = query.getEligibleTokenMgrIds();
        Client client = query.getClient();
        String requestedAtmId = query.getRequestedAtmId();
        String audience = query.getAudience();
        Set<String> resources = query.getResources();
        Scope scope = query.getScope();
        boolean isValidation = query.isValidation();
        boolean useResourceParameter = requestedAtmId == null && CollectionUtils.isNotEmpty(resources);
        boolean validateAgainstAllATMs = isValidation && client != null && client.isValidateUsingAllEligibleAtms();
        Map<String, BearerAccessTokenMgmtPluginInstance> eligibleAtmsMap = this.getEligibleAtmsMap(eligibleTokenMgrIds, client);
        if (eligibleAtmsMap.isEmpty()) {
            String message = "There are no access token managers available for the selected client and authentication context";
            logger.debug(message);
            this.throwException(useResourceParameter, message);
        }
        if (requestedAtmId != null) {
            if (!eligibleAtmsMap.containsKey(requestedAtmId)) {
                String msg3 = String.format("The requested access token manager '%s' is not available for the selected client and authentication context", LogGuard.encode(requestedAtmId));
                String exceptionMsg = "The requested access token manager is not available for the selected client and authentication context";
                logger.debug(msg3);
                this.throwException(false, exceptionMsg);
            }
            logger.debug(String.format("Using the requested access token manager '%s'", LogGuard.encode(requestedAtmId)));
            return Collections.singletonList(requestedAtmId);
        }
        if (CollectionUtils.isNotEmpty(resources)) {
            matchedAtmIds = this.matchResources(eligibleAtmsMap, resources, validateAgainstAllATMs);
            String resourcesStr = resources.stream().map(LogGuard::encode).collect(Collectors.joining(", "));
            if (matchedAtmIds != null && !matchedAtmIds.isEmpty()) {
                String msg4 = String.format("Resource(s) '%s' matched access token manager(s) %s", resourcesStr, matchedAtmIds);
                logger.debug(msg4);
                return matchedAtmIds;
            }
            if (resources.size() == 1 && resources.iterator().next().equals(this.getUserInfoEndpoint()) && client != null) {
                try {
                    OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.oidcSupport.getPolicyGroup(client);
                    String matchedAtmId2 = policyGroup.getAccessTokenManagerId();
                    if (eligibleAtmsMap.containsKey(matchedAtmId2)) {
                        String msg5 = String.format("Resource matches UserInfo endpoint, using access token manager '%s' specified by client's OpenID Connect policy", matchedAtmId2);
                        logger.debug(msg5);
                        return Collections.singletonList(matchedAtmId2);
                    }
                }
                catch (Exception e) {
                    logger.debug("An error occurred while looking up OpenID Connect policy", (Throwable)e);
                }
            }
            msg2 = String.format("The specified resource(s) '%s' did not match any access token manager for the selected client and authentication context", resourcesStr);
            String exceptionMsg = "The specified resource(s) did not match any access token manager for the selected client and authentication context";
            logger.debug(msg2);
            this.throwException(true, exceptionMsg);
        } else if (audience != null) {
            matchedAtmIds = this.matchAudience(eligibleAtmsMap, audience, validateAgainstAllATMs);
            if (matchedAtmIds != null && !matchedAtmIds.isEmpty()) {
                String msg6 = String.format("Audience '%s' matched access token manager(s) %s", LogGuard.encode(audience), matchedAtmIds);
                logger.debug(msg6);
                return matchedAtmIds;
            }
            if (audience.equals(this.getUserInfoEndpoint()) && client != null) {
                try {
                    OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.oidcSupport.getPolicyGroup(client);
                    String matchedAtmId3 = policyGroup.getAccessTokenManagerId();
                    if (eligibleAtmsMap.containsKey(matchedAtmId3)) {
                        String msg7 = String.format("Audience matches UserInfo endpoint, using access token manager '%s' specified by client's OpenID Connect policy", matchedAtmId3);
                        logger.debug(msg7);
                        return Collections.singletonList(matchedAtmId3);
                    }
                }
                catch (Exception e) {
                    logger.debug("An error occurred while looking up OpenID Connect policy", (Throwable)e);
                }
            }
            msg = String.format("The specified audience '%s' did not match any access token manager for the selected client and authentication context", LogGuard.encode(audience));
            String exceptionMsg = "The specified audience did not match any access token manager for the selected client and authentication context";
            logger.debug(msg);
            this.throwException(false, exceptionMsg);
        }
        if (eligibleAtmsMap.size() == 1) {
            String matchedAtmId4 = eligibleAtmsMap.keySet().iterator().next();
            msg = String.format("Using the only eligible access token manager '%s'", matchedAtmId4);
            logger.debug(msg);
            return Collections.singletonList(matchedAtmId4);
        }
        if (client != null && scope != null && scope.hasScope("openid")) {
            try {
                OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.oidcSupport.getPolicyGroup(client);
                matchedAtmId = policyGroup.getAccessTokenManagerId();
                if (eligibleAtmsMap.containsKey(matchedAtmId)) {
                    msg2 = String.format("Scope includes 'openid', using access token manager '%s' specified by client's OpenID Connect policy", matchedAtmId);
                    logger.debug(msg2);
                    return Collections.singletonList(matchedAtmId);
                }
            }
            catch (Exception e) {
                logger.debug("An error occurred while looking up OpenID Connect policy", (Throwable)e);
            }
        }
        LinkedHashSet<String> tokenManagerIds = new LinkedHashSet<String>();
        if (client != null && client.getDefaultAccessTokenManagerId() != null && eligibleAtmsMap.containsKey(client.getDefaultAccessTokenManagerId())) {
            msg = String.format("Adding to list the client's default access token manager '%s'", client.getDefaultAccessTokenManagerId());
            logger.debug(msg);
            tokenManagerIds.add(client.getDefaultAccessTokenManagerId());
        }
        if (this.tokenPluginManager.getDefaultInstance() != null && eligibleAtmsMap.containsKey(((BearerAccessTokenMgmtPluginInstance)this.tokenPluginManager.getDefaultInstance()).getId())) {
            matchedAtmId = ((BearerAccessTokenMgmtPluginInstance)this.tokenPluginManager.getDefaultInstance()).getId();
            msg2 = String.format("Adding to list the global default access token manager: %s", matchedAtmId);
            logger.debug(msg2);
            tokenManagerIds.add(matchedAtmId);
        }
        if (validateAgainstAllATMs) {
            tokenManagerIds.addAll(eligibleAtmsMap.keySet());
        }
        if (tokenManagerIds.isEmpty()) {
            String message = "The global default access token manager is not available for the selected client and authentication context";
            logger.debug(message);
            this.throwException(useResourceParameter, message);
        } else if (client != null && !client.isValidateUsingAllEligibleAtms()) {
            String atmId = (String)tokenManagerIds.iterator().next();
            tokenManagerIds.clear();
            tokenManagerIds.add(atmId);
        }
        this.logAtmsUsedForAccessToken(tokenManagerIds);
        return new ArrayList<String>(tokenManagerIds);
    }

    private void logAtmsUsedForAccessToken(Set<String> tokenManagerIds) {
        if (!tokenManagerIds.isEmpty()) {
            StringBuilder atmIdsUsedWhenValidatingAccessToken = new StringBuilder();
            for (String tokenManagerId : tokenManagerIds) {
                atmIdsUsedWhenValidatingAccessToken.append(tokenManagerId);
                atmIdsUsedWhenValidatingAccessToken.append("; ");
            }
            String msg = String.format("List of token manager ids considered to use for access token, when aud/access_token_manager_id/resource/openidScope not present: %s", atmIdsUsedWhenValidatingAccessToken);
            logger.debug(msg);
        }
    }

    private Map<String, BearerAccessTokenMgmtPluginInstance> getEligibleAtmsMap(Collection<String> eligibleTokenMgrIds, Client client) {
        if (eligibleTokenMgrIds == null) {
            eligibleTokenMgrIds = new ArrayList<String>();
            for (BearerAccessTokenMgmtPluginInstance instance : this.tokenPluginManager.getInstances()) {
                eligibleTokenMgrIds.add(instance.getId());
            }
        }
        HashMap<String, BearerAccessTokenMgmtPluginInstance> eligibleAtmsMap = new HashMap<String, BearerAccessTokenMgmtPluginInstance>();
        for (String tokenMgrId : eligibleTokenMgrIds) {
            BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)this.tokenPluginManager.getInstance(tokenMgrId);
            if (!instance.isClientAllowed(client != null ? client.getClientId() : null)) continue;
            eligibleAtmsMap.put(instance.getId(), instance);
        }
        return eligibleAtmsMap;
    }

    protected String getUserInfoEndpoint() {
        HttpServletRequest request = HttpRequestLoggingUtil.getRequest();
        return this.oAuthIssuerUtils.getIssuerValue(request) + "/idp/userinfo.openid";
    }

    private List<String> matchAudience(Map<String, BearerAccessTokenMgmtPluginInstance> eligibleAtms, String audience, boolean validateAgainstAllATMs) {
        List<String> matchedTokenManagerIds = this.matchAllRequestedAudienceOrResource(eligibleAtms, audience, false);
        if (validateAgainstAllATMs) {
            return matchedTokenManagerIds;
        }
        if (!this.configStore.getBooleanValue(CONFIG_ITEM_ALLOW_MULTIPLE_ATM_MATCHES, false) && matchedTokenManagerIds.size() > 1) {
            String matchedAtmIdsStr = String.join((CharSequence)", ", matchedTokenManagerIds);
            String msg = String.format("The specified audience '%s' matched multiple access token managers '%s' for the selected client and authentication context", audience, matchedAtmIdsStr);
            String exceptionMsg = "The specified audience matched multiple access token managers for the selected client and authentication context";
            logger.debug(msg);
            this.throwException(false, exceptionMsg);
        }
        return matchedTokenManagerIds.isEmpty() ? Collections.emptyList() : List.of(matchedTokenManagerIds.get(0));
    }

    private List<String> matchResources(Map<String, BearerAccessTokenMgmtPluginInstance> eligibleAtms, Set<String> resources, boolean validateAgainstAllATMs) {
        if (resources.size() == 1) {
            List<String> matchedTokenManagerIds = this.matchAllRequestedAudienceOrResource(eligibleAtms, resources.iterator().next(), true);
            if (validateAgainstAllATMs) {
                return matchedTokenManagerIds;
            }
            if (!this.configStore.getBooleanValue(CONFIG_ITEM_ALLOW_MULTIPLE_ATM_MATCHES, false) && matchedTokenManagerIds.size() > 1) {
                String matchedAtmIdsStr = String.join((CharSequence)", ", matchedTokenManagerIds);
                String msg = String.format("The specified resource '%s' matched multiple access token managers '%s' for the selected client and authentication context", resources.iterator().next(), matchedAtmIdsStr);
                String exceptionMsg = "The specified resource matched multiple access token managers for the selected client and authentication context";
                logger.debug(msg);
                this.throwException(true, exceptionMsg);
            }
            return matchedTokenManagerIds.isEmpty() ? Collections.emptyList() : List.of(matchedTokenManagerIds.get(0));
        }
        HashSet<String> matchedAtmIds = new HashSet<String>();
        for (String resource : resources) {
            List<String> matchedIds = this.matchAllRequestedAudienceOrResource(eligibleAtms, resource, true);
            if (matchedIds == null || matchedIds.isEmpty()) {
                String msg = String.format("The specified resource(s) '%s' did not match any access token manager for the selected client and authentication context", LogGuard.encode(resource));
                String exceptionMsg = "The specified resource(s) did not match any access token manager for the selected client and authentication context";
                logger.debug(msg);
                this.throwException(true, exceptionMsg);
            }
            matchedAtmIds.addAll(matchedIds);
        }
        if (!validateAgainstAllATMs && matchedAtmIds.size() != 1) {
            String resourcesStr = resources.stream().map(LogGuard::encode).collect(Collectors.joining(", "));
            String matchedAtmIdsStr = String.join((CharSequence)", ", matchedAtmIds);
            String msg = String.format("The specified resource(s) '%s' matched multiple access token managers '%s' for the selected client and authentication context", resourcesStr, matchedAtmIdsStr);
            String exceptionMsg = "The specified resource(s) matched multiple access token managers for the selected client and authentication context";
            logger.debug(msg);
            this.throwException(true, exceptionMsg);
        }
        return new ArrayList<String>(matchedAtmIds);
    }

    private List<String> matchAllRequestedAudienceOrResource(Map<String, BearerAccessTokenMgmtPluginInstance> eligibleAtmsMap, String audienceOrResource, boolean isResource) {
        URI requestedUri = TokenManagerSelector.getUri(audienceOrResource, isResource);
        if (requestedUri == null) {
            return Collections.emptyList();
        }
        int minDiff = Integer.MAX_VALUE;
        ArrayList<String> matchedTokenManagerIds = new ArrayList<String>();
        for (Map.Entry<String, BearerAccessTokenMgmtPluginInstance> entry : eligibleAtmsMap.entrySet()) {
            for (String candidate : entry.getValue().getResourceUris()) {
                try {
                    URI resourceUri = new URI(candidate);
                    int compareResult = HierarchicalUriComparison.compare(requestedUri, resourceUri, true);
                    if (compareResult < 0 || compareResult > minDiff) continue;
                    if (compareResult < minDiff) {
                        matchedTokenManagerIds.clear();
                    }
                    if (matchedTokenManagerIds.contains(entry.getKey())) continue;
                    matchedTokenManagerIds.add(entry.getKey());
                    minDiff = compareResult;
                }
                catch (URISyntaxException e) {
                    logger.debug(String.format("Invalid token manager resource URI: %s", candidate));
                }
            }
        }
        return matchedTokenManagerIds;
    }

    private static URI getUri(String audienceOrResource, boolean isResource) {
        try {
            return new URI(audienceOrResource);
        }
        catch (URISyntaxException e) {
            String encodedValue = LogGuard.encode(audienceOrResource);
            String msg = isResource ? String.format("Resource parameter is not a valid URI: %s", encodedValue) : String.format("Audience parameter is not a valid URI: %s", encodedValue);
            logger.debug(msg);
            return null;
        }
    }

    private void throwException(boolean isResource, String message) throws InvalidRequestParameterException {
        if (isResource) {
            throw new InvalidResourceParameterException(message);
        }
        throw new InvalidRequestParameterException(message);
    }

    public static class TokenManagerSelectionQueryBuilder {
        private Collection<String> eligibleTokenMgrIds;
        private String requestedAtmId;
        private String audience;
        private Set<String> resources;
        private Scope scope;
        private Client client;
        private boolean isValidation;

        public TokenManagerSelectionQueryBuilder setEligibleTokenMgrIds(Collection<String> eligibleTokenMgrIds) {
            this.eligibleTokenMgrIds = eligibleTokenMgrIds;
            return this;
        }

        public TokenManagerSelectionQueryBuilder setRequestedAtmId(String requestedAtmId) {
            this.requestedAtmId = requestedAtmId;
            return this;
        }

        public TokenManagerSelectionQueryBuilder setAudience(String audience) {
            this.audience = audience;
            return this;
        }

        public TokenManagerSelectionQueryBuilder setResources(Set<String> resources) {
            this.resources = resources;
            return this;
        }

        public TokenManagerSelectionQueryBuilder setScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public TokenManagerSelectionQueryBuilder setClient(Client client) {
            this.client = client;
            return this;
        }

        public TokenManagerSelectionQueryBuilder setIsValidation(boolean isValidation) {
            this.isValidation = isValidation;
            return this;
        }

        public TokenManagerSelectionQuery build() {
            TokenManagerSelectionQuery query = new TokenManagerSelectionQuery();
            query.eligibleTokenMgrIds = this.eligibleTokenMgrIds;
            query.requestedAtmId = this.requestedAtmId;
            query.audience = this.audience;
            query.resources = this.resources;
            query.scope = this.scope;
            query.client = this.client;
            query.isValidation = this.isValidation;
            return query;
        }
    }

    public static class TokenManagerSelectionQuery {
        private Collection<String> eligibleTokenMgrIds;
        private String requestedAtmId;
        private String audience;
        private Set<String> resources;
        private Scope scope;
        private Client client;
        private boolean isValidation;

        private TokenManagerSelectionQuery() {
        }

        private Collection<String> getEligibleTokenMgrIds() {
            return this.eligibleTokenMgrIds;
        }

        private String getRequestedAtmId() {
            return this.requestedAtmId;
        }

        private String getAudience() {
            return this.audience;
        }

        private Set<String> getResources() {
            return this.resources;
        }

        private Scope getScope() {
            return this.scope;
        }

        private Client getClient() {
            return this.client;
        }

        private boolean isValidation() {
            return this.isValidation;
        }
    }
}

