/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.BaseClientAuthnRequestHandler;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class TokenRevocationRequestHandler
extends BaseClientAuthnRequestHandler {
    private final Log log = LogFactory.getLog(this.getClass());

    public TokenRevocationRequestHandler() {
        super(OAuthIssuerUtils.getInstance());
    }

    @Override
    protected void doProcess(InMessageContext msgCtx, OutMessageContext outMstCtx, Client client, HttpServletRequest req, HttpServletResponse resp) throws IOException, AccessTokenRequestException {
        boolean isUnidentifiedClient;
        boolean tokenHintValid = false;
        boolean tokenRevoked = false;
        String tokenHint = req.getParameter("token_type_hint");
        String token = req.getParameter("token");
        AuthzServerManager authzServer = MgmtFactory.getAuthzServerManager();
        boolean allowUnidentifiedClients = authzServer.allowUnidentifiedClientROCreds() || authzServer.allowUnidentifiedClientExtensionGrants();
        boolean bl = isUnidentifiedClient = client.getClientId() == null;
        if (isUnidentifiedClient) {
            if (allowUnidentifiedClients) {
                this.log.debug((Object)("Preparing to revoke token with hint=" + tokenHint));
                tokenRevoked = this.revokeAccessToken(client, token);
                if (!tokenRevoked) {
                    AccessGrantManager grantMgr = MgmtFactory.getAccessGrantManager();
                    AccessGrant accessGrant = grantMgr.getByRefreshToken(token);
                    if (accessGrant != null) {
                        AsAuditLogger.setInRefreshTokenHash(token);
                        this.throwInvalidClient("client_id is needed to revoke this token");
                    }
                } else {
                    AsAuditLogger.setAccessTokenTrackingId(token);
                    AsAuditLogger.setInAccessTokenHash(token);
                }
            } else {
                if ("access_token".equals(tokenHint)) {
                    AsAuditLogger.setAccessTokenTrackingId(token);
                    AsAuditLogger.setInAccessTokenHash(token);
                } else if ("refresh_token".equals(tokenHint)) {
                    AsAuditLogger.setInRefreshTokenHash(token);
                } else {
                    AsAuditLogger.setAccessTokenTrackingId(token);
                    AsAuditLogger.setInAccessTokenHash(token);
                }
                this.throwInvalidClient("client_id is not specified");
            }
        } else {
            this.log.debug((Object)("Preparing to revoke token with hint=" + tokenHint));
            if (tokenHint != null && (tokenHint.equals("refresh_token") || tokenHint.equals("access_token"))) {
                tokenHintValid = true;
            }
            if (!tokenHintValid || tokenHint.equals("refresh_token")) {
                tokenRevoked = this.revokeRefreshToken(client, token);
                if (!tokenRevoked) {
                    tokenRevoked = this.revokeAccessToken(client, token);
                    if (tokenRevoked) {
                        AsAuditLogger.setAccessTokenTrackingId(token);
                        AsAuditLogger.setInAccessTokenHash(token);
                    }
                } else {
                    AsAuditLogger.setInRefreshTokenHash(token);
                }
            } else {
                tokenRevoked = this.revokeAccessToken(client, token);
                if (!tokenRevoked) {
                    tokenRevoked = this.revokeRefreshToken(client, token);
                    if (tokenRevoked) {
                        AsAuditLogger.setInRefreshTokenHash(token);
                    }
                } else {
                    AsAuditLogger.setAccessTokenTrackingId(token);
                    AsAuditLogger.setInAccessTokenHash(token);
                }
            }
        }
        AuditLogger.setStatus("success");
        if (tokenRevoked) {
            AsAuditLogger.log("Token successfully revoked");
            TokenRevocationRequestHandler.getAccountLockingService().clearMaliciousActions(AccountLockingService.getUserKeyWithMaxMaliciousActions(req.getRemoteAddr(), client.getClientId()));
        } else {
            if ("access_token".equals(tokenHint)) {
                AsAuditLogger.setAccessTokenTrackingId(token);
                AsAuditLogger.setInAccessTokenHash(token);
            } else if ("refresh_token".equals(tokenHint)) {
                AsAuditLogger.setInRefreshTokenHash(token);
            } else {
                AsAuditLogger.setAccessTokenTrackingId(token);
                AsAuditLogger.setInAccessTokenHash(token);
            }
            AsAuditLogger.log("Token invalid, nothing revoked");
            TokenRevocationRequestHandler.getAccountLockingService().logMaliciousAction(AccountLockingService.getUserKeyWithMaxMaliciousActions(req.getRemoteAddr(), client.getClientId()));
        }
    }

    private boolean revokeAccessToken(Client client, String token) throws AccessTokenRequestException {
        boolean isUnidentifiedClient;
        BearerAccessTokenMgmtPluginManager bearerAtmPluginMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        boolean bl = isUnidentifiedClient = client.getClientId() == null;
        if (isUnidentifiedClient && bearerAtmPluginMgr.isRevocableAccessTokenExistAndWithClient(token)) {
            this.throwInvalidClient("client_id is needed to revoke this token");
        }
        boolean result = bearerAtmPluginMgr.revokeAccessToken(client, token);
        if (this.log.isInfoEnabled()) {
            if (result) {
                this.log.info((Object)("An access token for client '" + client.getClientId() + "' was revoked."));
            } else {
                this.log.info((Object)"The incoming token was not recognized as an existing access token that could be revoked. No revocation occurred.");
            }
        }
        return result;
    }

    private boolean revokeRefreshToken(Client client, String token) {
        AccessGrantManager grantMgr = MgmtFactory.getAccessGrantManager();
        AccessGrant accessGrant = grantMgr.getByRefreshToken(token);
        if (accessGrant != null) {
            String clientId;
            AsAuditLogger.setAccessGrantGuid(accessGrant.getGuid());
            if (StringUtils.isNotBlank((String)accessGrant.getUniqueUserIdentifer())) {
                AsAuditLogger.setUserName(accessGrant.getUniqueUserIdentifer());
            }
            if ((clientId = accessGrant.getClientId()) != null && clientId.equals(client.getClientId())) {
                grantMgr.revokeGrant(accessGrant.getGuid());
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("A refresh token for client '" + client.getClientId() + "' was revoked."));
                }
                AsAuditLogger.setDescription("A refresh token for client '" + client.getClientId() + "' was revoked.");
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"The incoming token was recognized as an existing refresh token, but it belonged to another client. No revocation occurred.");
                }
                AsAuditLogger.setDescription("The incoming token was recognized as an existing refresh token, but it belonged to another client. No revocation occurred.");
            }
            return true;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"The incoming token was not recognized as an existing refresh token. No revocation occurred.");
        }
        AsAuditLogger.setDescription("The incoming token was not recognized as an existing refresh token. No revocation occurred.");
        return false;
    }

    @Override
    protected void preValidationAuditing(HttpServletRequest req, InMessageContext inMsgCtx) {
        AsAuditLogger.setInMsgCtx(req, null);
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"TokenRevoke");
    }

    @Override
    protected Collection<String> getParamsToValidateNotRepeating() {
        return Arrays.asList("token", "token_type_hint");
    }

    @Override
    protected void validateParameters(HttpServletRequest req, InMessageContext inMsgCtx) throws AccessTokenRequestException {
        String token = inMsgCtx.getParam("token");
        if (StringUtils.isBlank((String)token)) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_request);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "token is required");
        }
    }

    @Override
    protected void validateParametersAgainstClient(HttpServletRequest req, InMessageContext inMsgCtx, Client client) {
    }

    @Override
    protected String getRealmName() {
        return "PF AS Token Endpoints";
    }

    @Override
    protected String getEndpointName() {
        return "token revocation endpoint";
    }

    private void throwInvalidClient(String msg) throws AccessTokenRequestException {
        AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_client);
        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, msg, 401);
    }
}

