/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Collection;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.domain.AccessTokenMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientCredentialAccessTokenMapping;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;

public class ClientCredentialsGrantProcessor
implements GrantProcessor {
    private static final String OAUTH_OIDC_RETURN_SCOPE_CONFIG_STORE_NAME = "oauth-scope-settings";
    private static final String ALWAYS_RETURN_SCOPE_SETTING = "always-return-scope-for-client-credentials";
    private static final boolean ALWAYS_RETURN_SCOPE_SETTING_DEFAULT_VALUE = false;
    private final ConfigStore oauthOidcScopesConfigStore = ConfigStoreFarm.getConfig("oauth-scope-settings");
    private final AuthzServerManager authzServerMgr;

    public ClientCredentialsGrantProcessor(AuthzServerManager authzServerMgr) {
        this.authzServerMgr = authzServerMgr;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        Scope scope = Scope.getScope((String)ctx.getParam(Parameters.SCOPE));
        AuthorizationDetails authorizationDetails = AuthorizationDetailsUtil.getAuthorizationDetails(ctx.getParam("authorization_details"));
        try {
            AuthorizationDetailsUtil.enrich(authorizationDetails, req, client.getClientId(), scope);
        }
        catch (AuthorizationRequestException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_authorization_details, e.getMessage(), e);
        }
        AttributeMap srcAttributes = new AttributeMap();
        if (client.getClientId() == null || !client.hasSecret() && !client.isClientCertValidationEnabled() && !client.isJwtAuthn() && !client.isClientSecretJwtAuthn()) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_request);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "Unsupported Client Authentication type.");
        }
        srcAttributes.put(Parameters.CLIENT_ID, client.getClientId());
        AsAuditLogger.setUserName(client.getClientId());
        TokenManagerSelector tokenManagerSelector = new TokenManagerSelector();
        String tokenManagerId = null;
        try {
            tokenManagerId = tokenManagerSelector.selectTokenManagerId(ctx, scope, client);
        }
        catch (InvalidRequestParameterException e) {
            throw new AccessTokenRequestException(e);
        }
        String mappingId = AccessTokenMapping.makeId("client_credentials", tokenManagerId);
        ClientCredentialAccessTokenMapping credsToAccessTokenMapping = this.authzServerMgr.getClientCredsToAccessTokenMapping(mappingId);
        if (credsToAccessTokenMapping != null) {
            try {
                Set resources;
                AttributeMap contextAttributes = new AttributeMap();
                contextAttributes.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
                contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
                contextAttributes.put(SourceContextType.OAUTH_CLIENT.getId(), client.getClientId());
                HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), contextAttributes);
                contextAttributes.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue((Collection)scope.getScopeSet()));
                if (authorizationDetails != null && authorizationDetails.getDetails() != null) {
                    contextAttributes.put(SourceContextType.OAUTH_AUTHORIZATION_DETAILS.getId(), authorizationDetails.toAttributeValue());
                }
                if (CollectionUtils.isNotEmpty((Collection)(resources = ctx.getParam("resource", Set.class)))) {
                    contextAttributes.put(SourceContextType.OAUTH_RESOURCES.getId(), new AttributeValue((Collection)resources));
                }
                srcAttributes = credsToAccessTokenMapping.executeMapping(srcAttributes, null, contextAttributes);
            }
            catch (AuthorizationException e) {
                AsAuditLogger.setDescription(e.getErrorDetail());
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, e.getMessage(), e);
            }
            catch (AttrLookupException e) {
                AsAuditLogger.setDescription("Attribute Mapping Exception");
                throw new ProcessRuntimeException("Unexpected problem in mapping attributes.", e);
            }
        }
        boolean includeScopeInResponse = this.oauthOidcScopesConfigStore.getBooleanValue(ALWAYS_RETURN_SCOPE_SETTING, false);
        return new GrantContext.Builder().setAttributes(srcAttributes).setScope(scope).setTokenManagerId(tokenManagerId).setAuthorizationDetails(authorizationDetails).setIncludeScopeInResponse(includeScopeInResponse).build();
    }
}

