/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.sourceid.oauth20.handlers.AuthenticationClaimHolder;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.oauth20.token.TokenResponse;
import org.sourceid.util.log.AttributeMap;

public class GrantContext<T extends TokenResponse> {
    private String userKey;
    private String contextQualifer;
    private AttributeMap attributes;
    private Scope scope;
    private boolean includeScopeInResponse;
    private boolean canIssuePersistentGrant;
    private AuthorizationDetails authorizationDetails;
    private boolean allowIdToken;
    private T accessTokenResponse;
    private String contextClientId;
    private Map<String, Object> additionalParameters = Collections.emptyMap();
    private String tokenManagerId;
    private String oidcPolicyId;
    private AccessGrantAttributesHolder accessGrantAttributes;
    private String sri;
    private String requestedTokenType;
    private AuthenticationClaimHolder authenticationClaims;
    private ResponseType authRequestResponseType;
    private Set<String> resourcesForMapping;
    private Set<String> resourcesForAccessGrant;

    private GrantContext() {
    }

    public GrantContext(String userKey, AccessGrantAttributesHolder accessGrantAttributes, Scope scope, boolean includeScopeInResponse, String contextQualifer, String tokenManagerId) {
        this.userKey = userKey;
        this.scope = scope;
        this.contextQualifer = contextQualifer;
        this.includeScopeInResponse = includeScopeInResponse;
        this.tokenManagerId = tokenManagerId;
        this.accessGrantAttributes = accessGrantAttributes;
        this.canIssuePersistentGrant = true;
    }

    public GrantContext(String userKey, AccessGrantAttributesHolder accessGrantAttributes, Scope scope, boolean includeScopeInResponse, String contextQualifer, String tokenManagerId, String requestedTokenType) {
        this(userKey, accessGrantAttributes, scope, includeScopeInResponse, contextQualifer, tokenManagerId);
        this.requestedTokenType = requestedTokenType;
    }

    public GrantContext(String userKey, AccessGrantAttributesHolder accessGrantAttributes, Scope scope, boolean includeScopeInResponse, String contextQualifer, String tokenManagerId, String requestedTokenType, boolean allowIdToken, String oidcPolicyId) {
        this(userKey, accessGrantAttributes, scope, includeScopeInResponse, contextQualifer, tokenManagerId, requestedTokenType);
        this.allowIdToken = allowIdToken;
        this.oidcPolicyId = oidcPolicyId;
    }

    public GrantContext(String userKey, AccessGrantAttributesHolder accessGrantAttributes, Scope scope, boolean includeScopeInResponse, String contextQualifer, String tokenManagerId, AuthorizationDetails authorizationDetails) {
        this(userKey, accessGrantAttributes, scope, includeScopeInResponse, contextQualifer, tokenManagerId);
        this.authorizationDetails = authorizationDetails;
    }

    public GrantContext(AttributeMap attributes, Scope scope, String tokenManagerId) {
        this.attributes = attributes;
        this.scope = scope;
        this.tokenManagerId = tokenManagerId;
        this.canIssuePersistentGrant = false;
    }

    public GrantContext(AttributeMap attributes, Scope scope, String tokenManagerId, String requestedTokenType) {
        this.attributes = attributes;
        this.scope = scope;
        this.tokenManagerId = tokenManagerId;
        this.requestedTokenType = requestedTokenType;
        this.canIssuePersistentGrant = false;
    }

    public GrantContext(AttributeMap attributes, Scope scope, boolean includeScopeInResponse, String tokenManagerId, String requestedTokenType, boolean isIncludeIdToken, String oidcPolicyId) {
        this(attributes, scope, tokenManagerId, requestedTokenType);
        this.includeScopeInResponse = includeScopeInResponse;
        this.allowIdToken = isIncludeIdToken;
        this.oidcPolicyId = oidcPolicyId;
    }

    public GrantContext(T accessTokenResponse) {
        this.accessTokenResponse = accessTokenResponse;
        this.canIssuePersistentGrant = false;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean includeScopeInResponse() {
        return this.includeScopeInResponse;
    }

    public String getContextQualifer() {
        return this.contextQualifer;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public boolean canIssuePersistentGrant() {
        return this.canIssuePersistentGrant;
    }

    public boolean hasAccessTokenResponse() {
        return this.accessTokenResponse != null;
    }

    public String getContextClientId() {
        return this.contextClientId;
    }

    public T getAccessTokenResponse() {
        return this.accessTokenResponse;
    }

    public void setContextClientId(String contextClientId) {
        this.contextClientId = contextClientId;
    }

    public String getTokenManagerId() {
        return this.tokenManagerId;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setAdditionalParameters(Map<String, Object> additionalParameters) {
        this.additionalParameters = additionalParameters;
    }

    public AccessGrantAttributesHolder getAccessGrantAttributes() {
        return this.accessGrantAttributes;
    }

    public String getSri() {
        return this.sri;
    }

    public void setSri(String sri) {
        this.sri = sri;
    }

    public boolean isAllowIdToken() {
        return this.allowIdToken;
    }

    public void setAllowIdToken(boolean allowIdToken) {
        this.allowIdToken = allowIdToken;
    }

    public String getRequestedTokenType() {
        return this.requestedTokenType;
    }

    public AuthenticationClaimHolder getAuthenticationClaims() {
        return this.authenticationClaims;
    }

    public void setAuthenticationClaims(AuthenticationClaimHolder authenticationClaims) {
        this.authenticationClaims = authenticationClaims;
    }

    public void setAuthRequestResponseType(ResponseType responseType) {
        this.authRequestResponseType = responseType;
    }

    public ResponseType getAuthRequestResponseType() {
        return this.authRequestResponseType;
    }

    public AuthorizationDetails getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public void setAuthorizationDetails(AuthorizationDetails authorizationDetails) {
        this.authorizationDetails = authorizationDetails;
    }

    public Set<String> getResourcesForMapping() {
        return this.resourcesForMapping;
    }

    public void setResourcesForMapping(Set<String> resourcesForMapping) {
        this.resourcesForMapping = resourcesForMapping != null ? Set.copyOf(resourcesForMapping) : Collections.emptySet();
    }

    public Set<String> getResourcesForAccessGrant() {
        return this.resourcesForAccessGrant;
    }

    public void setResourcesForAccessGrant(Set<String> resourcesForAccessGrant) {
        this.resourcesForAccessGrant = resourcesForAccessGrant != null ? Set.copyOf(resourcesForAccessGrant) : Collections.emptySet();
    }

    public String getOidcPolicyId() {
        return this.oidcPolicyId;
    }

    public static class Builder<T extends TokenResponse> {
        private String userKey;
        private String contextQualifer;
        private AttributeMap attributes;
        private Scope scope;
        private boolean includeScopeInResponse;
        private boolean canIssuePersistentGrant;
        private AuthorizationDetails authorizationDetails;
        private boolean allowIdToken;
        private T accessTokenResponse;
        private String contextClientId;
        private String tokenManagerId;
        private String oidcPolicyId;
        private AccessGrantAttributesHolder accessGrantAttributes;
        private String sri;
        private String requestedTokenType;
        private AuthenticationClaimHolder authenticationClaims;
        private ResponseType authRequestResponseType;
        private Set<String> resourcesForMapping;
        private Set<String> resourcesForAccessGrant;
        private Map<String, Object> additionalParameters = Collections.emptyMap();

        public Builder<T> setUserKey(String userKey) {
            this.userKey = userKey;
            return this;
        }

        public Builder<T> setContextQualifer(String contextQualifer) {
            this.contextQualifer = contextQualifer;
            return this;
        }

        public Builder<T> setAttributes(AttributeMap attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder<T> setScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder<T> setIncludeScopeInResponse(boolean includeScopeInResponse) {
            this.includeScopeInResponse = includeScopeInResponse;
            return this;
        }

        public Builder<T> setCanIssuePersistentGrant(boolean canIssuePersistentGrant) {
            this.canIssuePersistentGrant = canIssuePersistentGrant;
            return this;
        }

        public Builder<T> setAuthorizationDetails(AuthorizationDetails authorizationDetails) {
            this.authorizationDetails = authorizationDetails;
            return this;
        }

        public Builder<T> setAllowIdToken(boolean allowIdToken) {
            this.allowIdToken = allowIdToken;
            return this;
        }

        public Builder<T> setAccessTokenResponse(T accessTokenResponse) {
            this.accessTokenResponse = accessTokenResponse;
            return this;
        }

        public Builder<T> setContextClientId(String contextClientId) {
            this.contextClientId = contextClientId;
            return this;
        }

        public Builder<T> setTokenManagerId(String tokenManagerId) {
            this.tokenManagerId = tokenManagerId;
            return this;
        }

        public Builder<T> setOidcPolicyId(String oidcPolicyId) {
            this.oidcPolicyId = oidcPolicyId;
            return this;
        }

        public Builder<T> setAccessGrantAttributesHolder(AccessGrantAttributesHolder accessGrantAttributes) {
            this.accessGrantAttributes = accessGrantAttributes;
            return this;
        }

        public Builder<T> setSri(String sri) {
            this.sri = sri;
            return this;
        }

        public Builder<T> setRequestedTokenType(String requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
            return this;
        }

        public Builder<T> setAuthenticationClaims(AuthenticationClaimHolder authenticationClaims) {
            this.authenticationClaims = authenticationClaims;
            return this;
        }

        public Builder<T> setAuthRequestResponseType(ResponseType authRequestResponseType) {
            this.authRequestResponseType = authRequestResponseType;
            return this;
        }

        public Builder<T> setResourcesForMapping(Set<String> resourcesForMapping) {
            this.resourcesForMapping = resourcesForMapping;
            return this;
        }

        public Builder<T> setResourcesForAccessGrant(Set<String> resourcesForAccessGrant) {
            this.resourcesForAccessGrant = resourcesForAccessGrant;
            return this;
        }

        public Builder<T> setAdditionalParameters(Map<String, Object> additionalParameters) {
            this.additionalParameters = additionalParameters;
            return this;
        }

        public GrantContext<T> build() {
            GrantContext grantContext = new GrantContext();
            grantContext.userKey = this.userKey;
            grantContext.contextQualifer = this.contextQualifer;
            grantContext.attributes = this.attributes;
            grantContext.scope = this.scope;
            grantContext.includeScopeInResponse = this.includeScopeInResponse;
            grantContext.canIssuePersistentGrant = this.canIssuePersistentGrant;
            grantContext.authorizationDetails = this.authorizationDetails;
            grantContext.allowIdToken = this.allowIdToken;
            grantContext.accessTokenResponse = this.accessTokenResponse;
            grantContext.contextClientId = this.contextClientId;
            grantContext.tokenManagerId = this.tokenManagerId;
            grantContext.oidcPolicyId = this.oidcPolicyId;
            grantContext.accessGrantAttributes = this.accessGrantAttributes;
            grantContext.sri = this.sri;
            grantContext.requestedTokenType = this.requestedTokenType;
            grantContext.authenticationClaims = this.authenticationClaims;
            grantContext.authRequestResponseType = this.authRequestResponseType;
            grantContext.resourcesForMapping = this.resourcesForMapping;
            grantContext.resourcesForAccessGrant = this.resourcesForAccessGrant;
            grantContext.additionalParameters = this.additionalParameters;
            return grantContext;
        }
    }
}

