/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import com.pingidentity.access.AuthorizationDetailProcessorAccessor;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailContext;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.consent.OAuthConsentManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.domain.RefreshTokenRollingIntervalHelper;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.ServerErrorException;
import org.sourceid.oauth20.handlers.process.ClientAwareGrantProcessor;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.GrantParamHelper;
import org.sourceid.oauth20.protocol.InternalPersistentGrantAttributes;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.token.AccessTokenResponse;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.oauth20.token.refresh.MultiPartRefreshToken;
import org.sourceid.oauth20.token.refresh.RefreshToken;
import org.sourceid.oauth20.utils.ResourceIndicatorsUtils;
import org.sourceid.openid.connect.IdTokenSupport;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.SystemAttrLookupException;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.servlet.QuietException;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;

public class RefreshTokenGrantProcessor
extends ClientAwareGrantProcessor
implements GrantProcessor {
    private final BearerAccessTokenMgmtPluginManager tokenManager;
    private final AccessGrantManager accessGrantManager;
    private final AuthzServerManager authzServerManager;
    private final ConnectProviderRuntimePolicySupport oidcPolicySupport;
    private final IdTokenSupport idTokenSupport;
    private final OAuthIssuerUtils oAuthIssuerUtils;
    private final OAuthConsentManager oAuthConsentManager;

    public RefreshTokenGrantProcessor(BearerAccessTokenMgmtPluginManager tokenMgr, AuthzServerManager authzServerMgr, AccessGrantManager accessGrantMgr, ClientManager clientMgr, ConnectProviderRuntimePolicySupport oidcPolicySupport, IdTokenSupport idTokenSupport, OAuthIssuerUtils oAuthIssuerUtils, OAuthConsentManager oAuthConsentManager) {
        super(clientMgr);
        this.tokenManager = tokenMgr;
        this.authzServerManager = authzServerMgr;
        this.accessGrantManager = accessGrantMgr;
        this.oidcPolicySupport = oidcPolicySupport;
        this.idTokenSupport = idTokenSupport;
        this.oAuthIssuerUtils = oAuthIssuerUtils;
        this.oAuthConsentManager = oAuthConsentManager;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        boolean isGranted;
        boolean doCheckApprovedConsents;
        String refreshTokenValue = GrantParamHelper.getParam(req, "refresh_token", true, grantType);
        AsAuditLogger.setInRefreshTokenHash(refreshTokenValue);
        AccessGrant accessGrant = this.accessGrantManager.getByRefreshToken(refreshTokenValue);
        if (accessGrant == null) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "unknown, invalid, or expired refresh token");
        }
        RefreshToken refreshToken = TokenUtil.getRefreshToken(refreshTokenValue);
        AccessGrantAttributesHolder holder = refreshToken.getGrantAttributes(this.accessGrantManager, accessGrant.getGuid());
        this.validateDpopBoundRefreshToken(holder, ctx);
        this.validateResources(holder, ctx);
        if (!PersistentGrantLifetimeHelper.isWithinIdleTimeoutWindow(accessGrant)) {
            this.accessGrantManager.revokeGrant(accessGrant.getGuid());
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "grant revoked due to idle timeout");
        }
        if (StringUtils.isNotBlank((String)accessGrant.getUniqueUserIdentifer())) {
            AuditLogger.setUserName(accessGrant.getUniqueUserIdentifer());
        }
        Scope accessTokenScope = accessGrant.getScope();
        AuthorizationDetails authorizationDetails = accessGrant.getAuthorizationDetails();
        String requestedScopeString = req.getParameter(Parameters.SCOPE);
        String requestedAuthzDetailsStr = req.getParameter("authorization_details");
        if (!StringUtils.isEmpty((String)requestedScopeString)) {
            Scope requestedScope = Scope.getScope((String)requestedScopeString);
            if (!requestedScope.isEqualOrLesserThan(accessGrant.getScope())) {
                AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_scope);
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_scope);
            }
            accessTokenScope = requestedScope;
        }
        if (StringUtils.isNotEmpty((String)requestedAuthzDetailsStr)) {
            try {
                AuthorizationDetails requestedAuthzDetails = new AuthorizationDetails(requestedAuthzDetailsStr);
                AuthorizationDetailsUtil.enrich(requestedAuthzDetails, req, client.getClientId(), accessTokenScope);
                AuthorizationDetailContext context = new AuthorizationDetailContext(req, client.getClientId(), accessTokenScope);
                if (!AuthorizationDetailProcessorAccessor.isEqualOrSubset((AuthorizationDetails)requestedAuthzDetails, (AuthorizationDetails)accessGrant.getAuthorizationDetails(), (AuthorizationDetailContext)context)) {
                    AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_authorization_details);
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_authorization_details);
                }
                authorizationDetails = requestedAuthzDetails;
            }
            catch (IOException | AuthorizationRequestException e) {
                AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_authorization_details);
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_authorization_details);
            }
        }
        String grantClientId = accessGrant.getClientId();
        boolean setContextClientId = client.getClientId() == null;
        try {
            client = this.evalGrantClientToIdentifiedClient(client, grantClientId, "Client id does not match the id of the client to whom the refresh token was issued. Grant revoked.");
        }
        catch (AccessTokenRequestException e) {
            this.accessGrantManager.revokeGrant(accessGrant.getGuid());
            throw e;
        }
        boolean clientBypassApprovalPage = client.isBypassApprovalPage();
        boolean bypassAuthorizationForApprovedConsents = this.authzServerManager.isBypassAuthorizationForApprovedConsents();
        boolean bl = doCheckApprovedConsents = !clientBypassApprovalPage && bypassAuthorizationForApprovedConsents;
        if (doCheckApprovedConsents && !(isGranted = this.oAuthConsentManager.isGranted(accessGrant.getUniqueUserIdentifer(), accessGrant.getClientId(), accessTokenScope, authorizationDetails))) {
            this.accessGrantManager.revokeGrant(accessGrant.getGuid());
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_scope, "revoked, or expired consent");
        }
        try {
            String sri = Optional.ofNullable(holder).map(AccessGrantAttributesHolder::getExtendedGrantAttrs).map(attributeMap -> attributeMap.getSingleValue("pi.sri")).orElse(null);
            Set resources = ctx.getParam("resource", Set.class);
            if (CollectionUtils.isEmpty((Collection)resources)) {
                resources = holder.getExtendedGrantAttrs().get((Object)InternalPersistentGrantAttributes.RESOURCES.getKey()) != null ? new HashSet(((AttributeValue)holder.getExtendedGrantAttrs().get((Object)InternalPersistentGrantAttributes.RESOURCES.getKey())).getValuesAsCollection()) : Collections.emptySet();
            }
            AccessTokenResponse tokenResponse = HandlerUtil.mapAndIssueTokens(req, ctx, holder, accessGrant, accessTokenScope, client, sri, grantType, this.authzServerManager, this.tokenManager, this.oidcPolicySupport, this.idTokenSupport, this.oAuthIssuerUtils, authorizationDetails, resources);
            GrantContext<AccessTokenResponse> context = new GrantContext<AccessTokenResponse>(tokenResponse);
            if (setContextClientId) {
                context.setContextClientId(grantClientId);
            }
            boolean refreshTokenUpdated = this.updateRefreshValue(client, accessGrant, refreshToken, holder);
            boolean idleTimeoutEnabled = this.isIdleTimeoutEnabled(client);
            RefreshToken newRefreshToken = null;
            if (refreshTokenUpdated) {
                newRefreshToken = TokenUtil.rollRefreshToken(this.authzServerManager, client, refreshToken);
                newRefreshToken.store(accessGrant, holder, this.authzServerManager, client);
                TokenUtil.storeOldRefreshTokenReference(this.authzServerManager, client, accessGrant, holder, newRefreshToken, refreshToken);
                tokenResponse.setRefreshToken(newRefreshToken.getValue());
                AsAuditLogger.setOutRefreshTokenHash(newRefreshToken.getValue());
            }
            if (refreshTokenUpdated || idleTimeoutEnabled) {
                try {
                    if (idleTimeoutEnabled && this.authzServerManager.isPersistentGrantExpiryBasedOnIdleTimeout()) {
                        PersistentGrantLifetimeHelper.updateExpiryBasedOnIdleTimeout(accessGrant, client);
                    }
                    this.accessGrantManager.updateRefreshToken(accessGrant);
                    if (newRefreshToken != null && newRefreshToken.isGrantAttributeUpdateRequiredAfterRolling()) {
                        this.accessGrantManager.updateGrantAttributes(accessGrant.getGuid(), holder);
                    }
                    if (idleTimeoutEnabled) {
                        AsAuditLogger.setDescription("Access grant idle timeout reset.");
                    }
                }
                catch (AccessGrantManagementException e) {
                    this.log.warn((Object)String.format("Unexpected problem saving new refresh token value - Refresh Token Rolling (%s), Idle Timeout (%s)", refreshTokenUpdated ? "enabled" : "disabled", idleTimeoutEnabled ? "enabled" : "disabled"));
                }
            }
            return context;
        }
        catch (InvalidRequestParameterException e) {
            AsAuditLogger.setDescription(e.getMessage());
            throw new AccessTokenRequestException(e);
        }
        catch (AuthorizationException e) {
            AsAuditLogger.setDescription(e.getErrorDetail());
            if (!"ISSUANCE_CRITERIA_FAILED".equals(e.getErrorCode()) || this.authzServerManager.isRevokeRefreshTokenForFailedIssuanceCriteria()) {
                this.accessGrantManager.revokeGrant(accessGrant.getGuid());
            }
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, e.getMessage(), e);
        }
        catch (AttrLookupException e) {
            if (e.getCause() instanceof RuntimeException || e instanceof SystemAttrLookupException) {
                throw new ServerErrorException(e.getMessage());
            }
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, e.getMessage(), e);
        }
        catch (Exception e) {
            if (!(e instanceof QuietException)) {
                this.log.info((Object)e.getMessage());
            }
            throw new ServerErrorException("Internal Server Error");
        }
    }

    private boolean updateRefreshValue(Client client, AccessGrant accessGrant, RefreshToken refreshToken, AccessGrantAttributesHolder holder) {
        long rollingIntervalInMs;
        boolean roll = client.rollRefresh(this.authzServerManager.defaultRefreshTokenRollingPolicy());
        Long refreshRollingInterval = client.getRefreshTokenRollingInterval();
        String refreshTokenRollingIntervalTimeUnit = client.getRefreshTokenRollingIntervalTimeUnit();
        if (refreshRollingInterval == null) {
            refreshRollingInterval = this.authzServerManager.getRefreshRollingInterval();
            refreshTokenRollingIntervalTimeUnit = this.authzServerManager.getRefreshRollingIntervalTimeUnit();
        }
        if (!roll && refreshToken instanceof MultiPartRefreshToken) {
            return true;
        }
        if (roll && refreshRollingInterval == 0L) {
            return true;
        }
        Long refreshTokenLastRolledAt = TokenUtil.getRefreshTokenLastRolledAt(holder);
        if (refreshTokenLastRolledAt != null && refreshTokenLastRolledAt > 0L && TokenUtil.refreshTokenMustRoll(refreshTokenLastRolledAt, refreshRollingInterval, refreshTokenRollingIntervalTimeUnit)) {
            return true;
        }
        if ((refreshTokenLastRolledAt == null || refreshTokenLastRolledAt == 0L) && roll && refreshRollingInterval > 0L) {
            return true;
        }
        long elapsedTimeSinceAccessGrantUpdated = System.currentTimeMillis() - accessGrant.getUpdated();
        boolean isRefreshNeeded = elapsedTimeSinceAccessGrantUpdated > (rollingIntervalInMs = RefreshTokenRollingIntervalHelper.convertIntervalToMilliSeconds(refreshRollingInterval, refreshTokenRollingIntervalTimeUnit));
        return roll && isRefreshNeeded;
    }

    private boolean isIdleTimeoutEnabled(Client client) {
        return client.getPersistentGrantIdleTimeout() > 0L || client.getPersistentGrantIdleTimeoutType().equals("SERVER_DEFAULT") && this.authzServerManager.getGlobalPersistentGrantIdleTimeout() > 0L;
    }

    private void validateDpopBoundRefreshToken(AccessGrantAttributesHolder holder, InMessageContext inMsgCtx) throws AccessTokenRequestException {
        String jwkThumbprintFromAccessGrant = DpopUtil.getJwkThumbprintFromAccessGrantAttributesHolder(holder);
        if (jwkThumbprintFromAccessGrant == null) {
            return;
        }
        String jwkThumbprintFromTokenRequest = inMsgCtx.getParam("dpop_jkt");
        if (jwkThumbprintFromTokenRequest == null) {
            AsAuditLogger.setDescription("DPoP header not found");
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_dpop_proof, "DPoP header not found");
        }
        if (!DpopUtil.isJwkThumbprintMatching(jwkThumbprintFromTokenRequest, jwkThumbprintFromAccessGrant)) {
            AsAuditLogger.setDescription("The public key in DPoP proof does not match the public key bound to the refresh token");
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_dpop_proof, "The public key in DPoP proof does not match the public key bound to the refresh token");
        }
    }

    private void validateResources(AccessGrantAttributesHolder holder, InMessageContext ctx) throws AccessTokenRequestException {
        Set requestedResources = ctx.getParam("resource", Set.class);
        HashSet authorizedResources = holder.getExtendedGrantAttrs().get((Object)InternalPersistentGrantAttributes.RESOURCES.getKey()) != null ? new HashSet(((AttributeValue)holder.getExtendedGrantAttrs().get((Object)InternalPersistentGrantAttributes.RESOURCES.getKey())).getValuesAsCollection()) : Collections.emptySet();
        ResourceIndicatorsUtils.validateResourcesAuthorized(requestedResources, authorizedResources);
    }
}

