/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.InputValidator;
import com.pingidentity.common.security.InvalidInputException;
import com.pingidentity.common.security.LockingService;
import com.pingidentity.common.security.UsernameRule;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.PasswordValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.oauth20.handlers.ServerErrorException;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.oauth20.protocol.GrantParamHelper;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;

public class ResourceOwnerPwdCredsGrantProcessor
implements GrantProcessor {
    private static final String NO_VALIDATOR_MAPPINGS_CONFIGURED = "No validator mappings configured.";
    private static final String UNIDENTIFIED_CLIENT_ID = "Unidentified clients cannot make ";
    private static final String USERNAME_PASSWORD_ERROR = "username & password combination.";
    private static final String PASSWORD_VALIDATOR_SYSTEM_ERROR = "System error: fail to process username & password combination.";
    private static final String VALIDATOR_ID = "validator_id";
    private static final String INVALID_VALIDATOR_ID = "Invalid validator_id";
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthzServerManager authzServerManager;
    private final PasswordCredentialValidatorManager credValidatorMgr;
    private final LockingService accountLockingService;
    private final ContextUtil contextUtil = new ContextUtil();

    public ResourceOwnerPwdCredsGrantProcessor(AuthzServerManager asm, PasswordCredentialValidatorManager cvm, LockingService accountLockingService) {
        this.authzServerManager = asm;
        this.credValidatorMgr = cvm;
        this.accountLockingService = accountLockingService;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        String tokenManagerId;
        Collection<PluginToUserKeyAttrMapping> pluginToUserKeyAttrMappings;
        String username = GrantParamHelper.getParam(req, "username", true, grantType);
        try {
            InputValidator.validate(this.getClass().getName() + ".username", username, new UsernameRule());
        }
        catch (InvalidInputException e) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_client);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, "username has invalid content,", e);
        }
        String password = GrantParamHelper.getParam(req, "password", true, grantType);
        String passwordKey = AccountLockingService.buildPasswordLockingKey(password);
        String accountKey = AccountLockingService.getUserKey(req.getRemoteAddr(), username);
        LockingService.IsLockedRequest usernameRequest = new LockingService.IsLockedRequest.Builder(accountKey).loginType(LockingService.FailedLoginType.USERNAME).build();
        LockingService.IsLockedRequest passwordRequest = new LockingService.IsLockedRequest.Builder(passwordKey).loginType(LockingService.FailedLoginType.PASSWORD).build();
        this.checkIsLocked(usernameRequest, passwordRequest);
        String validatorId = GrantParamHelper.getParam(req, VALIDATOR_ID, false, grantType);
        if (client.getClientId() == null && !this.authzServerManager.allowUnidentifiedClientROCreds()) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_client);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, UNIDENTIFIED_CLIENT_ID + grantType + " grant type requests");
        }
        if (!StringUtils.isBlank((String)validatorId)) {
            AsAuditLogger.setValidatorId(validatorId);
            PluginToUserKeyAttrMapping mapping = this.authzServerManager.getPwdCredValidatorToUserKeyMapping(validatorId);
            if (mapping == null) {
                AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_request);
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, INVALID_VALIDATOR_ID);
            }
            pluginToUserKeyAttrMappings = Collections.singleton(mapping);
        } else {
            pluginToUserKeyAttrMappings = this.getAllowedPluginToUserKeyAttrMappings(client);
        }
        if (pluginToUserKeyAttrMappings.isEmpty()) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, NO_VALIDATOR_MAPPINGS_CONFIGURED);
        }
        UserKeyAttributes userKeyAttributes = null;
        String instanceId = null;
        int totalNumPlugins = pluginToUserKeyAttrMappings.size();
        int i = 0;
        Throwable attrLookupException = null;
        AttributeMap attributes = null;
        PasswordCredentialValidatorAuthnException latestException = null;
        for (PluginToUserKeyAttrMapping mapping : pluginToUserKeyAttrMappings) {
            String userKeyValue;
            block29: {
                ++i;
                instanceId = mapping.getSourcePluginId();
                PasswordCredentialValidator credentialValidator = this.credValidatorMgr.getValidator(instanceId);
                try {
                    attributes = credentialValidator.processPasswordCredential(username, password);
                }
                catch (PasswordCredentialValidatorAuthnException e) {
                    this.log.debug((Object)("Problem in password credential validating for instance id: " + instanceId), (Throwable)e);
                    if (!AuthenticationResultEnum.USER_NOT_FOUND.getMessageKey().equals(e.getMessageKey())) {
                        latestException = e;
                    }
                    if (i == totalNumPlugins) {
                        String messageKey = latestException != null ? latestException.getMessageKey() : e.getMessageKey();
                        String errorDetail = LocaleUtil.getLocalizedString(req, "pingfederate-messages", messageKey, null);
                        if (messageKey != null && (messageKey.contains(AuthenticationResultEnum.INVALID_CREDENTIALS.getMessageKey()) || messageKey.contains(AuthenticationResultEnum.USER_NOT_FOUND.getMessageKey()))) {
                            this.accountLockingService.logFailedLogin(accountKey);
                            this.accountLockingService.logFailedPassword(passwordKey);
                            this.checkIsLocked(usernameRequest, passwordRequest);
                        }
                        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, errorDetail);
                    }
                }
                catch (PasswordValidationException e) {
                    this.log.debug((Object)("Credentials could not be validated for instance id: " + instanceId), (Throwable)e);
                    if (i == totalNumPlugins) {
                        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, PASSWORD_VALIDATOR_SYSTEM_ERROR);
                    }
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)("Problem in password credential validating for instance id: " + instanceId), (Throwable)e);
                    if (i != totalNumPlugins) break block29;
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, PASSWORD_VALIDATOR_SYSTEM_ERROR);
                }
            }
            if (!Util.isEmpty(attributes)) {
                try {
                    String requestedScopeStr = ctx.getParam(Parameters.SCOPE);
                    Scope requestedScope = Scope.getScope((String)requestedScopeStr);
                    AttributeMap contextAttributes = new AttributeMap();
                    contextAttributes.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue((Collection)requestedScope.getScopeSet()));
                    contextAttributes.put(SourceContextType.OAUTH_CLIENT.getId(), new AttributeValue(client.getClientId()));
                    HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), contextAttributes);
                    contextAttributes.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(req.getRemoteAddr()));
                    contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
                    String defaultPersistenGrantLifetime = String.valueOf(PersistentGrantLifetimeHelper.getPersistentGrantExpirationTimeSettingInMins(client, this.authzServerManager));
                    contextAttributes.put(SourceContextType.OAUTH_DEFAULT_PERSISTENT_GRANT_LIFETIME.getId(), defaultPersistenGrantLifetime);
                    userKeyAttributes = mapping.execMapping(attributes, contextAttributes);
                }
                catch (AuthorizationException e) {
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, e.getMessage(), e);
                }
                catch (AttrLookupException e) {
                    this.log.warn((Object)("Problem in attribute mapping for instance id " + instanceId), (Throwable)e);
                    attrLookupException = e;
                }
                catch (ProcessRuntimeException e) {
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, e.getMessage());
                }
            }
            String string = userKeyValue = userKeyAttributes == null ? null : userKeyAttributes.getUserKeyValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("for username " + username + " validator " + instanceId + " returned " + attributes + " that mapped to user key " + userKeyValue));
            }
            if (StringUtils.isBlank((String)userKeyValue)) continue;
            AsAuditLogger.setValidatorId(instanceId);
            break;
        }
        if (userKeyAttributes == null || StringUtils.isBlank((String)userKeyAttributes.getUserKeyValue())) {
            this.accountLockingService.logFailedLogin(accountKey);
            this.accountLockingService.logFailedPassword(passwordKey);
            if (this.accountLockingService.isLocked(usernameRequest)) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Account Locked");
            }
            if (this.accountLockingService.isLocked(passwordRequest)) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Password Locked");
            }
            if (attrLookupException != null) {
                if (attrLookupException.getCause() instanceof RuntimeException) {
                    throw new ServerErrorException(attrLookupException.getMessage());
                }
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, attrLookupException.getMessage());
            }
            String errorDetail = LocaleUtil.getLocalizedString(req, "pingfederate-messages", AuthenticationResultEnum.USER_NOT_FOUND.getMessageKey(), null);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, errorDetail);
        }
        Scope scope = Scope.getScope((String)ctx.getParam(Parameters.SCOPE));
        Set resources = ctx.getParam("resource", Set.class);
        String qualifiedId = this.contextUtil.buildQualifiedId(grantType, new OAuthSourceId(OAuthSourceId.Type.PCV, instanceId));
        TokenManagerSelector selector = new TokenManagerSelector();
        try {
            tokenManagerId = selector.selectTokenManagerId(selector.getEligibleTokenManagerIdsForContext(qualifiedId), ctx, resources, scope, client);
        }
        catch (InvalidRequestParameterException e) {
            throw new AccessTokenRequestException(e);
        }
        AttributeMap authnContextAttrs = UserKeyToAccessTokenMapping.pruneUnreferencedAttrs(attributes, qualifiedId);
        AccessGrantAttributesHolder grantAttributesHolder = new AccessGrantAttributesHolder(userKeyAttributes.getExtendedAttributes(), authnContextAttrs);
        this.accountLockingService.clearFailedLogins(accountKey);
        GrantContext context = new GrantContext(userKeyAttributes.getUserKeyValue(), grantAttributesHolder, scope, false, qualifiedId, tokenManagerId);
        context.setResourcesForMapping(resources);
        context.setResourcesForAccessGrant(resources);
        return context;
    }

    private void checkIsLocked(LockingService.IsLockedRequest usernameRequest, LockingService.IsLockedRequest passwordRequest) throws AccessTokenRequestException {
        if (this.accountLockingService.isLocked(usernameRequest)) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Account Locked");
        }
        if (this.accountLockingService.isLocked(passwordRequest)) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Password Locked");
        }
    }

    private String getPCVContextId(String pcvId) {
        return this.contextUtil.buildQualifiedId("password", new OAuthSourceId(OAuthSourceId.Type.PCV, pcvId));
    }

    private Collection<PluginToUserKeyAttrMapping> getAllowedPluginToUserKeyAttrMappings(Client client) {
        Collection<PluginToUserKeyAttrMapping> pluginToUserKeyAttrMappings;
        HashSet<String> allowedContextIds = new HashSet<String>();
        MutableBoolean allowAllContexts = new MutableBoolean();
        allowAllContexts.setValue(false);
        UserKeyToAccessTokenMapping.determineAllowedContexts(client, allowAllContexts, allowedContextIds);
        if (allowAllContexts.booleanValue()) {
            pluginToUserKeyAttrMappings = this.authzServerManager.getPwdCredValidatorToUserKeyMappings();
        } else {
            pluginToUserKeyAttrMappings = new ArrayList<PluginToUserKeyAttrMapping>();
            for (PluginToUserKeyAttrMapping mapping : this.authzServerManager.getPwdCredValidatorToUserKeyMappings()) {
                String mappingContextId = this.getPCVContextId(mapping.getContextId());
                if (!allowedContextIds.contains(mappingContextId)) continue;
                pluginToUserKeyAttrMappings.add(mapping);
            }
        }
        return pluginToUserKeyAttrMappings;
    }
}

