/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeGeneratorPolicyManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequestProcessor;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequestValidator;
import org.sourceid.oauth20.handlers.process.exchange.execution.TokenExchangeExecutionStrategy;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.websso.wrapper.InMessageContext;

public class TokenExchangeGrantProcessor
implements GrantProcessor {
    private final TokenExchangeRequestValidator validator;
    private final TokenExchangeRequestProcessor processor;

    public TokenExchangeGrantProcessor(TokenExchangeProcessorPolicyManager processorPolicyMgr, TokenExchangeGeneratorPolicyManager generatorPolicyMgr, ClientManager clientMgr, BearerAccessTokenMgmtPluginManager tokenMgr, TokenExchangeExecutionStrategy executionStrategy, AuthzServerManager authzServerManager) {
        this.validator = new TokenExchangeRequestValidator(processorPolicyMgr, clientMgr, tokenMgr, generatorPolicyMgr);
        this.processor = new TokenExchangeRequestProcessor(executionStrategy, authzServerManager);
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        TokenExchangeRequest tokenExchangeRequest;
        if (client.getClientId() == null) {
            String msg = "Client authentication (if the client has credentials) or the " + Parameters.CLIENT_ID + " parameter is required for an authorization request using the Token Exchange grant type.";
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, msg);
        }
        try {
            tokenExchangeRequest = new TokenExchangeRequest(req, client);
        }
        catch (AuthorizationRequestException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_authorization_details, e.getMessage(), e);
        }
        this.validator.validate(client, req, tokenExchangeRequest);
        return this.processor.process(client, tokenExchangeRequest, req);
    }
}

