/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange;

import java.util.HashSet;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;

public class TokenExchangeAudienceParameterValidator {
    private final ClientManager clientManager;
    private final ConnectProviderRuntimePolicySupport oidcPolicySupport;

    public TokenExchangeAudienceParameterValidator(ClientManager clientMgr, ConnectProviderRuntimePolicySupport oidcPolicySupport) {
        this.clientManager = clientMgr;
        this.oidcPolicySupport = oidcPolicySupport;
    }

    public void validate(TokenExchangeRequest tokenExchangeRequest) throws AccessTokenRequestException {
        if (tokenExchangeRequest.getAudience() != null) {
            HashSet<OpenIdConnectProviderPolicy.PolicyGroup> audPolicyGroups = new HashSet<OpenIdConnectProviderPolicy.PolicyGroup>();
            for (String audience : tokenExchangeRequest.getAudience()) {
                OpenIdConnectProviderPolicy.PolicyGroup audPolicyGroup;
                Client audClient = this.clientManager.getCachedClient(audience);
                if (audClient == null) {
                    String msg = String.format("'%s' audience value is invalid", audience);
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_target, msg);
                }
                if (!tokenExchangeRequest.getScope().hasScope("openid") || (audPolicyGroup = this.oidcPolicySupport.getPolicyGroup(audClient, false)) == null) continue;
                audPolicyGroups.add(audPolicyGroup);
            }
            if (audPolicyGroups.size() > 1) {
                String msg = "Unable to find a unique OIDC Policy for the audience values";
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_target, msg);
            }
        }
    }
}

