/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;

public class TokenExchangeRequest {
    private static final String SUBJECT_TOKEN_PARAM_NAME = "subject_token";
    private static final String SUBJECT_TOKEN_TYPE_PARAM_NAME = "subject_token_type";
    private static final String ACTOR_TOKEN_PARAM_NAME = "actor_token";
    private static final String ACTOR_TOKEN_TYPE_PARAM_NAME = "actor_token_type";
    private static final String REQUESTED_TOKEN_TYPE_PARAM_NAME = "requested_token_type";
    private static final String RESOURCE_PARAM_NAME = "resource";
    private static final String AUDIENCE_PARAM_NAME = "audience";
    private static final String SCOPE_PARAM_NAME = "scope";
    private final String subjectToken;
    private final String subjectTokenType;
    private final String actorToken;
    private final String actorTokenType;
    private final String requestedTokenType;
    private final Set<String> resource = new HashSet<String>();
    private final Set<String> audience = new HashSet<String>();
    private final Scope scope;
    private final AuthorizationDetails authorizationDetails;

    public TokenExchangeRequest(HttpServletRequest request, Client client) throws AuthorizationRequestException {
        String[] audienceValues;
        this.subjectToken = request.getParameter(SUBJECT_TOKEN_PARAM_NAME);
        this.subjectTokenType = request.getParameter(SUBJECT_TOKEN_TYPE_PARAM_NAME);
        this.actorToken = request.getParameter(ACTOR_TOKEN_PARAM_NAME);
        this.actorTokenType = request.getParameter(ACTOR_TOKEN_TYPE_PARAM_NAME);
        this.requestedTokenType = request.getParameter(REQUESTED_TOKEN_TYPE_PARAM_NAME);
        String[] resourceValues = request.getParameterValues(RESOURCE_PARAM_NAME);
        if (resourceValues != null) {
            for (String value : resourceValues) {
                if (!StringUtils.isNotBlank((String)value)) continue;
                this.resource.add(value);
            }
        }
        if ((audienceValues = request.getParameterValues(AUDIENCE_PARAM_NAME)) != null) {
            for (String value : audienceValues) {
                if (!StringUtils.isNotBlank((String)value)) continue;
                this.audience.add(value);
            }
        }
        this.scope = Scope.getScope((String)request.getParameter(SCOPE_PARAM_NAME));
        AuthorizationDetails authorizationDetails = AuthorizationDetailsUtil.getAuthorizationDetails(request.getParameter("authorization_details"));
        AuthorizationDetailsUtil.enrich(authorizationDetails, request, client.getClientId(), this.scope);
        this.authorizationDetails = authorizationDetails;
    }

    public String getSubjectTokenType() {
        return this.subjectTokenType;
    }

    public String getSubjectToken() {
        return this.subjectToken;
    }

    public String getActorTokenType() {
        return this.actorTokenType;
    }

    public String getActorToken() {
        return this.actorToken;
    }

    public String getRequestedTokenType() {
        return this.requestedTokenType;
    }

    public Set<String> getResource() {
        return this.resource;
    }

    public Set<String> getAudience() {
        return this.audience;
    }

    public Scope getScope() {
        return this.scope;
    }

    public AuthorizationDetails getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public String toString() {
        return "TokenExchangeRequest{subjectToken='********', subjectTokenType='" + this.subjectTokenType + "', actorToken='********', actorTokenType='" + this.actorTokenType + "', requestedTokenType='" + this.requestedTokenType + "', resource=" + this.resource + ", audience=" + this.audience + ", scope=" + this.scope + ", authorization_details=" + this.authorizationDetails.toJson() + "}";
    }
}

