/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.authorizationdetails.domain.InvalidAuthorizationDetailException;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.InvalidRequestedScopeException;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeGeneratorPolicyManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.exchange.manager.exception.TokenExchangeProcessorPolicyException;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeAudienceParameterValidator;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeResourceParameterValidator;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;

public final class TokenExchangeRequestValidator {
    private final TokenExchangeProcessorPolicyManager processorPolicyMgr;
    private final ClientManager clientMgr;
    private final BearerAccessTokenMgmtPluginManager tokenMgr;
    private final TokenExchangeGeneratorPolicyManager generatorPolicyMgr;
    private final ConnectProviderRuntimePolicySupport oidcPolicySupport;

    public TokenExchangeRequestValidator(TokenExchangeProcessorPolicyManager processorPolicyMgr, ClientManager clientMgr, BearerAccessTokenMgmtPluginManager tokenMgr, TokenExchangeGeneratorPolicyManager generatorPolicyMgr) {
        this.processorPolicyMgr = processorPolicyMgr;
        this.clientMgr = clientMgr;
        this.tokenMgr = tokenMgr;
        this.generatorPolicyMgr = generatorPolicyMgr;
        this.oidcPolicySupport = new ConnectProviderRuntimePolicySupport();
    }

    public void validate(Client client, HttpServletRequest request, TokenExchangeRequest tokenExchangeRequest) throws AccessTokenRequestException {
        if (StringUtils.isBlank((String)tokenExchangeRequest.getSubjectToken())) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "'subject_token is required'");
        }
        if (StringUtils.isBlank((String)tokenExchangeRequest.getSubjectTokenType())) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "'subject_token_type is required'");
        }
        if (StringUtils.isBlank((String)tokenExchangeRequest.getActorToken()) && StringUtils.isNotBlank((String)tokenExchangeRequest.getActorTokenType())) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "'actor_token_type should not be present'");
        }
        if (StringUtils.isBlank((String)tokenExchangeRequest.getActorTokenType()) && StringUtils.isNotBlank((String)tokenExchangeRequest.getActorToken())) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "'actor_token_type is required'");
        }
        try {
            ScopeUtil.validateRequestedScope(tokenExchangeRequest.getScope(), client);
        }
        catch (InvalidRequestedScopeException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_scope, e.getMessage());
        }
        try {
            AuthorizationDetailsUtil.validate(tokenExchangeRequest.getAuthorizationDetails(), client, request, tokenExchangeRequest.getScope());
        }
        catch (InvalidAuthorizationDetailException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_authorization_details, e.getMessage());
        }
        try {
            TokenExchangeProcessorPolicy processorPolicy = this.processorPolicyMgr.getPolicyByClient(client);
            if (processorPolicy.isActorTokenRequired() && StringUtils.isBlank((String)tokenExchangeRequest.getActorToken())) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "actor_token is required");
            }
        }
        catch (TokenExchangeProcessorPolicyException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, e.getMessage());
        }
        TokenExchangeAudienceParameterValidator audienceParameterValidator = new TokenExchangeAudienceParameterValidator(this.clientMgr, this.oidcPolicySupport);
        audienceParameterValidator.validate(tokenExchangeRequest);
        TokenExchangeResourceParameterValidator resourceParameterValidator = new TokenExchangeResourceParameterValidator(this.allServerResourceUris(this.tokenMgr, this.generatorPolicyMgr));
        resourceParameterValidator.validate(tokenExchangeRequest);
    }

    private Set<String> allServerResourceUris(BearerAccessTokenMgmtPluginManager tokenMgr, TokenExchangeGeneratorPolicyManager generatorPolicyMgr) {
        HashSet<String> resourceUris = new HashSet<String>();
        resourceUris.addAll(tokenMgr.getAllResourceUris());
        resourceUris.addAll(generatorPolicyMgr.getAllResourceUris());
        return resourceUris;
    }
}

