/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange.execution;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.xml.QNameBoundVisitCallback;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectWalker;
import com.pingidentity.pingcommons.crypto.B64;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.handlers.TokenPluginSupport;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.StringSecurityToken;
import org.sourceid.wstrust.model.UsernameToken;
import org.sourceid.wstrust.model.mapper.BinarySecurityTokenVisitCallback;
import org.sourceid.wstrust.model.mapper.SamlSecurityTokenVisitCallback;
import org.sourceid.wstrust.model.mapper.UsernameTokenVisitCallback;
import org.sourceid.wstrust.plugin.process.TokenProcessor;

public class SecurityTokenCreator {
    private static final Log LOG = LogFactory.getLog(SecurityTokenCreator.class);
    private static final String CONFIG_STORE_NAME = "org.sourceid.oauth20.handlers.process.exchange.execution.SecurityTokenCreator";
    private static final List<String> DEFAULT_BASE64_REQUIRED_PLUGINS = Collections.singletonList("org.sourceid.wstrust.processor.oauth.BearerAccessTokenTokenProcessor");
    private static final String BASE_64_REQUIRED_PLUGINS_KEY_NAME = "base64-required-plugins";
    private final TokenPluginSupport tokenPluginSupport = new TokenPluginSupport();
    private final Set<Class<?>> base64RequiredPluginClasses;

    public SecurityTokenCreator() {
        ConfigStore configStore = ConfigStoreFarm.getConfig(CONFIG_STORE_NAME);
        List<String> base64RequiredPlugins = configStore.getListValue(BASE_64_REQUIRED_PLUGINS_KEY_NAME, DEFAULT_BASE64_REQUIRED_PLUGINS);
        this.base64RequiredPluginClasses = base64RequiredPlugins.stream().map(s -> {
            try {
                return Class.forName(s);
            }
            catch (ClassNotFoundException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public final SecurityToken create(String inputToken, String tokenType, AttributeMap contextAttrs, TokenProcessor<?> tokenProcessor, HttpServletRequest request) {
        Objects.requireNonNull(inputToken, "inputToken");
        Object result = null;
        Class<?> expectedTokenTypeClass = this.tokenPluginSupport.getExpectedTokenTypeClass(tokenProcessor);
        if (StringSecurityToken.class.isAssignableFrom(expectedTokenTypeClass)) {
            StringSecurityToken token = new StringSecurityToken(tokenType, inputToken);
            token.setRequest(request);
            result = token;
        } else {
            XmlObject xmlObject = this.toXmlObject(inputToken);
            if (SamlSecurityToken.class.isAssignableFrom(expectedTokenTypeClass) || UsernameToken.class.isAssignableFrom(expectedTokenTypeClass)) {
                if (xmlObject != null) {
                    result = this.getXmlSecurityToken(xmlObject);
                }
            } else if (BinarySecurityToken.class.isAssignableFrom(expectedTokenTypeClass)) {
                if (xmlObject != null) {
                    result = this.getXmlSecurityToken(xmlObject);
                } else {
                    BinarySecurityToken token = new BinarySecurityToken(null, tokenType);
                    token.setEncodingType(BinarySecurityToken.BASE64_ENCODING_TYPE);
                    if (this.isBase64EncodingRequired(tokenProcessor)) {
                        token.setEncodedData(B64.encode((byte[])Util.utf8bytes(inputToken)));
                    } else {
                        token.setEncodedData(inputToken);
                    }
                    result = token;
                }
            }
            if (result instanceof UsernameToken) {
                ((UsernameToken)result).setRequestIpAddress(contextAttrs.getSingleValue(SourceContextType.CLIENT_IP.getId()));
            }
        }
        return result;
    }

    private boolean isBase64EncodingRequired(TokenProcessor<?> tokenProcessor) {
        for (Class<?> aClass : this.base64RequiredPluginClasses) {
            if (!tokenProcessor.getClass().equals(aClass)) continue;
            return true;
        }
        return false;
    }

    private SecurityToken getXmlSecurityToken(XmlObject xmlObject) {
        ArrayList<SecurityToken> tokens = new ArrayList<SecurityToken>();
        QNameBoundVisitCallback tokenCallback = this.createTokenCallback(tokens);
        XmlObjectWalker xmlObjectWalker = new XmlObjectWalker(xmlObject);
        xmlObjectWalker.addCallback(tokenCallback);
        xmlObjectWalker.walkEveryNode();
        SecurityToken result = (SecurityToken)tokens.get(0);
        return result;
    }

    private XmlObject toXmlObject(String token) {
        String msgPattern = "Failed to create an XML Object from the payload with the following error: {0}";
        try {
            return XmlBeansUtil.parse(token, XmlObject.class);
        }
        catch (XmlException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)MessageFormat.format(msgPattern, e.getMessage()));
                LOG.debug((Object)"Base64 Decoding and retrying to create an XML object");
            }
            String decodedSubjectToken = Base64URL.decodeToString((String)token, (String)StandardCharsets.UTF_8.name());
            try {
                return XmlBeansUtil.parse(decodedSubjectToken, XmlObject.class);
            }
            catch (XmlException ignored) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)MessageFormat.format(msgPattern, ignored.getMessage()));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Unable to create an XML Object, returning");
                }
                return null;
            }
        }
    }

    private QNameBoundVisitCallback createTokenCallback(List<SecurityToken> tokenList) {
        QNameBoundVisitCallback callback = new QNameBoundVisitCallback();
        callback.addCallbackBinding(SamlSecurityTokenVisitCallback.SAML11_ASSERTION_NAME, new SamlSecurityTokenVisitCallback(tokenList));
        callback.addCallbackBinding(SamlSecurityTokenVisitCallback.SAML11_ENCRYPTED_ASSERTION_NAME, new SamlSecurityTokenVisitCallback(tokenList));
        callback.addCallbackBinding(SamlSecurityTokenVisitCallback.SAML20_ENCRYPTED_ASSERTION_NAME, new SamlSecurityTokenVisitCallback(tokenList));
        callback.addCallbackBinding(SamlSecurityTokenVisitCallback.SAML20_ASSERTION_NAME, new SamlSecurityTokenVisitCallback(tokenList));
        callback.addCallbackBinding(UsernameTokenVisitCallback.USERNAME_TOKEN_NAME, new UsernameTokenVisitCallback(tokenList));
        callback.addCallbackBinding(BinarySecurityTokenVisitCallback.BINARY_TOKEN_NAME, new BinarySecurityTokenVisitCallback(tokenList));
        return callback;
    }
}

