/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange.execution.impl;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.process.exchange.execution.InputProcessingStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.SecurityTokenCreator;
import org.sourceid.oauth20.handlers.process.exchange.execution.exception.TokenExchangeExecutionException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.handlers.TokenPluginSupport;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.process.TokenContext;
import org.sourceid.wstrust.plugin.process.TokenProcessor;

public class TokenProcessorInputProcessingStrategy
implements InputProcessingStrategy {
    private static final String END_OF_LINE = System.getProperty("line.separator");
    private static final Logger logger = LogManager.getLogger(TokenProcessorInputProcessingStrategy.class);
    private static final String LOG_MSG_TOKEN_NOT_PROCESSABLE = "Unable to process the received [%s] %s with [%s] token processor. The subject token type format might be invalid or the an incompatible token processor might be used.";
    private final TokenExchangeProcessorPolicy tokenExchangeProcessorPolicy;
    private final String subjectToken;
    private final String subjectTokenType;
    private final String subjectTokenProcessorId;
    private final TokenProcessor<SecurityToken> subjectTokenProcessor;
    private final AttributeMapping attributeMapping;
    private String actorToken;
    private String actorTokenType;
    private String actorTokenProcessorId;
    private TokenProcessor<SecurityToken> actorTokenProcessor;

    public TokenProcessorInputProcessingStrategy(TokenExchangeProcessorPolicy tokenExchangeProcessorPolicy, AttributeMapping attributeMapping, String subjectToken, String subjectTokenType, String subjectTokenProcessorId, TokenProcessor<SecurityToken> subjectTokenProcessor) {
        this.tokenExchangeProcessorPolicy = tokenExchangeProcessorPolicy;
        this.subjectToken = subjectToken;
        this.subjectTokenType = subjectTokenType;
        this.subjectTokenProcessorId = subjectTokenProcessorId;
        this.subjectTokenProcessor = subjectTokenProcessor;
        this.attributeMapping = attributeMapping;
    }

    public void setActorToken(String actorToken) {
        this.actorToken = actorToken;
    }

    public void setActorTokenType(String actorTokenType) {
        this.actorTokenType = actorTokenType;
    }

    public void setActorTokenProcessorId(String actorTokenProcessorId) {
        this.actorTokenProcessorId = actorTokenProcessorId;
    }

    public void setActorTokenProcessor(TokenProcessor<SecurityToken> actorTokenProcessor) {
        this.actorTokenProcessor = actorTokenProcessor;
    }

    @Override
    public TokenExchangeProcessorPolicy getTokenExchangeProcessorPolicy() {
        return this.tokenExchangeProcessorPolicy;
    }

    @Override
    public AttributeMap process(AttributeMap context, HttpServletRequest request) throws TokenExchangeExecutionException {
        HashMap<String, AttributeMap> srcAttributeMap = new HashMap<String, AttributeMap>();
        SecurityTokenCreator securityTokenCreator = new SecurityTokenCreator();
        if (this.subjectTokenProcessor != null) {
            SecurityToken subjectSecurityToken = securityTokenCreator.create(this.subjectToken, this.subjectTokenType, context, this.subjectTokenProcessor, request);
            if (subjectSecurityToken == null) {
                String pluginType = this.subjectTokenProcessor.getPluginDescriptor().getType();
                String tokenType = "subject token";
                String msg = String.format(LOG_MSG_TOKEN_NOT_PROCESSABLE, this.subjectTokenType, tokenType, pluginType);
                logger.error(msg);
                throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.invalid_request, "Subject Token cannot be processed");
            }
            this.doProcess(this.subjectTokenProcessor, subjectSecurityToken, srcAttributeMap, "subjecttoken.", "subjecttoken", "Subject Token");
        }
        if (StringUtils.isNotBlank((String)this.actorToken) && StringUtils.isNotBlank((String)this.actorTokenType) && this.actorTokenProcessor != null) {
            SecurityToken actorSecurityToken = securityTokenCreator.create(this.actorToken, this.actorTokenType, context, this.actorTokenProcessor, request);
            if (actorSecurityToken == null) {
                String pluginType = this.actorTokenProcessor.getPluginDescriptor().getType();
                String tokenType = "actor token";
                String msg = String.format(LOG_MSG_TOKEN_NOT_PROCESSABLE, this.actorTokenType, tokenType, pluginType);
                logger.error(msg);
                throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.invalid_request, "Actor Token cannot be processed");
            }
            this.doProcess(this.actorTokenProcessor, actorSecurityToken, srcAttributeMap, "actortoken.", "actortoken", "Actor Token");
        }
        if (context != null) {
            srcAttributeMap.put("context", context);
        }
        try {
            return this.attributeMapping.executeMapping(srcAttributeMap, this.attributeMapping.getAttributeMapping().keySet());
        }
        catch (AttrLookupException e) {
            throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.server_error, e.getMessage(), e);
        }
        catch (AuthorizationException e) {
            throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.access_denied, e.getMessage(), e);
        }
    }

    @Override
    public StringBuilder getInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("Subject Token: ").append("******").append(END_OF_LINE);
        builder.append("Subject Token Type: ").append(this.subjectTokenType).append(END_OF_LINE);
        builder.append("Subject Token Processor ID: ").append(this.subjectTokenProcessorId).append(END_OF_LINE);
        if (this.actorTokenProcessor != null) {
            builder.append("Actor Token: ").append("******").append(END_OF_LINE);
            builder.append("Actor Token Type: ").append(this.actorTokenType).append(END_OF_LINE);
            builder.append("Actor Token Processor ID: ").append(this.actorTokenProcessorId).append(END_OF_LINE);
        }
        return builder;
    }

    private void doProcess(TokenProcessor<SecurityToken> tokenProcessor, SecurityToken securityToken, HashMap<String, AttributeMap> srcAttributeMap, String tokenParamKeyPrefix, String tokenSourceKeyType, String tokenTypeStr) throws TokenExchangeExecutionException {
        TokenPluginSupport tokenPluginSupport = new TokenPluginSupport();
        Class<SecurityToken> expectedTokenTypeClass = tokenPluginSupport.getExpectedTokenTypeClass(tokenProcessor);
        if (!expectedTokenTypeClass.isInstance(securityToken)) {
            String text = "[%s] cannot be processed by [%s] token processor due to token type incompatibility. Please review server configuration.";
            String tokenProcessorType = tokenProcessor.getPluginDescriptor().getType();
            String logMsg = String.format(text, tokenTypeStr, tokenProcessorType);
            logger.error(logMsg);
            String msg = String.format("%s cannot be processed", tokenTypeStr);
            throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.invalid_request, msg);
        }
        try {
            TokenContext tokenContext = tokenProcessor.processToken(securityToken);
            if (tokenContext != null) {
                AttributeMap attributeMap = new AttributeMap();
                for (Map.Entry entry : tokenContext.getSubjectAttributes().entrySet()) {
                    attributeMap.put(tokenParamKeyPrefix + (String)entry.getKey(), (AttributeValue)entry.getValue());
                }
                srcAttributeMap.put(tokenSourceKeyType, attributeMap);
            }
        }
        catch (TokenProcessingException e) {
            String tokenProcessorType = tokenProcessor.getPluginDescriptor().getType();
            String text = "[%s] token processor failed processing [%s] token type.";
            String msg = String.format(text, tokenProcessorType, tokenTypeStr);
            logger.error(msg);
            throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.invalid_request, e.getMessage());
        }
    }
}

