/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.introspection;

import java.security.Key;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.HmacKey;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.JoseException;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.process.introspection.IntrospectionRequestTokenProcessor;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.token.TokenIntrospectResponse;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.util.EncryptionUtil;

public class IdTokenIntrospectionRequestTokenProcessor
implements IntrospectionRequestTokenProcessor {
    private static final Log log = LogFactory.getLog(IdTokenIntrospectionRequestTokenProcessor.class);
    private final Client client;
    private final HttpServletRequest request;
    private final ConnectProviderRuntimePolicySupport connectProviderRuntimePolicySupport;
    private final OAuthIssuerUtils oAuthIssuerUtils;

    public IdTokenIntrospectionRequestTokenProcessor(Client client, HttpServletRequest request, ConnectProviderRuntimePolicySupport connectProviderRuntimePolicySupport, OAuthIssuerUtils oAuthIssuerUtils) {
        this.client = client;
        this.request = request;
        this.connectProviderRuntimePolicySupport = connectProviderRuntimePolicySupport;
        this.oAuthIssuerUtils = oAuthIssuerUtils;
    }

    @Override
    public Optional<TokenIntrospectResponse> processToken(String token) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.connectProviderRuntimePolicySupport.getPolicyGroup(this.client);
        if (!policyGroup.isAllowIdTokenIntrospection()) {
            log.debug((Object)"ID token introspection is disabled.");
            return Optional.empty();
        }
        try {
            if (token != null) {
                log.debug((Object)"Attempting to decode this as an ID token");
                ProcessedIdToken processedIdToken = this.validateIdToken(token, this.client, this.request);
                if (!processedIdToken.isJwsSignatureVerified()) {
                    log.debug((Object)"Invalid ID token.");
                    TokenIntrospectResponse.Builder defaultResponseBuilder = new TokenIntrospectResponse.Builder(false).setTokenType(null);
                    return Optional.ofNullable(defaultResponseBuilder.build(this.client));
                }
                TokenIntrospectResponse.Builder tokenResponseBuilder = this.getIDTokenIntroRespBuilder(this.client, processedIdToken);
                if (tokenResponseBuilder != null) {
                    log.debug((Object)"Valid ID token.");
                    return Optional.ofNullable(tokenResponseBuilder.build(this.client));
                }
            }
        }
        catch (InvalidAlgorithmException e) {
            log.debug((Object)("Invalid algorithm exception: " + e));
        }
        catch (JoseException e) {
            log.debug((Object)("Jose exception: " + e));
        }
        return Optional.empty();
    }

    private ProcessedIdToken validateIdToken(String idTokenValue, Client client, HttpServletRequest request) throws JoseException {
        KeyPersuasion keyPersuasion;
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setJwsAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE).setExpectedAudience(new String[]{client.getClientId()}).setExpectedIssuer(this.oAuthIssuerUtils.getIssuerValue(request)).setRequireExpirationTime().setRequireIssuedAt();
        JsonWebStructure jsonWebStructure = JsonWebStructure.fromCompactSerialization((String)idTokenValue);
        JsonWebSignature jws = null;
        JsonWebEncryption jwe = null;
        if (jsonWebStructure instanceof JsonWebEncryption) {
            jwe = (JsonWebEncryption)jsonWebStructure;
        }
        if (jwe != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("JWE: " + jwe.getHeaders().getFullHeaderAsJsonString()));
            }
            keyPersuasion = jwe.getAlgorithm().getKeyPersuasion();
            switch (keyPersuasion) {
                case SYMMETRIC: {
                    if (client.getSecretAsUtf8Bytes() == null || client.getSecretAsUtf8Bytes().length == 0) {
                        log.warn((Object)"Client secret is missing. unable to decrypt JWE using a symmetric encryption algorithm.");
                        return new ProcessedIdToken(false, null);
                    }
                    Key key = EncryptionUtil.getSymmetricEncryptionKey(jwe.getAlgorithmHeaderValue(), jwe.getEncryptionMethodHeaderParameter(), client.getSecretAsUtf8Bytes());
                    jwe.setKey(key);
                    jwtConsumerBuilder.setDecryptionKey(key);
                    break;
                }
                case ASYMMETRIC: {
                    log.debug((Object)("Unable to locally decrypt tokens using asymmetric encryption (" + jwe.getAlgorithmHeaderValue() + ")."));
                    break;
                }
                default: {
                    log.debug((Object)("Unsupported key persuasion: " + keyPersuasion));
                }
            }
            String cty = jwe.getContentTypeHeaderValue();
            if (cty != null && (cty.equalsIgnoreCase("jwt") || cty.equalsIgnoreCase("application/jwt"))) {
                jws = new JsonWebSignature();
                jws.setCompactSerialization(jwe.getPayload());
            }
        }
        if (jsonWebStructure instanceof JsonWebSignature) {
            jws = (JsonWebSignature)jsonWebStructure;
            JwtConsumer clientIdValidatorJwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
            try {
                JwtContext jwtContext = clientIdValidatorJwtConsumer.process(idTokenValue);
                List audience = jwtContext.getJwtClaims().getAudience();
                if (audience != null && !audience.contains(client.getClientId())) {
                    log.debug((Object)"ID token audience does not match client ID.");
                    return new ProcessedIdToken(false, null);
                }
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                log.debug((Object)"Unable to process the received ID token to perform upfront optional audience validation", e);
            }
        }
        if (jws != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("JWS: " + jws.getHeaders().getFullHeaderAsJsonString() + "." + jws.getUnverifiedPayload()));
            }
            keyPersuasion = jws.getKeyPersuasion();
            switch (keyPersuasion) {
                case ASYMMETRIC: {
                    List jwks = this.oAuthIssuerUtils.getIssuersJsonWebKeySet(request).getJsonWebKeys();
                    JwksVerificationKeyResolver jwksVerificationKeyResolver = new JwksVerificationKeyResolver(jwks);
                    jwtConsumerBuilder.setVerificationKeyResolver((VerificationKeyResolver)jwksVerificationKeyResolver);
                    break;
                }
                case SYMMETRIC: {
                    if (client.getSecretAsUtf8Bytes() == null || client.getSecretAsUtf8Bytes().length == 0) {
                        log.warn((Object)"Client secret is missing. unable to verify JWS signature using a symmetric signing algorithm.");
                        return new ProcessedIdToken(false, null);
                    }
                    HmacKey macKey = new HmacKey(client.getSecretAsUtf8Bytes());
                    jwtConsumerBuilder.setVerificationKey((Key)macKey);
                    break;
                }
                default: {
                    log.debug((Object)("Unsupported key persuasion: " + keyPersuasion));
                }
            }
            try {
                JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
                JwtClaims jwtClaims = jwtConsumer.processToClaims(idTokenValue);
                if (jwtClaims.getNotBefore() != null) {
                    NumericDate evaluationTime = NumericDate.now();
                    if (jwtClaims.getNotBefore().isBefore(evaluationTime)) {
                        log.debug((Object)"ID token is not yet valid.");
                        return new ProcessedIdToken(false, null);
                    }
                }
                return new ProcessedIdToken(true, jwtClaims);
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                log.debug((Object)("Unable to process JWT claims: " + e.getMessage()));
                return new ProcessedIdToken(false, null);
            }
        }
        return new ProcessedIdToken(false, null);
    }

    private TokenIntrospectResponse.Builder getIDTokenIntroRespBuilder(Client client, ProcessedIdToken processedIdToken) {
        try {
            JwtClaims jwtClaims = processedIdToken.getJwtClaims();
            if (jwtClaims != null) {
                TokenIntrospectResponse.Builder tokenResponseBuilder = new TokenIntrospectResponse.Builder(processedIdToken.isJwsSignatureVerified());
                tokenResponseBuilder.setClientId(client.getClientId());
                tokenResponseBuilder.setAudience(jwtClaims.getAudience());
                tokenResponseBuilder.setExpiresAt(jwtClaims.getExpirationTime().getValue());
                tokenResponseBuilder.setIssuedAt(jwtClaims.getIssuedAt().getValue());
                tokenResponseBuilder.setIssuedBy(jwtClaims.getIssuer());
                tokenResponseBuilder.setTokenId(jwtClaims.getJwtId());
                tokenResponseBuilder.setSubject(jwtClaims.getSubject());
                tokenResponseBuilder.setTokenType(null);
                if (jwtClaims.getNotBefore() != null) {
                    tokenResponseBuilder.setNotBefore(jwtClaims.getNotBefore().getValue());
                }
                return tokenResponseBuilder;
            }
        }
        catch (MalformedClaimException e) {
            log.debug((Object)("Malformed claim exception: " + e));
        }
        return null;
    }

    private static class ProcessedIdToken {
        private final boolean jwsSignatureVerified;
        private final JwtClaims jwtClaims;

        private ProcessedIdToken(boolean jwsSignatureVerified, JwtClaims jwtClaims) {
            this.jwsSignatureVerified = jwsSignatureVerified;
            this.jwtClaims = jwtClaims;
        }

        private JwtClaims getJwtClaims() {
            return this.jwtClaims;
        }

        private boolean isJwsSignatureVerified() {
            return this.jwsSignatureVerified;
        }
    }
}

