/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.issuer;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.issuer.OAuthIssuerManager;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class OAuthAudienceUtils {
    private static final OAuthAudienceUtils instance = new OAuthAudienceUtils(MgmtFactory.getAuthzServerManager(), MgmtFactory.getOAuthIssuerManager(), OAuthIssuerUtils.getInstance());
    private final AuthzServerManager authzServerManager;
    private final OAuthIssuerManager oAuthIssuerManager;
    private final OAuthIssuerUtils oAuthIssuerService;

    public static OAuthAudienceUtils getInstance() {
        return instance;
    }

    private OAuthAudienceUtils(AuthzServerManager authzServerManager, OAuthIssuerManager oAuthIssuerManager, OAuthIssuerUtils oAuthIssuerService) {
        this.authzServerManager = authzServerManager;
        this.oAuthIssuerManager = oAuthIssuerManager;
        this.oAuthIssuerService = oAuthIssuerService;
    }

    public Set<String> getAudienceValues(HttpServletRequest request) {
        HashSet<String> audiences = new HashSet<String>();
        if (this.authzServerManager.isRelaxedAudienceValidation()) {
            Set allVirtualIssuers = this.oAuthIssuerManager.getAll().stream().map(oAuthIssuer -> oAuthIssuer.constructIssuer(request)).collect(Collectors.toSet());
            audiences.addAll(allVirtualIssuers);
        }
        audiences.add(this.oAuthIssuerService.getIssuerValue(request));
        return audiences;
    }
}

