/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.issuer;

import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.crypto.jwk.JwkWrapper;
import javax.servlet.http.HttpServletRequest;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jws.EcdsaUsingShaAlgorithm;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.wrapper.BaseMessageContext;

public final class OAuthIssuerUtils {
    public static final String REQUEST_OAUTH_ISSUER_ATTR_NAME = "com.pingidentity.oauth.issuer";
    private static final OAuthIssuerUtils instance = new OAuthIssuerUtils(MgmtFactory.getJwkFacilitator());
    private final JwkFacilitator jwkFacilitator;

    public static OAuthIssuerUtils getInstance() {
        return instance;
    }

    private OAuthIssuerUtils(JwkFacilitator jwkFacilitator) {
        this.jwkFacilitator = jwkFacilitator;
    }

    public void addOAuthIssuerToRequest(HttpServletRequest request, OAuthIssuer oAuthIssuer) {
        request.setAttribute(REQUEST_OAUTH_ISSUER_ATTR_NAME, (Object)oAuthIssuer);
    }

    public OAuthIssuer getOAuthIssuerFromRequest(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        Object attribute = request.getAttribute(REQUEST_OAUTH_ISSUER_ATTR_NAME);
        if (attribute instanceof OAuthIssuer) {
            return (OAuthIssuer)attribute;
        }
        return null;
    }

    public String getIssuerValue(HttpServletRequest request) {
        OAuthIssuer oAuthIssuer = this.getOAuthIssuerFromRequest(request);
        String result = oAuthIssuer != null ? oAuthIssuer.constructIssuer(request) : BaseUrlAccessor.getCurrentBaseUrl();
        return result;
    }

    public void setMessageContextOAuthIssuerIfApplicable(HttpServletRequest request, BaseMessageContext msgCtx) {
        OAuthIssuer oAuthIssuer = this.getOAuthIssuerFromRequest(request);
        if (oAuthIssuer != null) {
            msgCtx.setOauthIssuer(oAuthIssuer);
        }
    }

    public void setAuditLogVirtualServerIdIfApplicable(HttpServletRequest request) {
        OAuthIssuer oAuthIssuer = this.getOAuthIssuerFromRequest(request);
        if (oAuthIssuer != null) {
            AuditLogger.setVirtualServerId(oAuthIssuer.constructIssuer(request));
        }
    }

    public void setAuditLogVirtualServerId(String issuerId) {
        if (issuerId == null) {
            return;
        }
        OAuthIssuer oAuthIssuer = MgmtFactory.getOAuthIssuerManager().getById(issuerId);
        if (oAuthIssuer != null) {
            AuditLogger.setVirtualServerId(oAuthIssuer.constructIssuerWithoutPort());
        }
    }

    public JsonWebKeySet getIssuersJsonWebKeySet(HttpServletRequest req) {
        OAuthIssuer oAuthIssuer = this.getOAuthIssuerFromRequest(req);
        JsonWebKeySet jwkSet = oAuthIssuer == null ? this.jwkFacilitator.getJsonWebKeySet() : this.jwkFacilitator.getJsonWebKeySet(oAuthIssuer.getId());
        return jwkSet;
    }

    public JwkWrapper getCurrentRsaKey(String issuerId, String signingAlgorithm) {
        JwkWrapper result = issuerId == null ? this.jwkFacilitator.getCurrentRsaKey(signingAlgorithm) : this.jwkFacilitator.getCurrentRsaKey(issuerId, signingAlgorithm);
        return result;
    }

    public JwkWrapper getCurrentEcKey(EcdsaUsingShaAlgorithm ecdsaAlgorithm, String issuerId) {
        JwkWrapper result = issuerId == null ? this.jwkFacilitator.getCurrentEcKey(ecdsaAlgorithm.getCurveName()) : this.jwkFacilitator.getCurrentEcKey(ecdsaAlgorithm.getCurveName(), issuerId);
        return result;
    }
}

