/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.issuer.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.IDGenerator;
import org.sourceid.oauth.issuer.xmlbinding.OAuthIssuerType;
import org.sourceid.oauth.issuer.xmlbinding.OAuthIssuersDocument;
import org.sourceid.oauth.issuer.xmlbinding.OAuthIssuersType;
import org.sourceid.oauth20.issuer.OAuthIssuerManager;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public class OAuthIssuerManagerImpl
implements OAuthIssuerManager,
AutoReloadable {
    private static final String FILENAME = "oauth-issuers.xml";
    private final XmlLoader xmlLoader;
    private final String directory;
    private final Map<String, OAuthIssuer> oAuthIssuers = new HashMap<String, OAuthIssuer>();

    public OAuthIssuerManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this.xmlLoader = xmlLoader;
        this.directory = sysDirInfo.getDataDirectory();
        this.loadConfig();
    }

    @Override
    public synchronized Collection<OAuthIssuer> getAll() {
        return this.oAuthIssuers.values();
    }

    @Override
    public Set<String> getIds() {
        return this.oAuthIssuers.keySet();
    }

    @Override
    public synchronized OAuthIssuer getById(String id) {
        return this.oAuthIssuers.get(id);
    }

    @Override
    public synchronized OAuthIssuer save(OAuthIssuer toSave) {
        String id = toSave.getId();
        if (id == null) {
            id = this.generateNextId();
            toSave.setId(id);
        }
        OAuthIssuer previous = this.oAuthIssuers.put(id, toSave);
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            this.saveConfig();
            AdminAuditLogger.Event event = previous == null ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY;
            scope.log(AdminAuditLogger.Component.OAUTH_VIRTUAL_ISSUERS, event, id);
        }
        return this.getById(id);
    }

    @Override
    public synchronized void delete(String id) {
        OAuthIssuer remove = this.oAuthIssuers.remove(id);
        if (remove != null) {
            try (AuditLoggerScope scope = new AuditLoggerScope();){
                this.saveConfig();
                scope.log(AdminAuditLogger.Component.OAUTH_VIRTUAL_ISSUERS, AdminAuditLogger.Event.DELETE, id);
            }
        }
    }

    @Override
    public OAuthIssuer getByHostAndPath(String host, String path) {
        Comparator compareByPathLengthDesc = (o1, o2) -> o2.getPath().length() - o1.getPath().length();
        return this.getAll().stream().filter(issuer -> issuer.getHost().equals(host)).filter(issuer -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{path}) && path.startsWith(issuer.getPath() + "/")).min(compareByPathLengthDesc).orElse(null);
    }

    private synchronized void loadConfig() {
        OAuthIssuersDocument doc;
        this.oAuthIssuers.clear();
        if (this.xmlLoader.xmlExists(this.directory, FILENAME)) {
            XmlObject xmlObject = this.xmlLoader.load(this.directory, FILENAME);
            doc = (OAuthIssuersDocument)xmlObject;
        } else {
            doc = OAuthIssuersDocument.Factory.newInstance();
            doc.addNewOAuthIssuers();
        }
        OAuthIssuersType oAuthIssuersType = doc.getOAuthIssuers();
        for (OAuthIssuerType oAuthIssuerType : oAuthIssuersType.getOAuthIssuerTypeArray()) {
            OAuthIssuer issuer = new OAuthIssuer(oAuthIssuerType);
            this.oAuthIssuers.put(issuer.getId(), issuer);
        }
    }

    private synchronized void saveConfig() {
        OAuthIssuersDocument doc = OAuthIssuersDocument.Factory.newInstance();
        OAuthIssuersType oAuthIssuersType = doc.addNewOAuthIssuers();
        for (OAuthIssuer issuer : this.oAuthIssuers.values()) {
            OAuthIssuerType oAuthIssuerType = oAuthIssuersType.addNewOAuthIssuerType();
            oAuthIssuerType.setId(issuer.getId());
            oAuthIssuerType.setName(issuer.getName());
            oAuthIssuerType.setDescription(issuer.getDesc());
            oAuthIssuerType.setHost(issuer.getHost());
            oAuthIssuerType.setPath(issuer.getPath());
        }
        this.xmlLoader.save(this.directory, FILENAME, (XmlObject)doc);
        this.loadConfig();
    }

    private synchronized String generateNextId() {
        String id;
        while (this.oAuthIssuers.containsKey(id = IDGenerator.rndAlphaNumeric(22))) {
        }
        return id;
    }
}

