/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.protocol;

import com.pingidentity.configservice.Reloadable;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import java.io.IOException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.http.SimpleResponse;
import org.jose4j.jwk.HttpsJwks;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class HttpsJwksCache
implements Reloadable {
    private ConfigStore config = ConfigStoreFarm.getConfig("https-jwks-cache-config");
    private Map<String, HttpsJwks> httpsJwksMap = new ConcurrentHashMap<String, HttpsJwks>();
    private static final HttpsJwksCache instance = new HttpsJwksCache();

    private HttpsJwksCache() {
        MgmtFactory.getTrustedCAsManager().registerForReloadEvents(this);
        this.reload();
    }

    public static HttpsJwksCache getInstance() {
        return instance;
    }

    public HttpsJwks getJwks(String jwksUri) {
        return this.getJwks(jwksUri, null);
    }

    public HttpsJwks getJwks(String jwksUri, String issuer) {
        HttpsJwks httpsJwks = this.httpsJwksMap.get(jwksUri);
        if (httpsJwks == null) {
            int defaultCacheDuration = this.config.getIntValue("cache-duration", 3600);
            httpsJwks = new HttpsJwks(jwksUri);
            httpsJwks.setSimpleHttpGet((SimpleGet)this.getSimpleGet(issuer));
            httpsJwks.setDefaultCacheDuration((long)defaultCacheDuration);
            httpsJwks.setRetainCacheOnErrorDuration((long)(defaultCacheDuration / 2));
            this.httpsJwksMap.put(jwksUri, httpsJwks);
        }
        return httpsJwks;
    }

    private Get getSimpleGet(String issuer) {
        Get get = issuer != null ? new InstrumentedGet(issuer) : new Get();
        TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
        Set<TrustAnchor> allTrustAnchors = trustedCAsManager.getAllTrustAnchors();
        ArrayList<X509Certificate> trustedCertificates = new ArrayList<X509Certificate>();
        for (TrustAnchor ta : allTrustAnchors) {
            trustedCertificates.add(ta.getTrustedCert());
        }
        get.setHostnameVerifier((HostnameVerifier)SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        get.setTrustedCertificates(trustedCertificates);
        return get;
    }

    @Override
    public void reload() {
        this.httpsJwksMap.clear();
    }

    private static class InstrumentedGet
    extends Get {
        private final String issuer;

        public InstrumentedGet(String issuer) {
            this.issuer = issuer;
        }

        public SimpleResponse get(String location) throws IOException {
            TimerScope ignored = Meters.getTimerScope("connection.jwks", "connection.id", this.issuer);
            try {
                SimpleResponse simpleResponse = super.get(location);
                if (ignored != null) {
                    ignored.close();
                }
                return simpleResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Meters.getCounter("connection.jwks.errors", "connection.id", this.issuer).increment();
                    throw e;
                }
            }
        }
    }
}

