/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.service.impl;

import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.crypto.jwk.JwkWrapper;
import com.pingidentity.crypto.jws.JwsSignatureUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.EcdsaUsingShaAlgorithm;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jws.JsonWebSignatureAlgorithm;
import org.jose4j.keys.HmacKey;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.JoseException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.oauth20.protocol.HttpsJwksCache;
import org.sourceid.oauth20.service.OAuthJwtTokenService;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.openid.connect.SigningAlgorithmException;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.util.EncryptionUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class OAuthJwtTokenServiceJose4jImpl
implements OAuthJwtTokenService {
    private static final String INVALID_KEY_PERSUASION_MSG = "Unknown or unsupported key persuasion: %s for JOSE algorithm %s";
    private static final Log log = LogFactory.getLog(OAuthJwtTokenServiceJose4jImpl.class);
    private final OAuthIssuerUtils oAuthIssuerUtils;
    private final PkCertManager pkCertManager;
    private final ConnectProviderRuntimePolicySupport policySupport;
    private final JwkFacilitator jwkFacilitator;
    private static final List<String> SENSITIVE_CLAIMS_DEFAULT_VALUE = Arrays.asList("access_token", "refresh_token", "code", "id_token");
    private static final String SENSITIVE_CLAIMS_CONFIG_STORE_FIELD_NAME = "sensitive-claims";
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.oauth20.service.OAuthJwtTokenService");

    public OAuthJwtTokenServiceJose4jImpl() {
        this(OAuthIssuerUtils.getInstance(), MgmtFactory.getDsigPkCertManager(), new ConnectProviderRuntimePolicySupport(), MgmtFactory.getJwkFacilitator());
    }

    public OAuthJwtTokenServiceJose4jImpl(OAuthIssuerUtils oAuthIssuerUtils, PkCertManager pkCertManager, ConnectProviderRuntimePolicySupport policySupport, JwkFacilitator jwkFacilitator) {
        this.oAuthIssuerUtils = oAuthIssuerUtils;
        this.pkCertManager = pkCertManager;
        this.policySupport = policySupport;
        this.jwkFacilitator = jwkFacilitator;
    }

    @Override
    public String issueIdToken(HttpServletRequest request, Client client, Map<String, Object> claims) {
        boolean includeX5tInIdToken;
        String signingAlgo = client.getIdTokenSigningAlgorithm(true);
        String encryptionAlgo = client.getIdTokenEncryptionAlgorithm();
        String contentEncryptionAlgo = client.getIdTokenContentEncryptionAlgorithm(true);
        String tokenType = "ID Token";
        HashMap<String, String> jwtHeaders = new HashMap<String, String>();
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.policySupport.getPolicyGroup(client);
        boolean bl = includeX5tInIdToken = policyGroup.isIncludeX5tInIdToken() && this.jwkFacilitator.isX5tAvailable();
        if (StringUtils.isNotBlank((String)policyGroup.getIdTokenTypHeaderValue())) {
            jwtHeaders.put("typ", policyGroup.getIdTokenTypHeaderValue());
        }
        try {
            return this.issue(request, client, claims, signingAlgo, encryptionAlgo, contentEncryptionAlgo, tokenType, jwtHeaders, AlgorithmConstraints.NO_CONSTRAINTS, includeX5tInIdToken);
        }
        catch (JoseException e) {
            throw new ProcessRuntimeException("Problem creating ID Token", e);
        }
    }

    @Override
    public String issueLogoutToken(String issuerId, Client client, Map<String, Object> claims) {
        String signingAlgo = client.getIdTokenSigningAlgorithm(true);
        String encryptionAlgo = client.getIdTokenEncryptionAlgorithm();
        String contentEncryptionAlgo = client.getIdTokenContentEncryptionAlgorithm(true);
        String tokenType = "Logout Token";
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.policySupport.getPolicyGroup(client);
        boolean includeX5tInToken = policyGroup.isIncludeX5tInIdToken() && this.jwkFacilitator.isX5tAvailable();
        try {
            return this.issue(issuerId, client, client.getSecretAsUtf8Bytes(), claims, signingAlgo, encryptionAlgo, contentEncryptionAlgo, tokenType, Collections.singletonMap("typ", "logout+jwt"), AlgorithmConstraints.NO_CONSTRAINTS, includeX5tInToken);
        }
        catch (JoseException e) {
            throw new ProcessRuntimeException("Problem creating Logout Token", e);
        }
    }

    @Override
    public String issueTokenIntrospectionResponse(HttpServletRequest request, Client client, Map<String, Object> claims) {
        String signingAlgo = client.getIntrospectionSigningAlgorithmOrDefault();
        String encryptionAlgo = client.getIntrospectionEncryptionAlgorithm();
        String contentEncryptionAlgo = client.getIntrospectionContentEncryptionAlgorithmOrDefault();
        String tokenType = "Token Introspection";
        HashMap<String, String> jwtHeaders = new HashMap<String, String>();
        jwtHeaders.put("typ", "token-introspection+jwt");
        try {
            return this.issue(request, client, claims, signingAlgo, encryptionAlgo, contentEncryptionAlgo, tokenType, jwtHeaders, AlgorithmConstraints.DISALLOW_NONE, false);
        }
        catch (JoseException e) {
            throw new ProcessRuntimeException("Problem creating Token Introspection JWT response", e);
        }
    }

    @Override
    public String issueAuthorizationResponse(HttpServletRequest request, Client client, Map<String, Object> claims) {
        String signingAlgo = client.getAuthorizationResponseSigningAlgorithmOrDefault();
        String encryptionAlgo = client.getAuthorizationResponseEncryptionAlgorithm();
        String contentEncryptionAlgo = client.getAuthorizationResponseContentEncryptionAlgorithmOrDefault();
        String tokenType = "JWT Secured Authorization Response";
        try {
            return this.issue(request, client, claims, signingAlgo, encryptionAlgo, contentEncryptionAlgo, tokenType, Collections.emptyMap(), AlgorithmConstraints.DISALLOW_NONE, false);
        }
        catch (JoseException e) {
            throw new ProcessRuntimeException("Problem creating JWT Secured Authorization Response", e);
        }
    }

    @Override
    public String issueUserInfoEndpointResponse(HttpServletRequest request, Client client, Map<String, Object> claims) {
        String signingAlgo = client.getUserInfoResponseSigningAlgorithm();
        String encryptionAlgo = client.getUserInfoResponseEncryptionAlgorithm();
        String contentEncryptionAlgo = client.getUserInfoResponseContentEncryptionAlgorithmOrDefault();
        String tokenType = "JWT Secured UserInfo Response";
        try {
            return this.issue(request, client, claims, signingAlgo, encryptionAlgo, contentEncryptionAlgo, tokenType, Collections.emptyMap(), AlgorithmConstraints.DISALLOW_NONE, false);
        }
        catch (JoseException e) {
            throw new ProcessRuntimeException("Problem creating JWT Secured UserInfo Response", e);
        }
    }

    private String issue(HttpServletRequest request, Client client, Map<String, Object> claims, String signingAlgo, String encryptionAlgo, String contentEncryptionAlgo, String tokenType, Map<String, String> jwtHeaders, AlgorithmConstraints constraints, boolean includeX5tInToken) throws JoseException {
        OAuthIssuer oAuthIssuer = OAuthIssuerUtils.getInstance().getOAuthIssuerFromRequest(request);
        String issuerId = oAuthIssuer != null ? oAuthIssuer.getId() : null;
        byte[] clientSecretBytes = this.getClientSecretToUse(client, request);
        return this.issue(issuerId, client, clientSecretBytes, claims, signingAlgo, encryptionAlgo, contentEncryptionAlgo, tokenType, jwtHeaders, constraints, includeX5tInToken);
    }

    private String issue(String issuerId, Client client, byte[] clientSecretBytes, Map<String, Object> claims, String signingAlgo, String encryptionAlgo, String contentEncryptionAlgo, String tokenType, Map<String, String> jwtHeaders, AlgorithmConstraints constraints, boolean includeX5tInToken) throws JoseException {
        HashMap<String, Object> claimsToLog = new HashMap<String, Object>();
        List<String> sensitiveClaims = this.configStore.getListValue(SENSITIVE_CLAIMS_CONFIG_STORE_FIELD_NAME, SENSITIVE_CLAIMS_DEFAULT_VALUE);
        for (Map.Entry<String, Object> entry : claims.entrySet()) {
            String key = entry.getKey();
            Object object = sensitiveClaims.contains(key) ? "*****" : entry.getValue();
            claimsToLog.put(key, object);
        }
        log.debug((Object)("claims into the " + tokenType + " : " + claimsToLog));
        log.debug((Object)("client [" + client.getClientId() + "] jws algorithm is [" + signingAlgo + "]"));
        String claimsInJson = JsonUtil.toJson(claims);
        JsonWebSignature jws = this.createJWSInstance(issuerId, client, clientSecretBytes, signingAlgo, tokenType, constraints, includeX5tInToken);
        for (Map.Entry entry : jwtHeaders.entrySet()) {
            jws.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        jws.setPayload(claimsInJson);
        String result = jws.getCompactSerialization();
        if (StringUtils.isNotBlank((String)encryptionAlgo)) {
            JsonWebEncryption jsonWebEncryption = this.createJWEInstance(client, clientSecretBytes, encryptionAlgo, contentEncryptionAlgo);
            jsonWebEncryption.setPayload(result);
            result = jsonWebEncryption.getCompactSerialization();
        }
        return result;
    }

    private JsonWebSignature createJWSInstance(String issuerId, Client client, byte[] clientSecretBytes, String signingAlgorithm, String tokenType, AlgorithmConstraints algorithmConstraints, boolean isIncludeX5tInIdToken) throws InvalidAlgorithmException {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmConstraints(algorithmConstraints);
        jws.setAlgorithmHeaderValue(signingAlgorithm);
        KeyPersuasion jwsKeyPersuasion = jws.getKeyPersuasion();
        switch (jwsKeyPersuasion) {
            case NONE: {
                break;
            }
            case ASYMMETRIC: {
                JwkWrapper currentSigningKey;
                String keyType;
                switch (keyType = jws.getKeyType()) {
                    case "RSA": {
                        currentSigningKey = this.oAuthIssuerUtils.getCurrentRsaKey(issuerId, jws.getAlgorithm().getAlgorithmIdentifier());
                        break;
                    }
                    case "EC": {
                        JsonWebSignatureAlgorithm algorithm = jws.getAlgorithm();
                        EcdsaUsingShaAlgorithm ecdsaAlgorithm = (EcdsaUsingShaAlgorithm)algorithm;
                        currentSigningKey = this.oAuthIssuerUtils.getCurrentEcKey(ecdsaAlgorithm, issuerId);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown key type: " + keyType);
                    }
                }
                if (currentSigningKey == null) {
                    log.error((Object)String.format("Unable to issue the requested %s, %s signing key is not present.", tokenType, keyType));
                    throw new IllegalStateException(String.format("Algorithm not supported: %s", jws.getAlgorithmHeaderValue()), new SigningAlgorithmException());
                }
                jws.setKey((Key)currentSigningKey.getPrivateKey());
                jws.setHeader("kid", currentSigningKey.getJwk().getKeyId());
                if (isIncludeX5tInIdToken) {
                    PkCert signingPkCert = this.pkCertManager.getPkCert(currentSigningKey.getPkCertID());
                    Optional<String> x5tOptional = this.getX5tFromCurrentSigningKey(currentSigningKey);
                    if (signingPkCert != null) {
                        String x5t = CertificateHelper.calculateThumb(signingPkCert.getX509Certificate());
                        jws.setHeader("x5t", x5t);
                    } else if (x5tOptional.isPresent()) {
                        jws.setHeader("x5t", x5tOptional.get());
                    } else {
                        log.warn((Object)("X.509 Certificate for Private Key " + currentSigningKey.getPkCertID() + " is null"));
                    }
                }
                JwsSignatureUtil.applyProviderOverrideContextIfNeeded(jws, currentSigningKey);
                break;
            }
            case SYMMETRIC: {
                if (ClientSecretUtils.isSecondarySecret(new String(clientSecretBytes, StandardCharsets.UTF_8), client)) {
                    ClientSecretUtils.logSecondarySecretUsage(ClientSecretUtils.ActivityType.TOKEN_SIGNING, client.getClientId());
                }
                jws.setDoKeyValidation(false);
                jws.setKey((Key)new HmacKey(clientSecretBytes));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown key persuasion" + jwsKeyPersuasion);
            }
        }
        return jws;
    }

    private Optional<String> getX5tFromCurrentSigningKey(JwkWrapper currentSigningKey) {
        PublicJsonWebKey publicJwk;
        String x5t;
        Objects.requireNonNull(currentSigningKey, "currentSigningKey");
        if (currentSigningKey.getJwk() instanceof PublicJsonWebKey && StringUtils.isNotBlank((String)(x5t = (publicJwk = (PublicJsonWebKey)currentSigningKey.getJwk()).getX509CertificateSha1Thumbprint()))) {
            return Optional.of(x5t);
        }
        return Optional.empty();
    }

    private JsonWebEncryption createJWEInstance(Client client, byte[] clientSecretBytes, String encryptionAlgorithm, String contentEncryptionAlgorithm) throws JoseException {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setAlgorithmHeaderValue(encryptionAlgorithm);
        jwe.setEncryptionMethodHeaderParameter(contentEncryptionAlgorithm);
        jwe.setContentTypeHeaderValue("JWT");
        KeyPersuasion jweKeyPersuasion = jwe.getAlgorithm().getKeyPersuasion();
        switch (jweKeyPersuasion) {
            case SYMMETRIC: {
                if (ClientSecretUtils.isSecondarySecret(new String(clientSecretBytes, StandardCharsets.UTF_8), client)) {
                    ClientSecretUtils.logSecondarySecretUsage(ClientSecretUtils.ActivityType.TOKEN_ENCRYPTION, client.getClientId());
                }
                Key symmetricEncryptionKey = EncryptionUtil.getSymmetricEncryptionKey(encryptionAlgorithm, contentEncryptionAlgorithm, clientSecretBytes);
                jwe.setKey(symmetricEncryptionKey);
                break;
            }
            case ASYMMETRIC: {
                PublicJsonWebKey encryptionJwk = null;
                if (StringUtils.isNotBlank((String)client.getJwksUrl())) {
                    HttpsJwks httpsJwks = HttpsJwksCache.getInstance().getJwks(client.getJwksUrl());
                    try {
                        List keys = httpsJwks.getJsonWebKeys();
                        encryptionJwk = EncryptionUtil.filterAsymmetricEncryptionKey(jwe, keys, httpsJwks.getLocation());
                    }
                    catch (IOException e) {
                        throw new JoseException("Unable to retrieve JWKS", (Throwable)e);
                    }
                } else if (StringUtils.isNotBlank((String)client.getJwks())) {
                    JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(client.getJwks());
                    List keys = jsonWebKeySet.getJsonWebKeys();
                    encryptionJwk = EncryptionUtil.filterAsymmetricEncryptionKey(jwe, keys, null);
                }
                if (encryptionJwk != null) {
                    jwe.setKey((Key)encryptionJwk.getPublicKey());
                    jwe.setKeyIdHeaderValue(encryptionJwk.getKeyId());
                    break;
                }
                throw new IllegalStateException(String.format(INVALID_KEY_PERSUASION_MSG, jweKeyPersuasion, jwe.getAlgorithmHeaderValue()));
            }
            default: {
                throw new IllegalStateException(String.format(INVALID_KEY_PERSUASION_MSG, jweKeyPersuasion, jwe.getAlgorithmHeaderValue()));
            }
        }
        return jwe;
    }

    private byte[] getClientSecretToUse(Client client, HttpServletRequest request) {
        byte[] clientSecretFromRequest = ClientSecretUtils.getSecretFromRequestAttribute(request);
        return clientSecretFromRequest != null ? clientSecretFromRequest : client.getSecretAsUtf8Bytes();
    }
}

