/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.access.AuthorizationDetailProcessorAccessor;
import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.JDBCHelper;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantCriteria;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailContext;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.token.AccessGrantAttribute;
import org.sourceid.oauth20.token.BaseAccessGrantManager;
import org.sourceid.oauth20.token.JdbcGrantAttrForeignKeyException;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.json.JsonUtils;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class AccessGrantManagerJdbcImpl
extends BaseAccessGrantManager {
    private static final Log log = LogFactory.getLog(AccessGrantManagerJdbcImpl.class);
    private ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    private static final String TABLENAME = "pingfederate_access_grant";
    private static final String FIELDNAME_GUID = "guid";
    private static final String FIELDNAME_HASHED_REFRESH_TOKEN = "hashed_refresh_token";
    private static final String FIELDNAME_UNIQUE_USER_ID = "unique_user_id";
    private static final String FIELDNAME_SCOPE = "scope";
    private static final String FIELDNAME_CLIENT_ID = "client_id";
    private static final String FIELDNAME_GRANT_TYPE = "grant_type";
    private static final String FIELDNAME_CONTEXT_QUALIFIER = "context_qualifier";
    private static final String FIELDNAME_ISSUED = "issued";
    private static final String FIELDNAME_UPDATED = "updated";
    private static final String FIELDNAME_EXPIRES = "expires";
    private static final String ATTR_TABLENAME = "pingfederate_access_grant_attr";
    private static final String ATTR_FIELDNAME_GRANT_GUID = "grant_guid";
    private static final String ATTR_FIELDNAME_SOURCE_TYPE = "source_type";
    private static final String ATTR_FIELDNAME_NAME = "name";
    private static final String ATTR_FIELDNAME_VALUE = "value";
    private static final String ATTR_FIELDNAME_MASKED = "masked";
    private static final String ATTR_FIELDNAME_ENCRYPTED = "encrypted";
    private static final int AUTHORIZATION_DETAIL_CHUNK_SIZE = 1500;
    private static final int GRANT_ATTR_CHUNK_SIZE = 682;
    private static final String SELECT_FOR_UPDATE_STMT = String.format("SELECT 1 FROM %s WHERE %s = ? FOR UPDATE", "pingfederate_access_grant", "guid");
    private static final String SELECT_FOR_UPDATE_SQL_SERVER_STMT = String.format("SELECT 1 FROM %s WITH (UPDLOCK, INDEX(pk_guid))  WHERE %s = ?", "pingfederate_access_grant", "guid");
    private static String selectStmt = String.format("SELECT %s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "guid", "hashed_refresh_token", "unique_user_id", "scope", "client_id", "grant_type", "context_qualifier", "issued", "updated", "expires").concat(" FROM %s WHERE %s = ?");
    private static String selectByUserKeyClientIdGrantTypeContextStmt = String.format("SELECT %s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "guid", "hashed_refresh_token", "unique_user_id", "scope", "client_id", "grant_type", "context_qualifier", "issued", "updated", "expires").concat(" FROM %s WHERE unique_user_id = ? and client_id = ? and grant_type = ? and context_qualifier = ?");
    private static String selectByUserKeyClientIdGrantTypeStmt = String.format("SELECT %s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "guid", "hashed_refresh_token", "unique_user_id", "scope", "client_id", "grant_type", "context_qualifier", "issued", "updated", "expires").concat(" FROM %s WHERE unique_user_id = ? and client_id = ? and grant_type = ?");
    private static String selectByUserKeyClientIdGrantTypeContextStmtSorted = String.format("SELECT %s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "guid", "hashed_refresh_token", "unique_user_id", "scope", "client_id", "grant_type", "context_qualifier", "issued", "updated", "expires").concat(" FROM %s WHERE unique_user_id = ? and client_id = ? and grant_type = ? and context_qualifier = ? ORDER BY updated ASC");
    private static String insertStmt = String.format("INSERT INTO %s (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s) VALUES(?,?,?,?,?,?,?,?,?,?)", "pingfederate_access_grant", "guid", "hashed_refresh_token", "unique_user_id", "scope", "client_id", "grant_type", "context_qualifier", "issued", "updated", "expires");
    private static String attrSelectStmt = String.format("SELECT %s,%s,%s,%s,%s,%s FROM %s WHERE %s = ?", "grant_guid", "source_type", "name", "value", "masked", "encrypted", "pingfederate_access_grant_attr", "grant_guid");
    private static String attrInsertStmt = String.format("INSERT INTO %s (%s,%s,%s,%s,%s,%s) VALUES(?,?,?,?,?,?)", "pingfederate_access_grant_attr", "grant_guid", "source_type", "name", "value", "masked", "encrypted");
    private static String attrDeleteStmtBySourceType = String.format("DELETE FROM %s WHERE %s = ? AND %s = ?", "pingfederate_access_grant_attr", "grant_guid", "source_type");
    private static String updateHashedRefreshTokenByGuid = String.format("UPDATE %s SET %s = ?, %s = ?, %s = ?, %s = ? WHERE guid = ?", "pingfederate_access_grant", "hashed_refresh_token", "issued", "updated", "expires");
    private static String updateExpiresByGuid = String.format("UPDATE %s SET %s = ?, %s = ?, %s = ? WHERE guid = ?", "pingfederate_access_grant", "expires", "issued", "updated");
    private static String deleteStmt = String.format("DELETE FROM %s WHERE %s = ?", "pingfederate_access_grant", "guid");
    private static String deleteByUserKeyClientIdGrantTypeContextBeforeUpdatedTime = String.format("DELETE FROM %s WHERE ", "pingfederate_access_grant").concat("unique_user_id = ? and client_id = ? and grant_type = ? and context_qualifier = ? and updated < ?");
    private String deleteExpiredGrantsStmt = String.format("DELETE FROM %s WHERE %s <= ?", "pingfederate_access_grant", "expires");

    private AccessGrant getByField(String fieldName, String fieldValue) {
        AccessGrant accessGrant = null;
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            String selectStmtForField = String.format(selectStmt, TABLENAME, fieldName);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(selectStmtForField);
            stmt.setString(1, fieldValue);
            ResultSet resultSet = jdbcHelper.getResultSet();
            if (resultSet.next()) {
                accessGrant = this.accessGrantFromResultSet(resultSet);
                accessGrant.setAuthorizationDetails(this.getAuthorizationDetails(accessGrant.getClientId(), accessGrant.getGuid()));
            }
        }
        catch (SQLException | NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to retrieve the %s field from the %s table", fieldName, TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        if (accessGrant != null && accessGrant.isExpired()) {
            this.deleteGrant(accessGrant.getGuid());
            accessGrant = null;
        }
        return accessGrant;
    }

    private AccessGrant accessGrantFromResultSet(ResultSet resultSet) throws SQLException {
        AccessGrant accessGrant = new AccessGrant(resultSet.getString(FIELDNAME_HASHED_REFRESH_TOKEN), resultSet.getString(FIELDNAME_GUID), resultSet.getString(FIELDNAME_UNIQUE_USER_ID), resultSet.getString(FIELDNAME_GRANT_TYPE), Scope.getScope((String)resultSet.getString(FIELDNAME_SCOPE)), resultSet.getString(FIELDNAME_CLIENT_ID), resultSet.getTimestamp(FIELDNAME_ISSUED).getTime(), resultSet.getTimestamp(FIELDNAME_UPDATED).getTime(), resultSet.getTimestamp(FIELDNAME_EXPIRES) != null ? Long.valueOf(resultSet.getTimestamp(FIELDNAME_EXPIRES).getTime()) : null, resultSet.getString(FIELDNAME_CONTEXT_QUALIFIER));
        this.updateContextualQualifier(accessGrant);
        return accessGrant;
    }

    @Override
    public AccessGrant doGetByRefreshToken(String refreshTokenValue) {
        return this.getByField(FIELDNAME_HASHED_REFRESH_TOKEN, TokenUtil.digestToken(refreshTokenValue));
    }

    @Override
    protected AccessGrant getByGuidInternal(String accessGrantGuid) {
        return this.getByField(FIELDNAME_GUID, accessGrantGuid);
    }

    @Override
    public void deleteGrant(String accessGrantGuid) {
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(deleteStmt);
            stmt.setString(1, accessGrantGuid);
            stmt.execute();
        }
        catch (SQLException | NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to delete a grant from the %s table", TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    @Override
    public void updateRefreshToken(AccessGrant accessGrant) {
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(updateHashedRefreshTokenByGuid);
            stmt.setString(1, accessGrant.getHashedRefreshTokenValue());
            stmt.setTimestamp(2, new Timestamp(accessGrant.getIssued()));
            stmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            if (accessGrant.getExpires() == null) {
                stmt.setNull(4, 93);
            } else {
                stmt.setTimestamp(4, new Timestamp(accessGrant.getExpires()));
            }
            stmt.setString(5, accessGrant.getGuid());
            stmt.execute();
        }
        catch (SQLException | NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to update refresh token in the %s table", TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new RuntimeException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    @Override
    public void updateExpiry(AccessGrant accessGrant) throws AccessGrantManagementException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(updateExpiresByGuid);
            stmt.setTimestamp(1, accessGrant.getExpires() != null ? new Timestamp(accessGrant.getExpires()) : null);
            stmt.setTimestamp(2, new Timestamp(accessGrant.getIssued()));
            stmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            stmt.setString(4, accessGrant.getGuid());
            stmt.execute();
        }
        catch (SQLException | NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to update refresh token in the %s table", TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    public Collection<AccessGrant> getByUserKeyClientIdGrantType(String userKey, String clientId, String grantType) throws AccessGrantManagementException {
        ArrayList<AccessGrant> accessGrants = new ArrayList<AccessGrant>();
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            String selectStmtForField = String.format(selectByUserKeyClientIdGrantTypeStmt, TABLENAME);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(selectStmtForField);
            stmt.setString(1, userKey);
            stmt.setString(2, clientId);
            stmt.setString(3, grantType);
            ResultSet resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                AccessGrant accessGrant = this.accessGrantFromResultSet(resultSet);
                if (!accessGrant.isExpired()) {
                    accessGrant.setAuthorizationDetails(this.getAuthorizationDetails(accessGrant.getClientId(), accessGrant.getGuid()));
                    accessGrants.add(accessGrant);
                    continue;
                }
                this.deleteGrant(accessGrant.getGuid());
            }
        }
        catch (SQLException | NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to retrieve an access grant from the %s table", TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        return accessGrants;
    }

    @Override
    protected void saveGrant(AccessGrant accessGrant, Collection<AccessGrantAttribute> attributes) {
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            jdbcHelper.setAutoCommit(false);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(insertStmt);
            stmt.setString(1, accessGrant.getGuid());
            stmt.setString(2, accessGrant.getHashedRefreshTokenValue());
            stmt.setString(3, accessGrant.getUniqueUserIdentifer());
            stmt.setString(4, accessGrant.getScope().getScopeStr());
            stmt.setString(5, accessGrant.getClientId());
            stmt.setString(6, accessGrant.getGrantType());
            stmt.setString(7, accessGrant.getContextualQualifier());
            stmt.setTimestamp(8, new Timestamp(accessGrant.getIssued()));
            stmt.setTimestamp(9, new Timestamp(accessGrant.getUpdated()));
            stmt.setTimestamp(10, accessGrant.getExpires() != null ? new Timestamp(accessGrant.getExpires()) : null);
            stmt.execute();
            this.saveGrantAttributes(jdbcHelper, attributes, accessGrant.getGuid());
            this.saveAuthorizationDetails(jdbcHelper, accessGrant.getGuid(), accessGrant.getAuthorizationDetails());
            jdbcHelper.commit();
        }
        catch (NamingException e) {
            log.debug((Object)"Exception caught while attempting to save grant", (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        catch (SQLException e) {
            log.debug((Object)"Exception caught while attempting to save grant", (Throwable)e);
            if (jdbcHelper != null) {
                try {
                    jdbcHelper.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        this.checkPersistentGrantLimit(accessGrant, this.getMaxGrantAllowed(), this.getMaxGrantsToDelete());
    }

    private void checkPersistentGrantLimit(AccessGrant accessGrant, int maxGrantAllowed, int maxGrantsToDelete) {
        List<AccessGrant> grants;
        if (maxGrantAllowed > 0 && (grants = this.getPersistentGrantsForLimitCheck(accessGrant.getUniqueUserIdentifer(), accessGrant.getClientId(), accessGrant.getGrantType(), accessGrant.getContextualQualifier())).size() > maxGrantAllowed) {
            int exceedByAmt = grants.size() - maxGrantAllowed;
            AccessGrant targetGrant = maxGrantsToDelete > 0 && exceedByAmt > maxGrantsToDelete ? grants.get(maxGrantsToDelete - 1) : grants.get(exceedByAmt - 1);
            this.deleteByUserKeyClientIdGrantTypeContextIssued(targetGrant.getUniqueUserIdentifer(), targetGrant.getClientId(), targetGrant.getGrantType(), targetGrant.getContextualQualifier(), targetGrant.getUpdated());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteByUserKeyClientIdGrantTypeContextIssued(String userKey, String clientId, String grantType, String contextQualifier, long updated) {
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(deleteByUserKeyClientIdGrantTypeContextBeforeUpdatedTime);
            stmt.setString(1, userKey);
            stmt.setString(2, clientId);
            stmt.setString(3, grantType);
            stmt.setString(4, contextQualifier);
            stmt.setTimestamp(5, new Timestamp(updated + 1L));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Removing grants using parameters %nuserKey = %s%nclientId = %s%ngrantType = %s%ncontextQualifier = %s%nupdated < %s", userKey, clientId, grantType, contextQualifier, new Timestamp(updated + 1L)));
            }
            int grantsDeleted = stmt.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Removed %d grant(s).", grantsDeleted));
            }
        }
        catch (SQLException | NamingException ignored) {
            log.warn((Object)"Exception thrown while deleting a grant during persistent grant limit cleanup.");
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    @Override
    protected void updateGrantAttributes(String accessGrantGuid, Collection<AccessGrantAttribute> attributes) {
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            jdbcHelper.setAutoCommit(false);
            if (this.enableParentGrantEntryLock() && !this.okLockParentGrantEntry(jdbcHelper, accessGrantGuid)) {
                log.warn((Object)String.format("Parent grant entry with GUID %s does not exist. Skipping grant attribute update.", accessGrantGuid));
                throw new JdbcGrantAttrForeignKeyException();
            }
            this.deleteSourceTypeFromAttributeTable(jdbcHelper, accessGrantGuid, 0);
            this.deleteSourceTypeFromAttributeTable(jdbcHelper, accessGrantGuid, 1);
            this.saveGrantAttributes(jdbcHelper, attributes, accessGrantGuid);
            jdbcHelper.commit();
        }
        catch (NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to update grant attributes in the %s table", ATTR_TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        catch (SQLException e) {
            log.debug((Object)String.format("Exception caught while attempting to update grant attributes in the %s table", ATTR_TABLENAME), (Throwable)e);
            if (jdbcHelper != null) {
                try {
                    jdbcHelper.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    private boolean okLockParentGrantEntry(JDBCHelper jdbcHelper, String accessGrantGuid) throws SQLException {
        String selectStmt = SELECT_FOR_UPDATE_STMT;
        if (jdbcHelper.isSqlServer()) {
            selectStmt = SELECT_FOR_UPDATE_SQL_SERVER_STMT;
        }
        try (PreparedStatement lockStmt = jdbcHelper.getPreparedStatement(selectStmt);){
            lockStmt.setString(1, accessGrantGuid);
            try (ResultSet resultSet = lockStmt.executeQuery();){
                if (!resultSet.isBeforeFirst()) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    @Override
    public Collection<AccessGrant> getByUserKey(String userKey) {
        return this.getCollectionByField(FIELDNAME_UNIQUE_USER_ID, userKey);
    }

    public Collection<AccessGrant> getByClientId(String clientId) {
        return this.getCollectionByField(FIELDNAME_CLIENT_ID, clientId);
    }

    private void saveGrantAttributes(JDBCHelper jdbcHelper, Collection<AccessGrantAttribute> attributes, String accessGrantGuid) throws SQLException {
        if (!Util.isEmpty(attributes)) {
            PreparedStatement attrStmt = jdbcHelper.getPreparedStatement(attrInsertStmt);
            ArrayList<String> jsonAttributesNames = new ArrayList<String>();
            HashMap<String, Integer> multivaluedData = new HashMap<String, Integer>();
            for (AccessGrantAttribute attr : attributes) {
                int numChunks;
                if (attr.isJsonAttribute()) {
                    jsonAttributesNames.add(attr.getName());
                }
                Object attrName = attr.getName();
                if (attr.isMultiValued()) {
                    int index = multivaluedData.get(attrName) == null ? 0 : (Integer)multivaluedData.get(attr.getName());
                    attrName = (String)attrName + this.getMultiValuedAttributeKey() + index;
                    multivaluedData.put(attr.getName(), index + 1);
                }
                String attrValue = attr.getValue();
                if (this.getEncryptAttributes()) {
                    attrValue = Obfuscator.obfuscate(attrValue);
                }
                if ((numChunks = attrValue.length() % 682 == 0 ? attrValue.length() / 682 : attrValue.length() / 682 + 1) > 1) {
                    attrName = (String)attrName + this.getChunkedAttributeKey();
                }
                for (int i = 0; i < numChunks; ++i) {
                    int chunkSize = i < attrValue.length() / 682 ? 682 : attrValue.length() - 682 * i;
                    String attrValueChunk = attrValue.substring(i * 682, i * 682 + chunkSize);
                    attrStmt.setString(1, attr.getGrantGuid());
                    attrStmt.setInt(2, attr.getSourceType());
                    if (numChunks > 1) {
                        String attrChunkName = (String)attrName + "." + String.format("%02d", i);
                        attrStmt.setString(3, attrChunkName);
                    } else {
                        attrStmt.setString(3, (String)attrName);
                    }
                    attrStmt.setString(4, attrValueChunk);
                    attrStmt.setBoolean(5, attr.isMasked());
                    attrStmt.setBoolean(6, this.getEncryptAttributes());
                    attrStmt.addBatch();
                }
            }
            if (!jsonAttributesNames.isEmpty()) {
                try {
                    String jsonAttributeNamesString = JsonUtils.getInstance().writeValueAsString(jsonAttributesNames);
                    if (this.getEncryptAttributes()) {
                        jsonAttributeNamesString = Obfuscator.obfuscate(jsonAttributeNamesString);
                    }
                    attrStmt.setString(1, accessGrantGuid);
                    attrStmt.setString(3, this.getJsonAttributesAttributeName());
                    attrStmt.setString(4, jsonAttributeNamesString);
                    attrStmt.setBoolean(5, false);
                    attrStmt.setBoolean(6, this.getEncryptAttributes());
                    attrStmt.addBatch();
                }
                catch (JsonProcessingException e) {
                    log.error((Object)"Error serializing JSON attribute names.", (Throwable)e);
                }
            }
            attrStmt.executeBatch();
        }
    }

    private void saveAuthorizationDetails(JDBCHelper jdbcHelper, String accessGrantGuid, AuthorizationDetails authorizationDetails) throws SQLException {
        if (authorizationDetails != null && authorizationDetails.getDetails() != null && !authorizationDetails.getDetails().isEmpty()) {
            String authorizationDetailsJson = authorizationDetails.toJson();
            if (this.getEncryptAttributes()) {
                authorizationDetailsJson = Obfuscator.obfuscate(authorizationDetailsJson);
            }
            byte[] authorizationDetailBytes = authorizationDetailsJson.getBytes(StandardCharsets.UTF_8);
            PreparedStatement attrStmt = jdbcHelper.getPreparedStatement(attrInsertStmt);
            for (int i = 0; i < authorizationDetailBytes.length / 1500 + 1; ++i) {
                int chunkSize = i < authorizationDetailBytes.length / 1500 ? 1500 : authorizationDetailBytes.length - 1500 * i;
                attrStmt.setString(1, accessGrantGuid);
                attrStmt.setInt(2, 2);
                attrStmt.setString(3, "authorization_details_" + i);
                byte[] attrValue = Arrays.copyOfRange(authorizationDetailBytes, i * 1500, i * 1500 + chunkSize);
                attrStmt.setString(4, B64.encode((byte[])attrValue));
                attrStmt.setBoolean(5, false);
                attrStmt.setBoolean(6, this.getEncryptAttributes());
                attrStmt.addBatch();
            }
            attrStmt.executeBatch();
        }
    }

    private AuthorizationDetails getAuthorizationDetails(String clientId, String accessGrantGuid) throws SQLException, NamingException {
        Client client = MgmtFactory.getClientManager().getCachedClient(clientId);
        if (client == null || client.getAuthorizationDetailTypes() == null || client.getAuthorizationDetailTypes().isEmpty()) {
            return null;
        }
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            PreparedStatement preparedStatement = jdbcHelper.getPreparedStatement(this.getAttrSelectPreparedStmt(2));
            preparedStatement.setString(1, accessGrantGuid);
            preparedStatement.setInt(2, 2);
            ResultSet resultSet = jdbcHelper.getResultSet();
            TreeMap<Integer, byte[]> authorizationDetailsChunks = new TreeMap<Integer, byte[]>();
            Boolean encrypted = null;
            while (resultSet.next()) {
                if (encrypted == null) {
                    encrypted = resultSet.getBoolean(ATTR_FIELDNAME_ENCRYPTED);
                } else {
                    boolean nextEncrypted = resultSet.getBoolean(ATTR_FIELDNAME_ENCRYPTED);
                    if (nextEncrypted != encrypted) {
                        throw new SQLException("authorization details encrypted flag not the same in all chunks for GUID: " + accessGrantGuid);
                    }
                }
                byte[] attrValue = B64.decodeToBytes((String)resultSet.getString(ATTR_FIELDNAME_VALUE));
                String portion = resultSet.getString(ATTR_FIELDNAME_NAME).substring("authorization_details_".length());
                authorizationDetailsChunks.put(Integer.parseInt(portion), attrValue);
            }
            if (!authorizationDetailsChunks.isEmpty()) {
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    for (Map.Entry chunks : authorizationDetailsChunks.entrySet()) {
                        outputStream.write((byte[])chunks.getValue());
                    }
                    String authorizationDetailsJson = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                    if (encrypted.booleanValue()) {
                        authorizationDetailsJson = Obfuscator.deobfuscate(authorizationDetailsJson);
                    }
                    AuthorizationDetails authorizationDetails = new AuthorizationDetails(authorizationDetailsJson);
                    return authorizationDetails;
                }
                catch (IOException e) {
                    throw new SQLException("Error deserializing stored authorization details.", e);
                }
            }
        }
        return null;
    }

    private void deleteSourceTypeFromAttributeTable(JDBCHelper jdbcHelper, String accessGrantGuid, int sourceType) throws SQLException {
        PreparedStatement deleteStmt = jdbcHelper.getPreparedStatement(attrDeleteStmtBySourceType);
        deleteStmt.setString(1, accessGrantGuid);
        deleteStmt.setInt(2, sourceType);
        deleteStmt.execute();
    }

    public AccessGrant getByAccessGrantCriteria(AccessGrantCriteria accessGrantCriteria) throws AccessGrantManagementException {
        AccessGrant accessGrant = null;
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            String selectStmtForField = String.format(selectByUserKeyClientIdGrantTypeContextStmt, TABLENAME);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(selectStmtForField);
            stmt.setString(1, accessGrantCriteria.getUserKey());
            stmt.setString(2, accessGrantCriteria.getClientId());
            stmt.setString(3, accessGrantCriteria.getGrantType());
            stmt.setString(4, accessGrantCriteria.getContextQualifier());
            ResultSet resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                accessGrant = this.accessGrantFromResultSet(resultSet);
                if (accessGrant.isExpired() || !accessGrantCriteria.getScope().isEqualOrLesserThan(accessGrant.getScope())) continue;
                AuthorizationDetails authorizationDetails = this.getAuthorizationDetails(accessGrant.getClientId(), accessGrant.getGuid());
                AuthorizationDetailContext context = new AuthorizationDetailContext(null, accessGrant.getClientId(), accessGrant.getScope());
                if (!AuthorizationDetailProcessorAccessor.isEqualOrSubset((AuthorizationDetails)accessGrantCriteria.getAuthorizationDetails(), (AuthorizationDetails)authorizationDetails, (AuthorizationDetailContext)context)) continue;
                accessGrant.setAuthorizationDetails(authorizationDetails);
                AccessGrant accessGrant2 = accessGrant;
                return accessGrant2;
            }
        }
        catch (SQLException | NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to retrieve an access grant from the %s table", TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return null;
    }

    @Override
    public AccessGrant getByUserKeyScopeClientIdGrantTypeContext(String userKey, Scope scope, String clientId, String grantType, String contextQualifier) {
        return this.getByAccessGrantCriteria(new AccessGrantCriteria(userKey, scope, clientId, grantType, contextQualifier, null));
    }

    private List<AccessGrant> getPersistentGrantsForLimitCheck(String userKey, String clientId, String grantType, String contextQualifier) {
        JDBCHelper jdbcHelper = null;
        LinkedList<AccessGrant> matchingGrants = new LinkedList<AccessGrant>();
        try {
            jdbcHelper = this.getJDBCHelper();
            String selectStmtForField = String.format(selectByUserKeyClientIdGrantTypeContextStmtSorted, TABLENAME);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(selectStmtForField);
            stmt.setString(1, userKey);
            stmt.setString(2, clientId);
            stmt.setString(3, grantType);
            stmt.setString(4, contextQualifier);
            ResultSet resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                AccessGrant accessGrant = this.accessGrantFromResultSet(resultSet);
                matchingGrants.add(accessGrant);
            }
        }
        catch (SQLException | NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to retrieve access grants from the %s table", TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return matchingGrants;
    }

    private Collection<AccessGrant> getCollectionByField(String fieldName, String fieldValue) {
        ArrayList<AccessGrant> accessGrants = new ArrayList<AccessGrant>();
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            String selectStmtForField = String.format(selectStmt, TABLENAME, fieldName);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(selectStmtForField);
            stmt.setString(1, fieldValue);
            ResultSet resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                AccessGrant accessGrant = this.accessGrantFromResultSet(resultSet);
                if (!accessGrant.isExpired()) {
                    accessGrant.setAuthorizationDetails(this.getAuthorizationDetails(accessGrant.getClientId(), accessGrant.getGuid()));
                    accessGrants.add(accessGrant);
                    continue;
                }
                this.deleteGrant(accessGrant.getGuid());
            }
        }
        catch (SQLException | NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to retrieve access grants from the %s table", TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return accessGrants;
    }

    public boolean isDataSourceInUse(String datasourceId) {
        return datasourceId != null && datasourceId.equals(this.getJndiName());
    }

    public void deleteExpiredGrants() {
        log.debug((Object)String.format("Cleaning expired grants, batch size = %d", this.getExpiredGrantBatchSize()));
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = this.getJDBCHelper();
            long startTime = System.currentTimeMillis();
            String deleteExpiredGrants = this.deleteExpiredGrantsStmt;
            if (jdbcHelper.isSqlServer()) {
                deleteExpiredGrants = this.getDeleteExpiredGrantsStmtSqlServer();
            } else if (jdbcHelper.isOracle()) {
                deleteExpiredGrants = this.getDeleteExpiredGrantsStmtOracle();
            } else if (jdbcHelper.isMySql()) {
                deleteExpiredGrants = this.getDeleteExpiredGrantsStmtMysql();
            } else if (jdbcHelper.isPostgres()) {
                deleteExpiredGrants = this.getDeleteExpiredGrantsStmtPostgres();
            }
            PreparedStatement deleteStmt = jdbcHelper.getPreparedStatement(deleteExpiredGrants);
            Timestamp cutoff = this.getExpiredCutoff();
            deleteStmt.setTimestamp(1, cutoff);
            int totalGrantsDeleted = 0;
            boolean done = false;
            while (!done) {
                int grantsDeleted = deleteStmt.executeUpdate();
                totalGrantsDeleted += grantsDeleted;
                log.trace((Object)String.format("Cleaned %d grants.", grantsDeleted));
                done = grantsDeleted == 0;
            }
            long endTime = System.currentTimeMillis();
            log.debug((Object)String.format("Cleaned %d grants in %d milliseconds", totalGrantsDeleted, endTime - startTime));
        }
        catch (SQLException | NamingException e) {
            log.debug((Object)String.format("Exception caught while attempting to delete expired grants from the %s table", TABLENAME), (Throwable)e);
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    private Timestamp getExpiredCutoff() {
        return new Timestamp(new Date().getTime() - 10000L);
    }

    protected JDBCHelper getJDBCHelper() throws NamingException, SQLException {
        return new JDBCHelper(this.getJndiName(), this);
    }

    private void setAuditLogParams() {
        AsAuditLogger.setDescription("Database Exception");
        AsAuditLogger.log("Database Exception");
    }

    @Override
    protected Collection<AccessGrantAttribute> retrieveGrantAttributes(String accessGrantGuid) throws AccessGrantManagementException {
        ArrayList<AccessGrantAttribute> accessGrantAttributes = new ArrayList<AccessGrantAttribute>();
        String jsonAttributeNames = "";
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            PreparedStatement preparedStatement = jdbcHelper.getPreparedStatement(this.getAttrSelectPreparedStmt(0, 1));
            preparedStatement.setString(1, accessGrantGuid);
            preparedStatement.setInt(2, 0);
            preparedStatement.setInt(3, 1);
            ResultSet resultSet = jdbcHelper.getResultSet();
            TreeMap<String, AccessGrantAttributeChunkDetails> accessGrantAttributeChunksMap = new TreeMap<String, AccessGrantAttributeChunkDetails>();
            while (resultSet.next()) {
                String name = resultSet.getString(ATTR_FIELDNAME_NAME);
                if (name.contains(this.getChunkedAttributeKey())) {
                    String[] parts = name.split("\\.");
                    int index = Integer.parseInt(parts[parts.length - 1]);
                    String attrName = this.getActualChunkedAttrName(name);
                    String attrValueChunk = resultSet.getString(ATTR_FIELDNAME_VALUE);
                    AccessGrantAttributeChunkDetails chunkList = (AccessGrantAttributeChunkDetails)accessGrantAttributeChunksMap.get(attrName);
                    if (chunkList == null) {
                        chunkList = new AccessGrantAttributeChunkDetails(resultSet.getString(ATTR_FIELDNAME_GRANT_GUID), resultSet.getInt(ATTR_FIELDNAME_SOURCE_TYPE), attrName, resultSet.getBoolean(ATTR_FIELDNAME_MASKED), resultSet.getBoolean(ATTR_FIELDNAME_ENCRYPTED), attrValueChunk, index);
                    } else {
                        chunkList.addChunk(index, attrValueChunk);
                    }
                    accessGrantAttributeChunksMap.put(attrName, chunkList);
                    continue;
                }
                String attrValue = resultSet.getString(ATTR_FIELDNAME_VALUE);
                if (resultSet.getBoolean(ATTR_FIELDNAME_ENCRYPTED)) {
                    attrValue = Obfuscator.deobfuscate(attrValue);
                }
                if (resultSet.getString(ATTR_FIELDNAME_NAME).equals(this.getJsonAttributesAttributeName())) {
                    jsonAttributeNames = attrValue;
                    continue;
                }
                if (name.contains(this.getMultiValuedAttributeKey())) {
                    name = this.getActualMultiValuedAttrName(name);
                }
                AccessGrantAttribute accessGrantAttribute = new AccessGrantAttribute(resultSet.getString(ATTR_FIELDNAME_GRANT_GUID), resultSet.getInt(ATTR_FIELDNAME_SOURCE_TYPE), name, attrValue, resultSet.getBoolean(ATTR_FIELDNAME_MASKED));
                accessGrantAttributes.add(accessGrantAttribute);
            }
            accessGrantAttributes.addAll(this.buildChunkedAttributes(accessGrantAttributeChunksMap));
        }
        catch (SQLException | NamingException e) {
            log.error((Object)("Error retrieving access grant attributes, ensure the pingfederate_access_grant_attr table has been created: " + e));
        }
        this.setJsonFlagOnJsonAttributes(jsonAttributeNames, accessGrantAttributes);
        return accessGrantAttributes;
    }

    private Collection<AccessGrantAttribute> buildChunkedAttributes(Map<String, AccessGrantAttributeChunkDetails> accessGrantAttributeChunksMap) {
        ArrayList<AccessGrantAttribute> accessGrantAttributes = new ArrayList<AccessGrantAttribute>();
        for (Map.Entry<String, AccessGrantAttributeChunkDetails> grantMap : accessGrantAttributeChunksMap.entrySet()) {
            String attrName;
            AccessGrantAttributeChunkDetails chunkDetails = grantMap.getValue();
            String attributeValue = chunkDetails.buildAttribute();
            if (chunkDetails.isEncrypted()) {
                attributeValue = Obfuscator.deobfuscate(attributeValue);
            }
            if ((attrName = chunkDetails.getName()).contains(this.getMultiValuedAttributeKey())) {
                attrName = this.getActualMultiValuedAttrName(attrName);
            }
            AccessGrantAttribute accessGrantAttribute = new AccessGrantAttribute(chunkDetails.getGrantGuid(), chunkDetails.getSourceType(), attrName, attributeValue, chunkDetails.isMasked());
            accessGrantAttributes.add(accessGrantAttribute);
        }
        return accessGrantAttributes;
    }

    private void setJsonFlagOnJsonAttributes(String jsonAttributesNames, Collection<AccessGrantAttribute> accessGrantAttributes) {
        try {
            if (StringUtils.isNotBlank((String)jsonAttributesNames)) {
                List namesList = JsonUtils.getInstance().readToList(jsonAttributesNames);
                for (AccessGrantAttribute attribute : accessGrantAttributes) {
                    if (!namesList.contains(attribute.getName())) continue;
                    attribute.setJsonAttribute(true);
                }
            }
        }
        catch (JsonProcessingException e) {
            log.error((Object)"Error parsing JSON Attribute names.", (Throwable)e);
        }
    }

    private String getActualMultiValuedAttrName(String attrName) {
        return attrName.substring(0, attrName.lastIndexOf(this.getMultiValuedAttributeKey()));
    }

    private String getActualChunkedAttrName(String attrName) {
        return attrName.substring(0, attrName.lastIndexOf(this.getChunkedAttributeKey()));
    }

    private String getAttrSelectPreparedStmt(int ... sourceTypes) throws SQLException {
        StringBuilder stmtBuilder = new StringBuilder(attrSelectStmt);
        if (sourceTypes.length != 0) {
            stmtBuilder.append(" AND (");
            for (int i = 0; i < sourceTypes.length; ++i) {
                stmtBuilder.append("source_type=?");
                if (i == sourceTypes.length - 1) continue;
                stmtBuilder.append(" OR ");
            }
            stmtBuilder.append(")");
        }
        return stmtBuilder.toString();
    }

    private String getJndiName() {
        return this.configStore.getStringValue("PingFederateDSJNDIName", "PFDefaultDS");
    }

    private boolean getEncryptAttributes() {
        return this.configStore.getBooleanValue("EncryptUserAttributes", true);
    }

    private int getMaxGrantAllowed() {
        return this.configStore.getIntValue("maxPersistentGrants", -1);
    }

    private int getMaxGrantsToDelete() {
        return this.configStore.getIntValue("maxPersistentGrantsToRemoveBatchSize", -1);
    }

    private boolean enableParentGrantEntryLock() {
        return this.configStore.getBooleanValue("enableParentGrantEntryLock", true);
    }

    private int getExpiredGrantBatchSize() {
        return this.configStore.getIntValue("ExpiredGrantBatchSize", 500);
    }

    private String getDeleteExpiredGrantsStmtMysql() {
        return String.format("DELETE FROM %s WHERE %s <= ? LIMIT %d", TABLENAME, FIELDNAME_EXPIRES, this.getExpiredGrantBatchSize());
    }

    private String getDeleteExpiredGrantsStmtOracle() {
        return String.format("DELETE FROM %s WHERE %s <= ? AND ROWNUM <= %d", TABLENAME, FIELDNAME_EXPIRES, this.getExpiredGrantBatchSize());
    }

    private String getDeleteExpiredGrantsStmtSqlServer() {
        return String.format("DELETE TOP (%d) FROM %s WHERE %s <= ?", this.getExpiredGrantBatchSize(), TABLENAME, FIELDNAME_EXPIRES);
    }

    private String getDeleteExpiredGrantsStmtPostgres() {
        return String.format("DELETE FROM %s WHERE %s IN (SELECT %s FROM %s WHERE %s <= ? LIMIT %s)", TABLENAME, FIELDNAME_GUID, FIELDNAME_GUID, TABLENAME, FIELDNAME_EXPIRES, this.getExpiredGrantBatchSize());
    }

    private String getJsonAttributesAttributeName() {
        return this.configStore.getStringValue("JsonAttributesListAttrName", "jsonAttributes");
    }

    private String getMultiValuedAttributeKey() {
        return this.configStore.getStringValue("MultiValuedAttributeKey", "_pf_multivalued");
    }

    private String getChunkedAttributeKey() {
        return this.configStore.getStringValue("ChunkedAttributeKey", "_pf_chunked");
    }

    static {
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        dsMgr.getJdbcDataSources();
    }

    private static class AccessGrantAttributeChunkDetails {
        private final String grantGuid;
        private final int sourceType;
        private final String name;
        private final boolean masked;
        private final boolean encrypted;
        private Map<Integer, String> chunks;

        AccessGrantAttributeChunkDetails(String grantGuid, int sourceType, String name, boolean masked, boolean encrypted, String chunk, int index) {
            this.grantGuid = grantGuid;
            this.sourceType = sourceType;
            this.name = name;
            this.masked = masked;
            this.encrypted = encrypted;
            this.chunks = new TreeMap<Integer, String>();
            this.chunks.put(index, chunk);
        }

        public void addChunk(int index, String chunk) {
            this.chunks.put(index, chunk);
        }

        public String buildAttribute() {
            StringBuilder attribute = new StringBuilder();
            if (this.chunks != null) {
                for (Map.Entry<Integer, String> entry : this.chunks.entrySet()) {
                    if (entry.getValue() == null) continue;
                    attribute.append(entry.getValue());
                }
            }
            return attribute.toString();
        }

        public String getName() {
            return this.name;
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public String getGrantGuid() {
            return this.grantGuid;
        }

        public int getSourceType() {
            return this.sourceType;
        }

        public boolean isMasked() {
            return this.masked;
        }
    }
}

