/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.access.AuthorizationDetailProcessorAccessor;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantCriteria;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailContext;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import com.sun.jndi.ldap.LdapName;
import com.unboundid.ldap.sdk.Filter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.token.AccessGrantAttribute;
import org.sourceid.oauth20.token.BaseAccessGrantManager;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class AccessGrantManagerLDAPADImpl
extends BaseAccessGrantManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final String OBJECTCLASS = "objectClass";
    protected final ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    protected String jndiName;
    protected String searchBase;
    protected String accessGrantObjectClassName;
    protected int expiredGrantBatchSize = -1;
    protected int maxGrantAllowed;
    protected int maxGrantsToDelete;
    protected String FIELDNAME_GUID;
    protected String FIELDNAME_HASHED_REFRESH_TOKEN;
    protected String FIELDNAME_UNIQUE_USER_ID;
    protected String FIELDNAME_SCOPE;
    protected String FIELDNAME_CLIENT_ID;
    protected String FIELDNAME_GRANT_TYPE;
    protected String FIELDNAME_CONTEXT_QUALIFIER;
    protected String FIELDNAME_ISSUED;
    protected String FIELDNAME_UPDATED;
    protected String FIELDNAME_EXPIRES;
    protected String FIELDNAME_ATTRIBUTES;

    public AccessGrantManagerLDAPADImpl() {
        this.loadConfig();
    }

    private void loadConfig() {
        this.jndiName = this.configStore.getStringValue("PingFederateDSJNDIName", null);
        this.searchBase = this.configStore.getStringValue("SearchBase", "");
        this.accessGrantObjectClassName = this.configStore.getStringValue("AccessGrantObjectClassName", null);
        this.expiredGrantBatchSize = this.configStore.getIntValue("ExpiredGrantBatchSize", 500);
        this.maxGrantAllowed = this.configStore.getIntValue("maxPersistentGrants", -1);
        this.maxGrantsToDelete = this.configStore.getIntValue("maxPersistentGrantsToRemoveBatchSize", -1);
        this.FIELDNAME_GUID = this.configStore.getStringValue("Guid", "accessGrantGuid");
        this.FIELDNAME_HASHED_REFRESH_TOKEN = this.configStore.getStringValue("HashedRefreshTokenValue", "accessGrantHashedRefreshTokenValue");
        this.FIELDNAME_UNIQUE_USER_ID = this.configStore.getStringValue("UniqueUserIdentifier", "accessGrantUniqueUserIdentifier");
        this.FIELDNAME_SCOPE = this.configStore.getStringValue("Scope", "accessGrantScope");
        this.FIELDNAME_CLIENT_ID = this.configStore.getStringValue("ClientId", "accessGrantClientId");
        this.FIELDNAME_GRANT_TYPE = this.configStore.getStringValue("GrantType", "accessGrantGrantType");
        this.FIELDNAME_CONTEXT_QUALIFIER = this.configStore.getStringValue("ContextualQualifier", "accessGrantContextualQualifier");
        this.FIELDNAME_ISSUED = this.configStore.getStringValue("Issued", "accessGrantIssued");
        this.FIELDNAME_UPDATED = this.configStore.getStringValue("Updated", "accessGrantUpdated");
        this.FIELDNAME_EXPIRES = this.configStore.getStringValue("Expires", "accessGrantExpires");
        this.FIELDNAME_ATTRIBUTES = this.configStore.getStringValue("Attributes", "accessGrantAttributes");
        try {
            this.checkConfiguration();
        }
        catch (AccessGrantManagementException e) {
            this.setAuditLogParams();
            this.log.error((Object)e.getMessage());
        }
    }

    public boolean isDataSourceInUse(String datasourceId) {
        return datasourceId != null && datasourceId.equals(this.jndiName);
    }

    protected void checkConfiguration() throws AccessGrantManagementException {
        this.validateDatastoreConfiguration();
        if (StringUtils.isEmpty((String)this.FIELDNAME_GUID)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_GUID);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_HASHED_REFRESH_TOKEN)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_HASHED_REFRESH_TOKEN);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_UNIQUE_USER_ID)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_UNIQUE_USER_ID);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_SCOPE)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_SCOPE);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_CLIENT_ID)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_CLIENT_ID);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_GRANT_TYPE)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_GRANT_TYPE);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_CONTEXT_QUALIFIER)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_CONTEXT_QUALIFIER);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_UPDATED)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_UPDATED);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_ISSUED)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_ISSUED);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_EXPIRES)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_EXPIRES);
        }
        if (StringUtils.isEmpty((String)this.FIELDNAME_ATTRIBUTES)) {
            throw new AccessGrantManagementException("An LDAP attribute name was not found: " + this.FIELDNAME_ATTRIBUTES);
        }
    }

    protected final void validateDatastoreConfiguration() {
        if (StringUtils.isEmpty((String)this.jndiName)) {
            throw new AccessGrantManagementException("The Access Grant Management data store is not defined.");
        }
        if (StringUtils.isEmpty((String)this.accessGrantObjectClassName)) {
            throw new AccessGrantManagementException("The Access Grant Management object class name is not defined.");
        }
        if (MgmtFactory.getDataSourceManager().getLdapDataSource(this.jndiName) == null) {
            throw new AccessGrantManagementException("The defined LDAP data source was not found: " + this.jndiName);
        }
    }

    public LdapDataSource getLdapDataSource() {
        this.validateDatastoreConfiguration();
        LdapDataSource ldapDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(this.jndiName);
        if (ldapDataSource.isGatewayEnabled()) {
            this.log.warn((Object)"LDAP Data Source is a PingOne Gateway enabled data source which is an UNSUPPORTED configuration.");
        }
        return ldapDataSource;
    }

    @Override
    public void deleteGrant(String accessGrantGuid) {
        try {
            this.checkConfiguration();
            LdapName ldapName = new LdapName("CN=" + accessGrantGuid + "," + this.searchBase);
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).deleteAccessGrant(ldapName);
        }
        catch (NamingException e) {
            this.log.error((Object)("Unable to delete grant due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    @Override
    protected void saveGrant(AccessGrant accessGrant, Collection<AccessGrantAttribute> attributes) {
        this.checkConfiguration();
        try {
            LdapName ldapName = new LdapName("CN=" + accessGrant.getGuid() + "," + this.searchBase);
            BasicAttributes attrsToLdap = new BasicAttributes();
            attrsToLdap.put("objectclass", "top");
            attrsToLdap.put("objectclass", this.accessGrantObjectClassName);
            attrsToLdap.put(this.FIELDNAME_GUID, accessGrant.getGuid());
            if (!StringUtils.isBlank((String)accessGrant.getUniqueUserIdentifer())) {
                attrsToLdap.put(this.FIELDNAME_UNIQUE_USER_ID, accessGrant.getUniqueUserIdentifer());
            }
            if (!StringUtils.isBlank((String)accessGrant.getHashedRefreshTokenValue())) {
                attrsToLdap.put(this.FIELDNAME_HASHED_REFRESH_TOKEN, accessGrant.getHashedRefreshTokenValue());
            }
            if (!StringUtils.isBlank((String)accessGrant.getScope().getScopeStr())) {
                attrsToLdap.put(this.FIELDNAME_SCOPE, accessGrant.getScope().getScopeStr());
            }
            if (!StringUtils.isBlank((String)accessGrant.getClientId())) {
                attrsToLdap.put(this.FIELDNAME_CLIENT_ID, accessGrant.getClientId());
            }
            if (!StringUtils.isBlank((String)accessGrant.getGrantType())) {
                attrsToLdap.put(this.FIELDNAME_GRANT_TYPE, accessGrant.getGrantType());
            }
            if (!StringUtils.isBlank((String)accessGrant.getContextualQualifier())) {
                attrsToLdap.put(this.FIELDNAME_CONTEXT_QUALIFIER, accessGrant.getContextualQualifier());
            }
            attrsToLdap.put(this.FIELDNAME_ISSUED, Long.toString(accessGrant.getIssued()));
            attrsToLdap.put(this.FIELDNAME_UPDATED, Long.toString(accessGrant.getUpdated()));
            if (accessGrant.getExpires() != null) {
                attrsToLdap.put(this.FIELDNAME_EXPIRES, accessGrant.getExpires().toString());
            }
            if (accessGrant.getAuthorizationDetails() != null && accessGrant.getAuthorizationDetails().getDetails() != null && !accessGrant.getAuthorizationDetails().getDetails().isEmpty()) {
                AccessGrantAttribute attribute = new AccessGrantAttribute(accessGrant.getGuid(), 2, "authorization_details_", accessGrant.getAuthorizationDetails().toJson(), false);
                attributes.add(attribute);
            }
            this.saveGrantAttributes(attrsToLdap, attributes);
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).addAccessGrant(ldapName, attrsToLdap);
        }
        catch (JsonProcessingException | NamingException e) {
            this.log.error((Object)("Unable to save grant due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException(e);
        }
        this.checkPersistentGrantLimit(accessGrant, this.maxGrantAllowed, this.maxGrantsToDelete);
    }

    protected void checkPersistentGrantLimit(AccessGrant accessGrant, int maxGrantAllowed, int maxGrantsToDelete) {
        List<AccessGrant> grants;
        if (maxGrantAllowed > 0 && (grants = this.getPersistentGrantsForLimitCheck(accessGrant.getUniqueUserIdentifer(), accessGrant.getClientId(), accessGrant.getGrantType(), accessGrant.getContextualQualifier())).size() > maxGrantAllowed) {
            int exceedByAmt = grants.size() - maxGrantAllowed;
            int numGrantsToDelete = maxGrantsToDelete > 0 && exceedByAmt > maxGrantsToDelete ? maxGrantsToDelete : exceedByAmt;
            int numDeletedGrants = 0;
            Iterator<AccessGrant> grantsIter = grants.iterator();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Removing grants using parameters \nuserKey: " + accessGrant.getUniqueUserIdentifer() + "\nclientId: " + accessGrant.getClientId() + "\ngrantType: " + accessGrant.getGrantType() + "\ncontextQualifier: " + accessGrant.getContextualQualifier()));
            }
            while (grantsIter.hasNext() && numDeletedGrants < numGrantsToDelete) {
                AccessGrant grantToDelete = grantsIter.next();
                try {
                    this.deleteGrant(grantToDelete.getGuid());
                    ++numDeletedGrants;
                }
                catch (AccessGrantManagementException agme) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)"Exception thrown while deleting a grant during persistent grant limit cleanup. It is possible multiple deletes are occurring for the same grant.");
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Removed " + numDeletedGrants + " grant(s)."));
            }
        }
    }

    protected void setAuditLogParams() {
        AsAuditLogger.setDescription("Access Grant Management Exception");
        AsAuditLogger.log("Access Grant Management Exception");
    }

    protected void saveGrantAttributes(Attributes attrsToLdap, Collection<AccessGrantAttribute> attributes) throws JsonProcessingException {
        if (!Util.isEmpty(attributes)) {
            ObjectMapper mapper = new ObjectMapper();
            String jsonInString = mapper.writeValueAsString(attributes);
            attrsToLdap.put(this.FIELDNAME_ATTRIBUTES, Obfuscator.obfuscate(jsonInString));
        }
    }

    @Override
    protected AccessGrant getByGuidInternal(String accessGrantGuid) {
        return this.getByField(this.FIELDNAME_GUID, accessGrantGuid);
    }

    @Override
    public Collection<AccessGrant> getByUserKey(String userKey) {
        return this.getCollectionByField(this.FIELDNAME_UNIQUE_USER_ID, userKey);
    }

    @Override
    public AccessGrant doGetByRefreshToken(String refreshTokenValue) {
        return this.getByField(this.FIELDNAME_HASHED_REFRESH_TOKEN, TokenUtil.digestToken(refreshTokenValue));
    }

    public Collection<AccessGrant> getByClientId(String clientId) throws AccessGrantManagementException {
        return this.getCollectionByField(this.FIELDNAME_CLIENT_ID, clientId);
    }

    @Override
    public AccessGrant getByUserKeyScopeClientIdGrantTypeContext(String userKey, Scope scope, String clientId, String grantType, String contextQualifier) {
        return this.getByAccessGrantCriteria(new AccessGrantCriteria(userKey, scope, clientId, grantType, contextQualifier, null));
    }

    public AccessGrant getByAccessGrantCriteria(AccessGrantCriteria accessGrantCriteria) throws AccessGrantManagementException {
        this.checkConfiguration();
        try {
            String searchCriteria = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)OBJECTCLASS, (String)this.accessGrantObjectClassName), Filter.createEqualityFilter((String)this.FIELDNAME_UNIQUE_USER_ID, (String)accessGrantCriteria.getUserKey()), Filter.createEqualityFilter((String)this.FIELDNAME_CLIENT_ID, (String)accessGrantCriteria.getClientId()), Filter.createEqualityFilter((String)this.FIELDNAME_GRANT_TYPE, (String)accessGrantCriteria.getGrantType()), Filter.createEqualityFilter((String)this.FIELDNAME_CONTEXT_QUALIFIER, (String)accessGrantCriteria.getContextQualifier())}).toString();
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.searchBase, searchCriteria, 2);
            List<AttributeMap> results = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).getAttributesOfMatchingObjects(ldapOptions);
            for (AttributeMap map : results) {
                AccessGrant accessGrant = this.getAccessGrantFromResults(map);
                if (accessGrant.isExpired() || !accessGrantCriteria.getScope().isEqualOrLesserThan(accessGrant.getScope())) continue;
                if (accessGrantCriteria.getAuthorizationDetails() != null && accessGrantCriteria.getAuthorizationDetails().getDetails() != null) {
                    AuthorizationDetails authorizationDetails = this.retrieveAuthorizationDetails(accessGrant.getGuid(), accessGrant.getClientId());
                    AuthorizationDetailContext context = new AuthorizationDetailContext(null, accessGrant.getClientId(), accessGrant.getScope());
                    if (!AuthorizationDetailProcessorAccessor.isEqualOrSubset((AuthorizationDetails)accessGrantCriteria.getAuthorizationDetails(), (AuthorizationDetails)authorizationDetails, (AuthorizationDetailContext)context)) continue;
                    accessGrant.setAuthorizationDetails(authorizationDetails);
                    return accessGrant;
                }
                return accessGrant;
            }
            return null;
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage());
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    private AuthorizationDetails getAuthorizationDetailsFromAttribute(Collection<AccessGrantAttribute> authorizationDetailsAttribute) throws AccessGrantManagementException {
        Iterator<AccessGrantAttribute> iterator = authorizationDetailsAttribute.iterator();
        if (iterator.hasNext()) {
            AccessGrantAttribute details = iterator.next();
            try {
                return new AuthorizationDetails(details.getValue());
            }
            catch (IOException e) {
                throw new AccessGrantManagementException("Error deserializing stored authorization details.", (Throwable)e);
            }
        }
        return null;
    }

    private List<AccessGrant> getPersistentGrantsForLimitCheck(String userKey, String clientId, String grantType, String contextQualifier) {
        this.checkConfiguration();
        try {
            String searchCriteria = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)OBJECTCLASS, (String)this.accessGrantObjectClassName), Filter.createEqualityFilter((String)this.FIELDNAME_UNIQUE_USER_ID, (String)userKey), Filter.createEqualityFilter((String)this.FIELDNAME_CLIENT_ID, (String)clientId), Filter.createEqualityFilter((String)this.FIELDNAME_GRANT_TYPE, (String)grantType), Filter.createEqualityFilter((String)this.FIELDNAME_CONTEXT_QUALIFIER, (String)contextQualifier)}).toString();
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.searchBase, searchCriteria, 2);
            ldapOptions.setSortBy(Collections.singletonList(this.FIELDNAME_UPDATED));
            List<AttributeMap> results = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).getAttributesOfMatchingObjects(ldapOptions);
            return Optional.ofNullable(results).orElse(Collections.emptyList()).parallelStream().map(this::getAccessGrantFromResults).collect(Collectors.toList());
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage());
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    private Collection<AccessGrant> getCollectionByField(String fieldName, String fieldValue) {
        this.checkConfiguration();
        try {
            String searchCriteria = "(&(objectClass=" + Filter.encodeValue((String)this.accessGrantObjectClassName) + ")(" + Filter.encodeValue((String)fieldName) + "=" + Filter.encodeValue((String)fieldValue) + "))";
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.searchBase, searchCriteria, 2);
            List<AttributeMap> results = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).getAttributesOfMatchingObjects(ldapOptions);
            ArrayList<AccessGrant> accessGrants = new ArrayList<AccessGrant>();
            for (AttributeMap map : results) {
                AccessGrant accessGrant = this.getAccessGrantFromResults(map);
                if (!accessGrant.isExpired()) {
                    accessGrants.add(accessGrant);
                    continue;
                }
                this.deleteGrant(accessGrant.getGuid());
            }
            return accessGrants;
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage());
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    private AccessGrant getByField(String fieldName, String fieldValue) {
        if (fieldName == null || fieldValue == null) {
            return null;
        }
        AccessGrant accessGrant = null;
        this.checkConfiguration();
        try {
            String searchCriteria = "(&(objectClass=" + Filter.encodeValue((String)this.accessGrantObjectClassName) + ")(" + Filter.encodeValue((String)fieldName) + "=" + Filter.encodeValue((String)fieldValue) + "))";
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.searchBase, searchCriteria, 2);
            ldapOptions.setCount(1);
            List<AttributeMap> results = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).getAttributesOfMatchingObjects(ldapOptions);
            if (!results.isEmpty()) {
                accessGrant = this.getAccessGrantFromResults(results.get(0));
                accessGrant.setAuthorizationDetails(this.retrieveAuthorizationDetails(accessGrant.getGuid(), accessGrant.getClientId()));
            }
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage());
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        if (accessGrant != null && accessGrant.isExpired()) {
            this.deleteGrant(accessGrant.getGuid());
            accessGrant = null;
        }
        return accessGrant;
    }

    private List<AttributeMap> getByFieldRaw(String fieldName, String fieldValue) {
        this.checkConfiguration();
        try {
            String searchCriteria = "(&(objectClass=" + Filter.encodeValue((String)this.accessGrantObjectClassName) + ")(" + Filter.encodeValue((String)fieldName) + "=" + Filter.encodeValue((String)fieldValue) + "))";
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.searchBase, searchCriteria, 2);
            ldapOptions.setCount(1);
            return LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).getAttributesOfMatchingObjects(ldapOptions);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage());
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    private AccessGrant getAccessGrantFromResults(AttributeMap results) {
        long issued = results.getSingleValue(this.FIELDNAME_ISSUED) != null ? Long.parseLong(results.getSingleValue(this.FIELDNAME_ISSUED)) : 0L;
        long updated = results.getSingleValue(this.FIELDNAME_UPDATED) != null ? Long.parseLong(results.getSingleValue(this.FIELDNAME_UPDATED)) : 0L;
        Long expires = results.getSingleValue(this.FIELDNAME_EXPIRES) != null ? Long.valueOf(results.getSingleValue(this.FIELDNAME_EXPIRES)) : null;
        AccessGrant accessGrant = new AccessGrant(results.getSingleValue(this.FIELDNAME_HASHED_REFRESH_TOKEN), results.getSingleValue(this.FIELDNAME_GUID), results.getSingleValue(this.FIELDNAME_UNIQUE_USER_ID), results.getSingleValue(this.FIELDNAME_GRANT_TYPE), Scope.getScope((String)results.getSingleValue(this.FIELDNAME_SCOPE)), results.getSingleValue(this.FIELDNAME_CLIENT_ID), issued, updated, expires, results.getSingleValue(this.FIELDNAME_CONTEXT_QUALIFIER));
        this.updateContextualQualifier(accessGrant);
        return accessGrant;
    }

    @Override
    protected Collection<AccessGrantAttribute> retrieveGrantAttributes(String accessGrantGuid) throws AccessGrantManagementException {
        return this.retrieveAttributesBySourceType(accessGrantGuid, Arrays.asList(0, 1));
    }

    private AuthorizationDetails retrieveAuthorizationDetails(String accessGrantGuid, String clientId) {
        Client client = MgmtFactory.getClientManager().getCachedClient(clientId);
        if (client == null || client.getAuthorizationDetailTypes() == null || client.getAuthorizationDetailTypes().isEmpty()) {
            return null;
        }
        Collection<AccessGrantAttribute> authorizationDetailsAttribute = this.retrieveAttributesBySourceType(accessGrantGuid, Collections.singletonList(2));
        if (!authorizationDetailsAttribute.isEmpty()) {
            return this.getAuthorizationDetailsFromAttribute(authorizationDetailsAttribute);
        }
        return null;
    }

    protected Collection<AccessGrantAttribute> retrieveAttributesBySourceType(String accessGrantGuid, List<Integer> sourceTypes) throws AccessGrantManagementException {
        String attributesStr;
        this.checkConfiguration();
        List<AttributeMap> grants = this.getByFieldRaw(this.FIELDNAME_GUID, accessGrantGuid);
        Collection<Object> attributes = Collections.emptyList();
        if (!grants.isEmpty() && (attributesStr = grants.get(0).getSingleValue(this.FIELDNAME_ATTRIBUTES)) != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                attributesStr = Obfuscator.deobfuscate(attributesStr);
                attributes = (Collection)mapper.readValue(attributesStr, (JavaType)mapper.getTypeFactory().constructCollectionType(Collection.class, AccessGrantAttribute.class));
            }
            catch (IOException e) {
                this.log.error((Object)("Unable to retrieve grant attributes due to : " + e.getMessage()));
                this.setAuditLogParams();
                throw new AccessGrantManagementException((Throwable)e);
            }
        }
        if (sourceTypes == null || sourceTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return attributes.stream().filter(attribute -> sourceTypes.contains(attribute.getSourceType())).collect(Collectors.toList());
    }

    public void deleteExpiredGrants() {
        this.log.debug((Object)("Cleaning expired grants, batch size = " + this.expiredGrantBatchSize));
        this.checkConfiguration();
        try {
            int totalGrantsDeleted = 0;
            long startTime = System.currentTimeMillis();
            long cutoff = System.currentTimeMillis() - 10000L;
            String searchCriteria = "(&(objectClass=" + Filter.encodeValue((String)this.accessGrantObjectClassName) + ")(" + Filter.encodeValue((String)this.FIELDNAME_EXPIRES) + "<=" + cutoff + "))";
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.searchBase, searchCriteria, 2);
            ldapOptions.setResultsPerPage(this.expiredGrantBatchSize);
            boolean done = false;
            while (!done) {
                List<AttributeMap> results = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).getAttributesOfMatchingObjects(ldapOptions);
                if (results.isEmpty()) {
                    done = true;
                    continue;
                }
                for (AttributeMap result : results) {
                    this.deleteGrant(result.getSingleValue(this.FIELDNAME_GUID));
                    ++totalGrantsDeleted;
                }
            }
            long endTime = System.currentTimeMillis();
            this.log.debug((Object)("Cleaned " + totalGrantsDeleted + " grants in " + (endTime - startTime) + " milliseconds"));
        }
        catch (NamingException e) {
            this.log.error((Object)("Unable to delete grants due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    @Override
    public void updateRefreshToken(AccessGrant accessGrant) {
        this.checkConfiguration();
        try {
            LdapName ldapName = new LdapName("CN=" + accessGrant.getGuid() + "," + this.searchBase);
            BasicAttributes attributes = new BasicAttributes();
            attributes.put(this.FIELDNAME_HASHED_REFRESH_TOKEN, accessGrant.getHashedRefreshTokenValue());
            attributes.put(this.FIELDNAME_UPDATED, Long.toString(System.currentTimeMillis()));
            if (accessGrant.getExpires() != null) {
                attributes.put(this.FIELDNAME_EXPIRES, Long.toString(accessGrant.getExpires()));
            }
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).modifyItem(ldapName, attributes, 2);
            this.log.debug((Object)"The LDAP datastore was modified successfully.");
        }
        catch (NamingException e) {
            this.log.error((Object)("Unable to update grant due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    @Override
    public void updateExpiry(AccessGrant accessGrant) throws AccessGrantManagementException {
        this.checkConfiguration();
        try {
            LdapName ldapName = new LdapName("CN=" + accessGrant.getGuid() + "," + this.searchBase);
            BasicAttributes attributes = new BasicAttributes();
            if (accessGrant.getExpires() != null) {
                attributes.put(this.FIELDNAME_EXPIRES, accessGrant.getExpires().toString());
            } else {
                attributes.put(new BasicAttribute(this.FIELDNAME_EXPIRES));
            }
            attributes.put(this.FIELDNAME_UPDATED, Long.toString(System.currentTimeMillis()));
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).modifyItem(ldapName, attributes, 2);
            this.log.debug((Object)"The LDAP datastore was modified successfully.");
        }
        catch (NamingException e) {
            this.log.error((Object)("Unable to update grant due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    public Collection<AccessGrant> getByUserKeyClientIdGrantType(String userKey, String clientId, String grantType) throws AccessGrantManagementException {
        this.checkConfiguration();
        ArrayList<AccessGrant> accessGrants = new ArrayList<AccessGrant>();
        try {
            String searchCriteria = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)OBJECTCLASS, (String)this.accessGrantObjectClassName), Filter.createEqualityFilter((String)this.FIELDNAME_UNIQUE_USER_ID, (String)userKey), Filter.createEqualityFilter((String)this.FIELDNAME_CLIENT_ID, (String)clientId), Filter.createEqualityFilter((String)this.FIELDNAME_GRANT_TYPE, (String)grantType)}).toString();
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.searchBase, searchCriteria, 2);
            List<AttributeMap> results = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).getAttributesOfMatchingObjects(ldapOptions);
            for (AttributeMap map : results) {
                AccessGrant accessGrant = this.getAccessGrantFromResults(map);
                if (!accessGrant.isExpired()) {
                    accessGrant.setAuthorizationDetails(this.retrieveAuthorizationDetails(accessGrant.getGuid(), accessGrant.getClientId()));
                    accessGrants.add(accessGrant);
                    continue;
                }
                this.deleteGrant(accessGrant.getGuid());
            }
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage());
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
        return accessGrants;
    }

    @Override
    protected void updateGrantAttributes(String accessGrantGuid, Collection<AccessGrantAttribute> attributes) {
        this.checkConfiguration();
        try {
            Collection<AccessGrantAttribute> authorizationDetailsAttribute = this.retrieveAttributesBySourceType(accessGrantGuid, Collections.singletonList(2));
            if (authorizationDetailsAttribute != null) {
                attributes.addAll(authorizationDetailsAttribute);
            }
            LdapName ldapName = new LdapName("CN=" + accessGrantGuid + "," + this.searchBase);
            BasicAttributes attributesToLdap = new BasicAttributes();
            ObjectMapper mapper = new ObjectMapper();
            String jsonInString = mapper.writeValueAsString(attributes);
            attributesToLdap.put(this.FIELDNAME_ATTRIBUTES, Obfuscator.obfuscate(jsonInString));
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).modifyItem(ldapName, attributesToLdap, 2);
            this.log.debug((Object)"The LDAP datastore was modified successfully.");
        }
        catch (JsonProcessingException | NamingException e) {
            this.log.error((Object)("Unable to update grant due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException(e);
        }
    }
}

