/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.token.AccessGrantAttribute;
import org.sourceid.oauth20.token.BaseAccessGrantManager;
import org.sourceid.oauth20.token.TokenUtil;

public class AccessGrantManagerMapImpl
extends BaseAccessGrantManager {
    private final Map<String, AccessGrant> refreshByGUID = new HashMap<String, AccessGrant>();
    private final Map<String, Collection<AccessGrantAttribute>> attrsByGUID = new HashMap<String, Collection<AccessGrantAttribute>>();

    @Override
    public AccessGrant doGetByRefreshToken(String refreshTokenValue) {
        String hashedValue = TokenUtil.digestToken(refreshTokenValue);
        Iterator<AccessGrant> valuesIt = this.refreshByGUID.values().iterator();
        ArrayList<AccessGrant> expiredGrants = new ArrayList<AccessGrant>();
        while (valuesIt.hasNext()) {
            AccessGrant accessGrant = valuesIt.next();
            if (accessGrant.isExpired()) {
                expiredGrants.add(accessGrant);
            }
            if (!StringUtils.equals((String)hashedValue, (String)accessGrant.getHashedRefreshTokenValue())) continue;
            this.deleteGrants(expiredGrants);
            return accessGrant.isExpired() ? null : accessGrant;
        }
        return null;
    }

    @Override
    protected AccessGrant getByGuidInternal(String accessGrantGuid) {
        AccessGrant grant = this.refreshByGUID.get(accessGrantGuid);
        if (grant != null) {
            if (grant.isExpired()) {
                this.deleteGrant(accessGrantGuid);
                return null;
            }
            return grant;
        }
        return null;
    }

    @Override
    public void deleteGrant(String accessGrantGuid) {
        this.refreshByGUID.remove(accessGrantGuid);
        this.attrsByGUID.remove(accessGrantGuid);
    }

    @Override
    protected void saveGrant(AccessGrant accessGrant, Collection<AccessGrantAttribute> attributes) {
        accessGrant.setGuid(String.valueOf(System.currentTimeMillis()));
        this.refreshByGUID.put(accessGrant.getGuid(), accessGrant);
        this.attrsByGUID.put(accessGrant.getGuid(), attributes);
    }

    @Override
    public Collection<AccessGrant> getByUserKey(String userKey) {
        ArrayList<AccessGrant> grants = new ArrayList<AccessGrant>();
        Iterator<AccessGrant> valuesIt = this.refreshByGUID.values().iterator();
        ArrayList<AccessGrant> expiredGrants = new ArrayList<AccessGrant>();
        while (valuesIt.hasNext()) {
            AccessGrant accessGrant = valuesIt.next();
            if (accessGrant.isExpired()) {
                expiredGrants.add(accessGrant);
                continue;
            }
            if (!StringUtils.equals((String)userKey, (String)accessGrant.getUniqueUserIdentifer())) continue;
            grants.add(accessGrant);
        }
        this.deleteGrants(expiredGrants);
        return grants;
    }

    public Collection<AccessGrant> getByClientId(String clientId) {
        ArrayList<AccessGrant> grants = new ArrayList<AccessGrant>();
        Iterator<AccessGrant> valuesIt = this.refreshByGUID.values().iterator();
        ArrayList<AccessGrant> expiredGrants = new ArrayList<AccessGrant>();
        while (valuesIt.hasNext()) {
            AccessGrant accessGrant = valuesIt.next();
            if (accessGrant.isExpired()) {
                expiredGrants.add(accessGrant);
                continue;
            }
            if (!StringUtils.equals((String)clientId, (String)accessGrant.getClientId())) continue;
            grants.add(accessGrant);
        }
        this.deleteGrants(expiredGrants);
        return grants;
    }

    @Override
    public void updateRefreshToken(AccessGrant accessGrant) {
        if (this.refreshByGUID.containsKey(accessGrant.getGuid())) {
            this.refreshByGUID.put(accessGrant.getGuid(), accessGrant);
        }
    }

    @Override
    public void updateExpiry(AccessGrant accessGrant) throws AccessGrantManagementException {
        if (this.refreshByGUID.containsKey(accessGrant.getGuid())) {
            this.refreshByGUID.put(accessGrant.getGuid(), accessGrant);
        }
    }

    public Collection<AccessGrant> getByUserKeyClientIdGrantType(String userKey, String clientId, String grantType) throws AccessGrantManagementException {
        ArrayList<AccessGrant> grants = new ArrayList<AccessGrant>();
        Iterator<AccessGrant> valuesIt = this.refreshByGUID.values().iterator();
        ArrayList<AccessGrant> expiredGrants = new ArrayList<AccessGrant>();
        while (valuesIt.hasNext()) {
            AccessGrant accessGrant = valuesIt.next();
            if (accessGrant.isExpired()) {
                expiredGrants.add(accessGrant);
                continue;
            }
            if (!StringUtils.equals((String)userKey, (String)accessGrant.getUniqueUserIdentifer()) || !StringUtils.equals((String)clientId, (String)accessGrant.getClientId()) || !StringUtils.equals((String)grantType, (String)accessGrant.getGrantType())) continue;
            grants.add(accessGrant);
        }
        this.deleteGrants(expiredGrants);
        return grants;
    }

    public boolean isDataSourceInUse(String datasourceId) {
        return false;
    }

    public void deleteExpiredGrants() {
    }

    @Override
    protected void updateGrantAttributes(String accessGrantGuid, Collection<AccessGrantAttribute> attributes) {
        this.attrsByGUID.put(accessGrantGuid, attributes);
    }

    @Override
    protected Collection<AccessGrantAttribute> retrieveGrantAttributes(String accessGrantGuid) throws AccessGrantManagementException {
        Collection<AccessGrantAttribute> attrs = this.attrsByGUID.get(accessGrantGuid);
        if (attrs == null) {
            return null;
        }
        return new ArrayList<AccessGrantAttribute>(attrs);
    }

    private void deleteGrants(Collection<AccessGrant> grants) {
        for (AccessGrant grant : grants) {
            this.deleteGrant(grant.getGuid());
        }
    }
}

