/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.token.AbstractTokenResponse;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.OutMessageContext;

public class AccessTokenResponse
extends AbstractTokenResponse {
    private Object accessToken;
    private String tokenType;
    private Long expiresIn;
    private String refreshToken;
    private String scope;
    private Map<String, Object> additionalParameters;
    private String requestedTokenType = null;
    private Object authorizationDetails;

    public AccessTokenResponse(Object accessToken, String tokenType, Long expiresAt, String scope, String refreshToken) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        if (expiresAt != null) {
            long millis = expiresAt - System.currentTimeMillis();
            this.expiresIn = millis / 1000L;
        }
        this.scope = scope;
        this.refreshToken = refreshToken;
    }

    public AccessTokenResponse(Object accessToken, String tokenType, Long expiresAt, String scope, String refreshToken, AuthorizationDetails authorizationDetails) {
        this(accessToken, tokenType, expiresAt, scope, refreshToken);
        if (authorizationDetails != null && authorizationDetails.getDetails() != null && !authorizationDetails.getDetails().isEmpty()) {
            this.authorizationDetails = authorizationDetails.toJson();
        }
    }

    public AccessTokenResponse(Object accessToken, String tokenType, Long expiresAt, String scope, String refreshToken, Map<String, Object> additionalParameters, String requestedTokenType, AuthorizationDetails authorizationDetails) {
        this(accessToken, tokenType, expiresAt, scope, refreshToken);
        this.additionalParameters = additionalParameters;
        this.requestedTokenType = requestedTokenType;
        if (authorizationDetails != null && authorizationDetails.getDetails() != null && !authorizationDetails.getDetails().isEmpty()) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            SimpleJsonRespWriter.setForJsonSerialize(temp, "authorization_details", authorizationDetails.toAttributeValue(), Collections.singletonList("authorization_details"));
            this.authorizationDetails = temp.get("authorization_details");
        }
    }

    public Object getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public Object getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    @Override
    public void tokenResponseToOutContext(OutMessageContext outMsgCtx) {
        outMsgCtx.setParam("access_token", this.getAccessToken(), true);
        this.setParamWhenNotNull(outMsgCtx, "expires_in", this.getExpiresIn());
        outMsgCtx.setParam("token_type", this.getTokenType());
        this.setParamWhenNotNull(outMsgCtx, "refresh_token", this.getRefreshToken(), true);
        this.setParamWhenNotNull(outMsgCtx, Parameters.SCOPE, this.getScope());
        Map<String, Object> additionalParams = this.getAdditionalParameters();
        this.setParamWhenNotEmpty(outMsgCtx, "issued_token_type", this.requestedTokenType);
        this.setParamWhenNotNull(outMsgCtx, "authorization_details", this.authorizationDetails, true);
        if (additionalParams != null) {
            for (Map.Entry<String, Object> e : additionalParams.entrySet()) {
                outMsgCtx.setParam(e.getKey(), e.getValue(), this.isMasked(e));
            }
        }
        AsAuditLogger.setOutMsgCtx(outMsgCtx);
    }

    private boolean isMasked(Map.Entry<String, Object> e) {
        return "id_token".equals(e.getKey());
    }
}

