/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.pingidentity.session.AdminConsoleApiAccessToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.oauth20.token.AdminConsoleTokenManager;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class AdminConsoleTokenManagerImpl
implements AdminConsoleTokenManager {
    private static final Log log = LogFactory.getLog(AdminConsoleTokenManagerImpl.class);
    protected static final String ADMIN_CONSOLE_API_SERVICE_CONFIG_NAME = "admin_console_api_service";
    private ConfigStore configStore = ConfigStoreFarm.getConfig("admin_console_api_service");
    private static final String EXPIRY_TIME = "AccessTokenTimeoutMillis";
    private static final String TOKEN_LENGTH = "AccessTokenLength";
    private final LinkedHashMap<String, AdminConsoleApiAccessToken> accessTokens = new LinkedHashMap();

    @Override
    public synchronized AdminConsoleApiAccessToken createAccessToken(AdministrativeUser adminUser, HttpSession session) {
        String id = IDGenerator.rndAlphaNumeric(this.getTokenLength());
        long expiryTime = System.currentTimeMillis() + this.getExpiryTime();
        AdminConsoleApiAccessToken accessToken = new AdminConsoleApiAccessToken(id, adminUser, expiryTime, session.getId());
        ArrayList<String> expiredTokenKeys = new ArrayList<String>();
        for (AdminConsoleApiAccessToken adminConsoleApiAccessToken : this.accessTokens.values()) {
            if (!adminConsoleApiAccessToken.isExpired()) break;
            expiredTokenKeys.add(adminConsoleApiAccessToken.getId());
        }
        for (String expiredTokenKey : expiredTokenKeys) {
            this.accessTokens.remove(expiredTokenKey);
        }
        this.accessTokens.put(accessToken.getId(), accessToken);
        return accessToken;
    }

    @Override
    public synchronized AdminConsoleApiAccessToken validateAccessToken(String accessTokenId) {
        AdminConsoleApiAccessToken accessToken = this.accessTokens.get(accessTokenId);
        if (accessToken != null && !accessToken.isExpired()) {
            return accessToken;
        }
        return null;
    }

    private long getExpiryTime() {
        try {
            return this.configStore.getLongValue(EXPIRY_TIME);
        }
        catch (NoSuchValueException e) {
            log.warn((Object)e.getMessage());
            return 60000L;
        }
    }

    private int getTokenLength() {
        try {
            return this.configStore.getIntValue(TOKEN_LENGTH);
        }
        catch (NoSuchValueException e) {
            log.warn((Object)e.getMessage());
            return 28;
        }
    }
}

