/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.pingidentity.common.util.TimeUtil;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.time.ZoneOffset;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.Util;
import org.sourceid.common.ValidationUtil;
import org.sourceid.oauth20.device.DeviceAuthorizationState;
import org.sourceid.oauth20.device.DeviceFlowCodes;
import org.sourceid.oauth20.device.DeviceFlowManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.token.AbstractTokenResponse;
import org.sourceid.websso.wrapper.OutMessageContext;

public final class DeviceAuthorizationResponse
extends AbstractTokenResponse {
    private final String baseUrl;
    private final AuthzServerManager authzServerMgr;
    private final DeviceFlowManager deviceFlowManager;
    private final Client client;
    private DeviceFlowCodes deviceFlowCodes;
    private String verificationUrl;
    private String verificationUrlComplete;
    private Integer expiresIn;
    private Integer interval;

    public DeviceAuthorizationResponse(String baseUrl, AuthzServerManager authzServerMgr, DeviceFlowManager deviceFlowManager, Client client) {
        this.baseUrl = baseUrl;
        this.authzServerMgr = authzServerMgr;
        this.deviceFlowManager = deviceFlowManager;
        this.client = client;
        this.generateUserCode();
        this.populateVerificationUrl();
        this.populateVerificationUrlComplete();
        this.populateExpiresIn();
        this.populateInterval();
    }

    private String getUserCode() {
        return this.deviceFlowCodes.getUserCode();
    }

    public String getDeviceCode() {
        return this.deviceFlowCodes.getDeviceCode();
    }

    private String getVerificationUrl() {
        return this.verificationUrl;
    }

    private String getVerificationUrlComplete() {
        return this.verificationUrlComplete;
    }

    private Integer getExpiresIn() {
        return this.expiresIn;
    }

    public Integer getInterval() {
        return this.interval;
    }

    @Override
    public void tokenResponseToOutContext(OutMessageContext outMsgCtx) {
        outMsgCtx.setParam("user_code", this.getUserCode());
        outMsgCtx.setParam("device_code", this.getDeviceCode(), true);
        outMsgCtx.setParam("verification_uri", this.getVerificationUrl());
        outMsgCtx.setParam("verification_uri_complete", this.getVerificationUrlComplete());
        outMsgCtx.setParam("expires_in", this.getExpiresIn());
        outMsgCtx.setParam("interval", this.getInterval());
    }

    public DeviceAuthorizationState toDeviceAuthorizationState(Scope scope, AuthorizationDetails authorizationDetails) {
        long expiresAt = TimeUtil.getCurrentUtcLocalDateTime().plusSeconds(this.getExpiresIn().intValue()).toEpochSecond(ZoneOffset.UTC);
        return new DeviceAuthorizationState(this.client.getClientId(), expiresAt, scope, this.getDeviceCode(), this.getUserCode(), authorizationDetails);
    }

    private void generateUserCode() {
        if (this.deviceFlowCodes == null) {
            this.deviceFlowCodes = this.deviceFlowManager.generateCodes();
        }
    }

    private String getUserAuthzUrl() {
        Object userAuthzUrl = "OVERRIDE_SERVER_DEFAULT".equals(this.client.getDeviceFlowSettingType()) && StringUtils.isNotBlank((String)this.client.getUserAuthzUrlOverride()) ? this.client.getUserAuthzUrlOverride() : (StringUtils.isNotBlank((String)this.authzServerMgr.getUserAuthzUrl()) ? this.authzServerMgr.getUserAuthzUrl() : (StringUtils.isNotBlank((String)this.authzServerMgr.getRegisteredAuthzPath()) ? this.baseUrl + this.authzServerMgr.getRegisteredAuthzPath() : this.baseUrl + "/as/user_authz.oauth2"));
        return userAuthzUrl;
    }

    private void populateVerificationUrl() {
        this.verificationUrl = this.getUserAuthzUrl();
    }

    private void populateVerificationUrlComplete() {
        String userCode = this.getUserCode();
        this.verificationUrlComplete = this.getUserAuthzUrl() + "?user_code=" + Util.urlEncodeUTF8(userCode);
    }

    private void populateExpiresIn() {
        this.expiresIn = "OVERRIDE_SERVER_DEFAULT".equals(this.client.getDeviceFlowSettingType()) && StringUtils.isNotBlank((String)this.client.getPendingAuthzTimeoutOverride()) && ValidationUtil.isValidInt(this.client.getPendingAuthzTimeoutOverride()) ? Integer.valueOf(Integer.parseInt(this.client.getPendingAuthzTimeoutOverride())) : Integer.valueOf(this.authzServerMgr.getPendingAuthzTimeout());
    }

    private void populateInterval() {
        this.interval = "OVERRIDE_SERVER_DEFAULT".equals(this.client.getDeviceFlowSettingType()) && StringUtils.isNotBlank((String)this.client.getDevicePollingIntervalOverride()) && ValidationUtil.isValidInt(this.client.getDevicePollingIntervalOverride()) ? Integer.valueOf(Integer.parseInt(this.client.getDevicePollingIntervalOverride())) : Integer.valueOf(this.authzServerMgr.getDevicePollingInterval());
    }
}

