/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.token.AbstractTokenResponse;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.OutMessageContext;

public class TokenIntrospectResponse
extends AbstractTokenResponse {
    static final List<String> RESERVED_TOKEN_VALUES = Collections.unmodifiableList(Arrays.asList("active", Parameters.CLIENT_ID, Parameters.SCOPE, "token_type", "exp", "iat", "nbf", "aud", "iss", "jti", "authorization_details"));
    private final Log log = LogFactory.getLog(this.getClass());
    private final boolean isActive;
    private final Map<String, AttributeValue> additionalAttributes;
    private final String scope;
    private final String clientId;
    private final String username;
    private final String tokenType;
    private final Long expiresAt;
    private final Long issuedAt;
    private final Long notBefore;
    private final String subject;
    private final Set<String> audience;
    private final String issuedBy;
    private final String tokenId;
    private final Set<String> multiValuedAttributes;
    private final Client client;
    private final AuthorizationDetails authorizationDetails;

    @Override
    public void tokenResponseToOutContext(OutMessageContext outMsgCtx) {
        Map<String, AttributeValue> additionalParams;
        outMsgCtx.setParam("active", this.isActive());
        this.setParamWhenNotEmpty(outMsgCtx, Parameters.SCOPE, this.getScope());
        this.setParamWhenNotEmpty(outMsgCtx, Parameters.CLIENT_ID, this.getClientId());
        this.setParamWhenNotEmpty(outMsgCtx, "username", this.getUsername());
        this.setParamWhenNotEmpty(outMsgCtx, "token_type", this.getTokenType());
        this.setParamWhenNotNull(outMsgCtx, "exp", this.getExpiresAt());
        this.setParamWhenNotNull(outMsgCtx, "iat", this.getIssuedAt());
        this.setParamWhenNotNull(outMsgCtx, "nbf", this.getNotBefore());
        this.setParamWhenNotNull(outMsgCtx, "sub", this.getSubject());
        this.setParamWhenNotNull(outMsgCtx, "iss", this.getIssuedBy());
        this.setParamWhenNotNull(outMsgCtx, "aud", this.getAudience());
        this.setParamWhenNotNull(outMsgCtx, "jti", this.getTokenId());
        if (this.authorizationDetails != null && this.authorizationDetails.getDetails() != null) {
            SimpleJsonRespWriter.setForJsonSerialize(outMsgCtx.getParams(), "authorization_details", this.authorizationDetails.toAttributeValue(), Collections.singletonList("authorization_details"));
            outMsgCtx.setMaskedParamName("authorization_details");
        }
        if ((additionalParams = this.getAdditionalAttributes()) != null) {
            for (Map.Entry<String, AttributeValue> param : additionalParams.entrySet()) {
                if (outMsgCtx.getParams().containsKey(param.getKey())) {
                    if (RESERVED_TOKEN_VALUES.contains(param.getKey())) {
                        this.log.debug((Object)("Mapped attribute collisions found with '" + param.getKey() + "'. Keeping the value associated with the token."));
                        continue;
                    }
                    this.log.debug((Object)("Mapped attribute collisions found with '" + param.getKey() + "'. Returning mapped value for this token."));
                    this.setValue(param.getKey(), param.getValue(), outMsgCtx);
                    continue;
                }
                this.setValue(param.getKey(), param.getValue(), outMsgCtx);
            }
        }
        outMsgCtx.setSupplementalContext("token_introspection_client", this.client);
        AsAuditLogger.setOutMsgCtx(outMsgCtx);
    }

    private void setValue(String key, AttributeValue attrValue, OutMessageContext outMsgCtx) {
        SimpleJsonRespWriter.setForJsonSerialize(outMsgCtx.getParams(), key, attrValue, this.multiValuedAttributes);
    }

    private TokenIntrospectResponse(Builder builder, Client client) {
        this.isActive = builder.isActive;
        this.scope = builder.scope;
        this.clientId = builder.clientId;
        this.username = builder.username;
        this.tokenType = builder.tokenType;
        this.expiresAt = builder.expiresAt;
        this.issuedAt = builder.issuedAt;
        this.notBefore = builder.notBefore;
        this.additionalAttributes = builder.additionalAttributes;
        this.subject = builder.subject;
        this.audience = builder.audience;
        this.issuedBy = builder.issuedBy;
        this.tokenId = builder.tokenId;
        this.multiValuedAttributes = builder.multiValuedAttributes;
        this.client = client;
        this.authorizationDetails = builder.authorizationDetails;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Long getIssuedAt() {
        return this.issuedAt;
    }

    public Long getNotBefore() {
        return this.notBefore;
    }

    public String getScope() {
        return this.scope;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public Object getAudience() {
        if (this.audience == null || this.audience.isEmpty()) {
            return null;
        }
        if (this.multiValuedAttributes.contains("aud")) {
            return this.audience;
        }
        if (this.audience.size() == 1) {
            return this.audience.iterator().next();
        }
        return this.audience;
    }

    public String getIssuedBy() {
        return this.issuedBy;
    }

    public String getSubject() {
        return this.subject;
    }

    public Map<String, AttributeValue> getAdditionalAttributes() {
        if (this.additionalAttributes == null) {
            return Collections.emptyMap();
        }
        return this.additionalAttributes;
    }

    public AuthorizationDetails getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public static class Builder {
        private final boolean isActive;
        private Map<String, AttributeValue> additionalAttributes;
        private String scope;
        private String clientId;
        private String username;
        private String tokenType = "Bearer";
        private Long expiresAt;
        private Long issuedAt;
        private Long notBefore;
        private String subject;
        private Set<String> audience;
        private String issuedBy;
        private String tokenId;
        private Set<String> multiValuedAttributes = Collections.emptySet();
        private AuthorizationDetails authorizationDetails;

        public Builder(boolean isActive) {
            this.isActive = isActive;
        }

        public Builder setAdditionalAttributes(Map<String, AttributeValue> additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public Builder setScope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setTokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder setExpiresAt(Long expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder setIssuedAt(Long issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public Builder setNotBefore(Long notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public Builder setAudience(String audience) {
            this.audience = Collections.singleton(audience);
            return this;
        }

        public Builder setAudience(List<String> audience) {
            if (audience != null) {
                this.audience = new LinkedHashSet<String>(audience);
            }
            return this;
        }

        public Builder setIssuedBy(String issuedBy) {
            this.issuedBy = issuedBy;
            return this;
        }

        public Builder setTokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder setMultiValuedAttributes(Set<String> multiValuedAttributes) {
            this.multiValuedAttributes = multiValuedAttributes;
            return this;
        }

        public Builder setAuthorizationDetails(AuthorizationDetails authorizationDetails) {
            this.authorizationDetails = authorizationDetails;
            return this;
        }

        public TokenIntrospectResponse build(Client client) {
            return new TokenIntrospectResponse(this, client);
        }
    }
}

