/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token.plugin.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.jgroups.MuxRpcDispatcherMgr;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.util.RspList;
import org.sourceid.oauth20.token.plugin.impl.AccessTokenWrapper;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTracker;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.impl.grouprpc.BasePreferredNodesGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.ReplicationMode;
import org.sourceid.saml20.service.impl.grouprpc.RspUtil;
import org.sourceid.saml20.state.StateMgmtFactory;

public class ReferenceBearerAccessTokenTrackerRpcImpl
extends BasePreferredNodesGroupRpc
implements ReferenceBearerAccessTokenTracker {
    ReferenceBearerAccessTokenTracker localTracker;
    int rpcTimeout = 1000;
    private static final String STORE_NAME = "store";
    private static final Class<?>[] STORE_SIGNATURE = new Class[]{String.class, String.class, AccessTokenWrapper.class};
    private static final String UPDATE_EXP_NAME = "updateExpiration";
    private static final Class<?>[] UPDATE_EXP_SIGNATURE = new Class[]{String.class, String.class, Long.class};
    private static final String GET_NAME = "get";
    private static final Class<?>[] GET_SIGNATURE = new Class[]{String.class, String.class};
    private static final String REVOKE_ALL_TOKENS_NAME = "revokeAllAccessTokens";
    private static final String REVOKE_ALL_TOKENS_BY_CLIENT_NAME = "revokeAllAccessTokensByClient";
    private static final Class<?>[] REVOKE_ALL_TOKENS_SIGNATURE = new Class[]{String.class, String.class};
    private static final Class<?>[] REVOKE_ALL_TOKENS_BY_CLIENT_SIGNATURE = new Class[]{String.class, String.class};
    private static final String REVOKE_TOKEN_NAME = "revokeAccessToken";
    private static final Class<?>[] REVOKE_TOKEN_SIGNATURE = new Class[]{String.class, String.class};

    public ReferenceBearerAccessTokenTrackerRpcImpl() {
        super(null, true, StateMgmtFactory.getAdaptiveClusteringConfig().isReplicateReferenceTokens());
        MuxRpcDispatcherMgr mux = MuxRpcDispatcherMgr.getMgr();
        Class<ReferenceBearerAccessTokenTracker> clazz = ReferenceBearerAccessTokenTracker.class;
        this.localTracker = (ReferenceBearerAccessTokenTracker)mux.getRpcInvocationTarget(clazz);
    }

    @Override
    public AccessTokenWrapper get(String tokenManagerId, String hashedTokenValue) {
        RspList rspList;
        if (PropertyInfo.isAdaptiveClusteringEnabled()) {
            RspList rspList2 = this.callRemoteMethods(GET_NAME, (Class[])GET_SIGNATURE, hashedTokenValue, true, tokenManagerId, hashedTokenValue);
            List results = rspList2.getResults();
            for (Object o : results) {
                AccessTokenWrapper wrapper;
                if (o == null || !(o instanceof AccessTokenWrapper) || !(wrapper = (AccessTokenWrapper)o).isTombstone()) continue;
                return null;
            }
            if (results.isEmpty()) {
                return null;
            }
            return (AccessTokenWrapper)results.get(0);
        }
        AccessTokenWrapper accessTokenWrapper = this.localTracker.get(tokenManagerId, hashedTokenValue);
        if (accessTokenWrapper == null && (accessTokenWrapper = RspUtil.getFirstNotNull(rspList = this.callRemoteMethods(GET_NAME, (Class[])GET_SIGNATURE, true, tokenManagerId, hashedTokenValue), AccessTokenWrapper.class)) != null) {
            this.localTracker.store(tokenManagerId, hashedTokenValue, accessTokenWrapper);
        }
        return accessTokenWrapper;
    }

    @Override
    public void updateExpiration(String tokenManagerId, String hashedTokenValue, Long expiresAt) {
        this.callRemoteMethods(UPDATE_EXP_NAME, (Class[])UPDATE_EXP_SIGNATURE, hashedTokenValue, true, ReplicationMode.ASYNC, tokenManagerId, hashedTokenValue, expiresAt);
    }

    @Override
    public void store(String tokenManagerId, String hashedTokenValue, AccessTokenWrapper tokenWrapper) {
        ReplicationMode replMode = ReplicationMode.SYNC;
        if (!StateMgmtFactory.getAdaptiveClusteringConfig().isReplicateReferenceTokensSynchronous()) {
            replMode = ReplicationMode.ASYNC;
        }
        this.callRemoteMethods(STORE_NAME, (Class[])STORE_SIGNATURE, hashedTokenValue, true, replMode, tokenManagerId, hashedTokenValue, tokenWrapper);
    }

    @Override
    public void revokeAllAccessTokens(String tokenManagerId, String accessGrantGuid) {
        Vector<Address> nodes = MgmtFactory.getNodeIndexRegistry().getAddresses(null);
        this.callRemoteMethods(nodes, REVOKE_ALL_TOKENS_NAME, (Class[])REVOKE_ALL_TOKENS_SIGNATURE, false, this.rpcResponseMode, null, this.rpcTimeout, tokenManagerId, accessGrantGuid);
    }

    @Override
    public void revokeAllAccessTokensByClient(String tokenManagerId, String clientId) {
        Vector<Address> nodes = MgmtFactory.getNodeIndexRegistry().getAddresses(null);
        this.callRemoteMethods(nodes, REVOKE_ALL_TOKENS_BY_CLIENT_NAME, (Class[])REVOKE_ALL_TOKENS_BY_CLIENT_SIGNATURE, false, this.rpcResponseMode, null, this.rpcTimeout, tokenManagerId, clientId);
    }

    @Override
    public Boolean revokeAccessToken(String tokenManagerId, String hashedTokenValue) {
        RspList rspList = this.callRemoteMethods(REVOKE_TOKEN_NAME, (Class[])REVOKE_TOKEN_SIGNATURE, hashedTokenValue, true, ReplicationMode.ASYNC, tokenManagerId, hashedTokenValue);
        return RspUtil.getAnyTrue(rspList);
    }

    @Override
    public Map<String, Integer> getHashValueToTokenMapSizes() {
        return this.localTracker.getHashValueToTokenMapSizes();
    }

    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    @Override
    protected int getRpcTimeout() {
        return this.rpcTimeout;
    }
}

