/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token.refresh;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ValidationUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.protocol.InternalPersistentGrantAttributes;
import org.sourceid.oauth20.token.BaseAccessGrantManager;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.oauth20.token.refresh.RefreshToken;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public final class MultiPartRefreshToken
implements RefreshToken {
    private static final Log LOG = LogFactory.getLog(MultiPartRefreshToken.class);
    private static final String EXTENSION_LENGTH_CONFIG_STORE_NAME = "extension-length";
    private static final Integer EXTENSION_LENGTH_DEFAULT = 6;
    private static final String SEPARATOR = ".";
    private static final String SEPARATOR_REGEX = "\\.";
    private static final Pattern TOKEN_VALIDATION_PATTERN = Pattern.compile("[0-9a-zA-Z]+\\.[0-9a-zA-Z]+");
    private static final String OLD_EXTENSION_SEPARATOR = ",";
    private static final String CONFIG_STORE_NAME = "org.sourceid.oauth20.token.refresh.MultiPartRefreshToken";
    private static final ConfigStore CONFIG_STORE = ConfigStoreFarm.getConfig("org.sourceid.oauth20.token.refresh.MultiPartRefreshToken");
    private final String base;
    private final String extension;
    private AccessGrantAttributesHolder grantAttributes;

    private MultiPartRefreshToken(String base, String extension) {
        this.base = base;
        this.extension = extension;
    }

    public static MultiPartRefreshToken newInstance(int refreshTokenLength) {
        int extensionLength = CONFIG_STORE.getIntValue(EXTENSION_LENGTH_CONFIG_STORE_NAME, EXTENSION_LENGTH_DEFAULT);
        int baseLength = refreshTokenLength - SEPARATOR.length() - extensionLength;
        String base = IDGenerator.rndAlphaNumeric(baseLength);
        String extension = IDGenerator.rndAlphaNumeric(extensionLength);
        return new MultiPartRefreshToken(base, extension);
    }

    public static MultiPartRefreshToken newInstance(String base, String extension) {
        return new MultiPartRefreshToken(base, extension);
    }

    @Override
    public String getValue() {
        return this.base + SEPARATOR + this.extension;
    }

    @Override
    public AccessGrant findAccessGrant(BaseAccessGrantManager accessGrantManager) {
        AccessGrant accessGrant = accessGrantManager.doGetByRefreshToken(this.base);
        if (accessGrant == null) {
            LOG.debug((Object)"AccessGrant not found.");
            return null;
        }
        this.grantAttributes = accessGrantManager.getGrantAttributes(accessGrant.getGuid());
        AttributeValue extension = (AttributeValue)this.grantAttributes.getExtendedGrantAttrs().get((Object)InternalPersistentGrantAttributes.REFRESH_TOKEN_EXTENSION.getKey());
        if (extension == null) {
            LOG.debug((Object)"The refresh token extension not found.");
            return null;
        }
        if (extension.hasValue(this.extension)) {
            return accessGrant;
        }
        LOG.debug((Object)String.format("The refresh token extension and the AccessGrant [%s] do not match, trying with the old extension.", accessGrant.getGuid()));
        AttributeValue oldExtension = (AttributeValue)this.grantAttributes.getExtendedGrantAttrs().get((Object)InternalPersistentGrantAttributes.REFRESH_TOKEN_OLD_EXTENSION.getKey());
        if (oldExtension != null) {
            String value = oldExtension.getValue();
            String[] oldExtensionParts = value.split(OLD_EXTENSION_SEPARATOR);
            if (oldExtensionParts.length == 2 && ValidationUtil.isValidLong(oldExtensionParts[1])) {
                long now;
                long expiresAt = Long.parseLong(oldExtensionParts[1]);
                if (expiresAt < (now = System.currentTimeMillis())) {
                    LOG.debug((Object)String.format("The old AccessGrant [%s] extension is expired", accessGrant.getGuid()));
                }
                if (expiresAt >= now && StringUtils.equals((String)oldExtensionParts[0], (String)this.extension)) {
                    return accessGrant;
                }
                LOG.debug((Object)String.format("The old refresh token extension and the AccessGrant [%s] do not match.", accessGrant.getGuid()));
            }
        } else {
            LOG.debug((Object)String.format("The AccessGrant [%s] does not contain an old refresh token extension attribute.", accessGrant.getGuid()));
        }
        LOG.debug((Object)String.format("The provided refresh token doesn't match with the stored AccessGrant [%s], revoking the AccessGrant.", accessGrant.getGuid()));
        accessGrantManager.revokeGrant(accessGrant.getGuid());
        return null;
    }

    @Override
    public void store(AccessGrant accessGrant, AccessGrantAttributesHolder accessGrantAttributes, AuthzServerManager authzServerManager, Client client) {
        TokenUtil.applyLastRolledAt(accessGrantAttributes, authzServerManager, client);
        accessGrant.setRawRefreshTokenValue(this.base);
        accessGrantAttributes.getExtendedGrantAttrs().put(InternalPersistentGrantAttributes.REFRESH_TOKEN_EXTENSION.getKey(), this.extension);
    }

    @Override
    public void storeOldRefreshToken(AccessGrantAttributesHolder accessGrantAttributes, RefreshToken oldRefreshToken, long expiresAt) {
        if (expiresAt > 0L && oldRefreshToken instanceof MultiPartRefreshToken) {
            MultiPartRefreshToken temp = (MultiPartRefreshToken)oldRefreshToken;
            String value = temp.extension + OLD_EXTENSION_SEPARATOR + expiresAt;
            accessGrantAttributes.getExtendedGrantAttrs().put(InternalPersistentGrantAttributes.REFRESH_TOKEN_OLD_EXTENSION.getKey(), value);
            LOG.debug((Object)"The old refresh token reference was added to grant attributes.");
        }
    }

    @Override
    public RefreshToken roll(AuthzServerManager authzServerManager) {
        int extensionLength = CONFIG_STORE.getIntValue(EXTENSION_LENGTH_CONFIG_STORE_NAME, EXTENSION_LENGTH_DEFAULT);
        String extension = IDGenerator.rndAlphaNumeric(extensionLength);
        return MultiPartRefreshToken.newInstance(this.base, extension);
    }

    @Override
    public boolean isGrantAttributeUpdateRequiredAfterRolling() {
        return true;
    }

    @Override
    public AccessGrantAttributesHolder getGrantAttributes(AccessGrantManager accessGrantManager, String accessGrantGuid) {
        if (this.grantAttributes == null) {
            this.grantAttributes = accessGrantManager.getGrantAttributes(accessGrantGuid);
        }
        return this.grantAttributes;
    }

    static void cleanup(AccessGrantAttributesHolder accessGrantAttributes) {
        accessGrantAttributes.getExtendedGrantAttrs().remove((Object)InternalPersistentGrantAttributes.REFRESH_TOKEN_EXTENSION.getKey());
        accessGrantAttributes.getExtendedGrantAttrs().remove((Object)InternalPersistentGrantAttributes.REFRESH_TOKEN_OLD_EXTENSION.getKey());
    }

    public static boolean isValidMultiPartRefreshTokenFormat(String refreshToken) {
        if (StringUtils.isBlank((String)refreshToken)) {
            return false;
        }
        return TOKEN_VALIDATION_PATTERN.matcher(refreshToken).matches();
    }

    public static String[] getMultiPartRefreshTokenParts(String refreshToken) {
        String[] result = null;
        if (MultiPartRefreshToken.isValidMultiPartRefreshTokenFormat(refreshToken)) {
            result = refreshToken.split(SEPARATOR_REGEX);
        }
        return result;
    }
}

