/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token.refresh;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.token.BaseAccessGrantManager;
import org.sourceid.oauth20.token.refresh.MultiPartRefreshToken;
import org.sourceid.oauth20.token.refresh.SimpleRefreshToken;

public interface RefreshToken {
    public String getValue();

    public AccessGrant findAccessGrant(BaseAccessGrantManager var1);

    public void store(AccessGrant var1, AccessGrantAttributesHolder var2, AuthzServerManager var3, Client var4);

    public void storeOldRefreshToken(AccessGrantAttributesHolder var1, RefreshToken var2, long var3);

    public RefreshToken roll(AuthzServerManager var1);

    public boolean isGrantAttributeUpdateRequiredAfterRolling();

    public AccessGrantAttributesHolder getGrantAttributes(AccessGrantManager var1, String var2);

    public static RefreshToken newInstance(String refreshToken) {
        if (MultiPartRefreshToken.isValidMultiPartRefreshTokenFormat(refreshToken)) {
            String[] multiPartRefreshTokenParts = MultiPartRefreshToken.getMultiPartRefreshTokenParts(refreshToken);
            return MultiPartRefreshToken.newInstance(multiPartRefreshTokenParts[0], multiPartRefreshTokenParts[1]);
        }
        return SimpleRefreshToken.newInstance(refreshToken);
    }
}

