/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token.refresh;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import org.sourceid.common.IDGenerator;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.token.BaseAccessGrantManager;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.oauth20.token.refresh.MultiPartRefreshToken;
import org.sourceid.oauth20.token.refresh.RefreshToken;

public final class SimpleRefreshToken
implements RefreshToken {
    private final String refreshToken;
    private boolean grantAttributeUpdateRequiredAfterRolling;

    public SimpleRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public static SimpleRefreshToken newInstance(int refreshTokenLength) {
        String refreshToken = IDGenerator.rndAlphaNumeric(refreshTokenLength);
        return new SimpleRefreshToken(refreshToken);
    }

    public static SimpleRefreshToken newInstance(String refreshToken) {
        return new SimpleRefreshToken(refreshToken);
    }

    @Override
    public String getValue() {
        return this.refreshToken;
    }

    @Override
    public void store(AccessGrant accessGrant, AccessGrantAttributesHolder accessGrantAttributes, AuthzServerManager authzServerManager, Client client) {
        this.grantAttributeUpdateRequiredAfterRolling = TokenUtil.applyLastRolledAt(accessGrantAttributes, authzServerManager, client);
        accessGrant.setRawRefreshTokenValue(this.refreshToken);
        MultiPartRefreshToken.cleanup(accessGrantAttributes);
    }

    @Override
    public void storeOldRefreshToken(AccessGrantAttributesHolder accessGrantAttributes, RefreshToken oldRefreshToken, long expiresAt) {
    }

    @Override
    public RefreshToken roll(AuthzServerManager authzServerManager) {
        return SimpleRefreshToken.newInstance(authzServerManager.getRefreshTokenLength());
    }

    @Override
    public boolean isGrantAttributeUpdateRequiredAfterRolling() {
        return this.grantAttributeUpdateRequiredAfterRolling;
    }

    @Override
    public AccessGrantAttributesHolder getGrantAttributes(AccessGrantManager accessGrantManager, String accessGrantGuid) {
        return accessGrantManager.getGrantAttributes(accessGrantGuid);
    }

    @Override
    public AccessGrant findAccessGrant(BaseAccessGrantManager accessGrantManager) {
        return accessGrantManager.doGetByRefreshToken(this.refreshToken);
    }
}

