/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.utils;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwt.consumer.SubValidator;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.validate.CredentialsValidator;

public final class ClientJwtAuthnUtils {
    public static final String INVALID_JWT_ERROR = "Invalid JWT token";
    private static final Log log = LogFactory.getLog(ClientJwtAuthnUtils.class);
    private static final String CLIENT_ASSERTION_NOT_FOUND = String.format("Unable to find a valid %s of type %s.", "client_assertion", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");

    private ClientJwtAuthnUtils() {
        throw new UnsupportedOperationException("not allowed");
    }

    public static String getClientAssertionRequestParamValue(HttpServletRequest request) throws AccessTokenRequestException {
        return CredentialsValidator.getSensitiveRequestParam(request, "client_assertion", true);
    }

    public static JwtContext getClientAssertionJwtContext(HttpServletRequest request) throws AccessTokenRequestException {
        String jwt = ClientJwtAuthnUtils.getClientAssertionRequestParamValue(request);
        if (StringUtils.isEmpty((String)jwt)) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, CLIENT_ASSERTION_NOT_FOUND, 400);
        }
        JwtConsumer validateSubJwtConsumer = new JwtConsumerBuilder().setSkipAllDefaultValidators().registerValidator((ErrorCodeValidator)new SubValidator(true)).setDisableRequireSignature().setSkipSignatureVerification().build();
        try {
            return validateSubJwtConsumer.process(jwt);
        }
        catch (InvalidJwtException e) {
            log.debug((Object)e.toString());
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, INVALID_JWT_ERROR, 400);
        }
    }
}

