/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.utils;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jca.ProviderContext;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.lang.JoseException;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientSecondarySecretSet;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.openid.connect.MultiDecryptionKeyResolver;
import org.sourceid.openid.connect.SymmetricDecryptionKeyResolver;

public final class JwtProcessingUtils {
    private static final Log log = LogFactory.getLog(JwtProcessingUtils.class);

    private JwtProcessingUtils() {
        throw new AssertionError((Object)"not allowed");
    }

    public static JwtClaims processEncryptedJwt(String requestObj, JwtConsumerBuilder jwtConsumerBuilder, Client client, ClientSecretUtils.ActivityType activityType) throws InvalidJwtException {
        JwtClaims claims;
        MultiDecryptionKeyResolver decryptionKeyResolver = new MultiDecryptionKeyResolver(client.getSecretAsUtf8Bytes());
        jwtConsumerBuilder.setDecryptionKeyResolver((DecryptionKeyResolver)decryptionKeyResolver);
        JwtProcessingUtils.checkApplyKeyProviderContextOverride(requestObj, decryptionKeyResolver, jwtConsumerBuilder);
        JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
        boolean decryptedWithSecondarySecret = false;
        try {
            claims = jwtConsumer.processToClaims(requestObj);
        }
        catch (InvalidJwtException e) {
            if (e.getCause() instanceof JoseException) {
                claims = JwtProcessingUtils.decryptJwtWithSecondarySecrets(requestObj, jwtConsumerBuilder, client);
                if (claims == null) {
                    throw e;
                }
                decryptedWithSecondarySecret = true;
            }
            throw e;
        }
        if (decryptedWithSecondarySecret) {
            ClientSecretUtils.logSecondarySecretUsage(activityType, client.getClientId());
        }
        return claims;
    }

    public static void checkApplyKeyProviderContextOverride(String jwt, DecryptionKeyResolver decryptionKeyResolver, JwtConsumerBuilder jwtConsumerBuilder) {
        try {
            JsonWebStructure joseObject = JsonWebStructure.fromCompactSerialization((String)jwt);
            if (joseObject instanceof JsonWebEncryption) {
                PrivateKey privateKey;
                String hsmProviderName;
                JsonWebEncryption jwe = (JsonWebEncryption)joseObject;
                jwe.setDoKeyValidation(false);
                Key key = decryptionKeyResolver.resolveKey(jwe, Collections.emptyList());
                if (key instanceof PrivateKey && (hsmProviderName = SecurityProviderUtil.getHSMProviderName(privateKey = (PrivateKey)key)) != null) {
                    ProviderContext context = new ProviderContext();
                    context.getSuppliedKeyProviderContext().setKeyAgreementProvider(hsmProviderName);
                    context.getSuppliedKeyProviderContext().setCipherProvider(hsmProviderName);
                    if (PropertyInfo.getHSMMode() == PropertyInfo.HSM_MODE.AWSCLOUDHSM || PropertyInfo.getHSMMode() == PropertyInfo.HSM_MODE.LUNA) {
                        context.getSuppliedKeyProviderContext().setKeyDecipherModeOverride(ProviderContext.KeyDecipherMode.DECRYPT);
                    }
                    jwtConsumerBuilder.setJweProviderContext(context);
                }
            }
        }
        catch (JoseException e) {
            log.debug((Object)("Error occurred checking whether to apply key provider context override: " + ExceptionUtil.toStringWithCauses(e)));
        }
    }

    private static JwtClaims decryptJwtWithSecondarySecrets(String requestObject, JwtConsumerBuilder jwtConsumerBuilder, Client client) throws InvalidJwtException {
        List<ClientSecondarySecretSet.ClientSecondarySecret> secondarySecrets = client.getSecondarySecrets().getSecondarySecrets();
        InvalidJwtException invalidJwtException = null;
        for (ClientSecondarySecretSet.ClientSecondarySecret secondarySecret : secondarySecrets) {
            if (secondarySecret.getReversibleSecret() == null) continue;
            String deobfuscatedSecret = Obfuscator.deobfuscate(secondarySecret.getReversibleSecret());
            byte[] secretBytes = deobfuscatedSecret.getBytes(StandardCharsets.UTF_8);
            SymmetricDecryptionKeyResolver secondarySecretResolver = new SymmetricDecryptionKeyResolver(secretBytes);
            jwtConsumerBuilder.setDecryptionKeyResolver((DecryptionKeyResolver)secondarySecretResolver);
            JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
            try {
                JwtClaims claims = jwtConsumer.processToClaims(requestObject);
                return claims;
            }
            catch (InvalidJwtException e) {
                invalidJwtException = e;
                if (e.getCause() instanceof JoseException) continue;
                throw e;
            }
        }
        if (invalidJwtException != null) {
            throw invalidJwtException;
        }
        return null;
    }
}

