/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.utils;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.websso.wrapper.OutMessageContext;

public class TokenIntrospectionUtils {
    public static final String TOKEN_INTROSPECTION_CLIENT = "token_introspection_client";
    public static final String TOKEN_INTROSPECTION_CLAIM_NAME = "token_introspection";
    public static final String TOKEN_INTROSPECTION_JWT_TYPE_HEADER = "token-introspection+jwt";

    private TokenIntrospectionUtils() {
    }

    public static boolean isJwtResponseRequested(HttpServletRequest request) {
        boolean result = false;
        Enumeration accept = request.getHeaders("Accept");
        while (!result && accept.hasMoreElements()) {
            String element = (String)accept.nextElement();
            if (!"application/token-introspection+jwt".equals(element)) continue;
            result = true;
        }
        return result;
    }

    public static boolean isRequestProcessedSuccessfully(OutMessageContext outMsgCtx) {
        return !outMsgCtx.getParams().containsKey("error");
    }
}

