/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.validate;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.validate.ClientValidator;
import org.sourceid.oauth20.validate.CredentialsValidator;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class ClientCertValidator
extends CredentialsValidator {
    private ClientManager clientManager = GlobalRegistry.getService(ClientManager.class);

    @Override
    public Client getValidClient(HttpServletRequest req) throws AccessTokenRequestException {
        String clientId = ClientCertValidator.getClientId(req);
        if (StringUtils.isNotBlank((String)clientId)) {
            AuditLogger.setPartnerId(clientId);
            Client client = this.clientManager.getCachedClient(clientId);
            if (client != null && !client.isEnabled()) {
                AsAuditLogger.setDescription("Client " + clientId + " is disabled");
            }
            if (client != null && client.isClientCertValidationEnabled() && this.validateClientWithCertificates(req, client) && client.isEnabled()) {
                this.getClientSecret(req);
                return client;
            }
        }
        return null;
    }

    private boolean validateClientWithCertificates(HttpServletRequest request, Client client) throws AccessTokenRequestException {
        X509Certificate[] clientCerts = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (clientCerts != null && clientCerts.length > 0) {
            return ClientValidator.isClientCertValid(clientCerts, client);
        }
        throw ClientCertValidator.invalidClient((StringUtils.isNotBlank((String)client.getClientId()) ? client.getClientId() : Parameters.CLIENT_ID) + " is configured to use client certificates but there were no client certificates sent in the request.");
    }

    @Override
    protected String getClientSecret(HttpServletRequest req) throws AccessTokenRequestException {
        String clientSecret = super.getClientSecret(req);
        if (StringUtils.isNotEmpty((String)clientSecret)) {
            throw ClientCertValidator.invalidClient("Client secret MUST NOT be sent when using Client Certificates for authentication.");
        }
        return null;
    }
}

