/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.validate;

import java.security.Key;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientVerificationSecretResolver;
import org.sourceid.oauth20.domain.NbfTooLongAgoValidator;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.issuer.OAuthAudienceUtils;
import org.sourceid.oauth20.utils.ClientJwtAuthnUtils;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.oauth20.validate.ClientSecretJwtValidator;
import org.sourceid.oauth20.validate.CredentialsValidator;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.BearerAssertionReplayPreventionServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public abstract class ClientJwtValidator
extends CredentialsValidator {
    private final ClientManager clientManager;
    private final AuthzServerManager authServerManager;
    private final OAuthAudienceUtils oAuthAudienceUtils;
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConfigStore config = ConfigStoreFarm.getConfig("oauth-credentials-validator");
    private final int secondsOfAllowedClockSkew = this.config.getIntValue("secondsOfAllowedClockSkewforJWT", 60);
    private final int maxFutureValidityInMinute = this.config.getIntValue("maxFutureValidityInMinutesForJWT", 60);
    private final NbfTooLongAgoValidator nbfTooLongAgoValidator = new NbfTooLongAgoValidator(this.config.getIntValue("maxPastValidityInMinutes", -1));
    private final boolean issuerMustBeEqualToClientId = this.config.getBooleanValue("issuerMustBeEqualToClientId", true);

    protected ClientJwtValidator() {
        this(MgmtFactory.getClientManager(), MgmtFactory.getAuthzServerManager(), OAuthAudienceUtils.getInstance());
    }

    protected ClientJwtValidator(ClientManager clientManager, AuthzServerManager authServerManager, OAuthAudienceUtils oAuthAudienceUtils) {
        this.clientManager = clientManager;
        this.authServerManager = authServerManager;
        this.oAuthAudienceUtils = oAuthAudienceUtils;
    }

    protected abstract VerificationKeyResolver getKeyResolver(Client var1);

    protected abstract boolean isValidClientAuthnType(Client var1);

    private AlgorithmConstraints getAlgorithmConstraints(Client client) {
        String[] algsArray;
        if (StringUtils.isNotBlank((String)client.getTokenEndpointAuthSigningAlgorithm())) {
            algsArray = new String[]{client.getTokenEndpointAuthSigningAlgorithm()};
        } else {
            List<String> algs = OpenIdConnectProviderInfo.getVerificationAlgorithmsSupported();
            algsArray = algs.toArray(new String[0]);
        }
        return new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, algsArray);
    }

    @Override
    public Client getValidClient(HttpServletRequest req) throws AccessTokenRequestException {
        JwtContext jwtContext;
        Client client;
        block10: {
            client = null;
            jwtContext = null;
            String httpRequestClientId = CredentialsValidator.getClientId(req);
            Client requestedClient = this.getClient(httpRequestClientId);
            this.checkRequestForMultipleValues(req, "client_assertion_type");
            this.checkRequestForMultipleValues(req, "client_assertion");
            String assertionType = ClientJwtValidator.getSensitiveRequestParam(req, "client_assertion_type", true);
            if ("urn:ietf:params:oauth:client-assertion-type:jwt-bearer".equals(assertionType)) {
                jwtContext = ClientJwtAuthnUtils.getClientAssertionJwtContext(req);
                try {
                    String subject = jwtContext.getJwtClaims().getSubject();
                    AsAuditLogger.setPartnerId(subject);
                    if (jwtContext.getJwtClaims().getJwtId() != null) {
                        AuditLogger.setRequestJti(jwtContext.getJwtClaims().getJwtId());
                    }
                    if ((client = this.getClient(subject)) == null) {
                        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, String.format("Client not found in client database for JWT's %s claim value '%s'.", "sub", subject), 400);
                    }
                    if ((client.isJwtAuthn() || client.isClientSecretJwtAuthn()) && !client.isEnabled()) {
                        AsAuditLogger.setDescription("The client is disabled.");
                    }
                    if (httpRequestClientId != null && !client.getClientId().equals(httpRequestClientId)) {
                        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "The client id '" + httpRequestClientId + "' in the request does not match with the JWT's sub claim value '" + client.getClientId() + "'", 400);
                    }
                    if (!this.isValidJwtSettings(client, req)) {
                        return null;
                    }
                    break block10;
                }
                catch (MalformedClaimException e) {
                    this.log.error((Object)e);
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "Invalid JWT token", 400);
                }
            }
            if (requestedClient != null && (requestedClient.isJwtAuthn() || requestedClient.isClientSecretJwtAuthn())) {
                throw ClientJwtValidator.invalidClient("The client '" + requestedClient.getClientId() + "' is configured to use JWT but the corresponding assertion type was not sent in the request.");
            }
        }
        if (client != null && this.validateJwt(client, jwtContext, req)) {
            return client;
        }
        return null;
    }

    private boolean isValidJwtSettings(Client client, HttpServletRequest req) throws AccessTokenRequestException {
        if (!client.isEnabled()) {
            return false;
        }
        if (!this.isValidClientAuthnType(client)) {
            return false;
        }
        String clientSecret = super.getClientSecret(req);
        if (StringUtils.isEmpty((String)clientSecret)) {
            return true;
        }
        throw ClientJwtValidator.invalidClient("Invalid client or client credentials.");
    }

    private Client getClient(String clientId) throws AccessTokenRequestException {
        Client client;
        try {
            client = this.clientManager.getCachedClient(clientId);
        }
        catch (ClientManager.ClientManagementException e) {
            AsAuditLogger.log("Database Exception");
            this.log.error((Object)"Unable to get client from client database", (Throwable)e);
            throw new AccessTokenRequestException(null, "Unable to get client from client database.");
        }
        return client;
    }

    private void checkRequestForMultipleValues(HttpServletRequest request, String paramName) throws AccessTokenRequestException {
        String[] values = request.getParameterValues(paramName);
        if (values != null && values.length > 1) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "parameter " + paramName + " repeats");
        }
    }

    private boolean validateJwt(Client client, JwtContext jwtContext, HttpServletRequest req) throws AccessTokenRequestException {
        ClientVerificationSecretResolver secretResolver;
        Key key;
        String clientId = client.getClientId();
        boolean enforceOneTimeOnly = Boolean.TRUE.equals(client.isEnforceReplayPrevention());
        VerificationKeyResolver resolver = this.getKeyResolver(client);
        try {
            JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setRequireSubject().setRequireExpirationTime().setExpectedAudience(this.getAcceptableAudiences(req)).setSkipVerificationKeyResolutionOnNone().setVerificationKeyResolver(resolver).setJwsAlgorithmConstraints(this.getAlgorithmConstraints(client)).setAllowedClockSkewInSeconds(this.secondsOfAllowedClockSkew).setMaxFutureValidityInMinutes(this.maxFutureValidityInMinute).registerValidator((ErrorCodeValidator)this.nbfTooLongAgoValidator);
            if (enforceOneTimeOnly) {
                jwtConsumerBuilder.setRequireJwtId();
            }
            if (this.issuerMustBeEqualToClientId) {
                jwtConsumerBuilder.setExpectedIssuer(clientId);
            }
            if (this instanceof ClientSecretJwtValidator) {
                jwtConsumerBuilder.setRelaxVerificationKeyValidation();
            }
            JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
            jwtConsumer.processContext(jwtContext);
            JwtClaims claims = jwtContext.getJwtClaims();
            req.setAttribute("com.pingidentity.oauth.client.jwtClaimsMap", (Object)claims.getClaimsMap());
            String iss = claims.getIssuer();
            if (StringUtils.isEmpty((String)iss)) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, "Issuer (iss) claim must be present.", 400);
            }
            if (enforceOneTimeOnly) {
                String jwtId = claims.getJwtId();
                NumericDate expirationTime = claims.getExpirationTime();
                Calendar expiration = Util.getUtcCalendar();
                long expirationTimeWithSkew = expirationTime.getValueInMillis() + (long)this.secondsOfAllowedClockSkew * 1000L;
                expiration.setTimeInMillis(expirationTimeWithSkew);
                AssertionReplayPreventionService replaySvc = StateMgmtFactory.getBearerAssertionReplayPreventionSvc();
                boolean isUsedJwt = replaySvc.isReplay(clientId + ":" + jwtId, expiration);
                if (isUsedJwt) {
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, "Reusing JWT for client authentication.", 400);
                }
            }
        }
        catch (MalformedClaimException | InvalidJwtException | BearerAssertionReplayPreventionServiceException e) {
            this.log.error((Object)e);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, "Invalid JWT token", 400);
        }
        if (resolver instanceof ClientVerificationSecretResolver && (key = (secretResolver = (ClientVerificationSecretResolver)resolver).getSelectedKey()) != null) {
            ClientSecretUtils.setSecretToRequestAttributes(req, key);
        }
        return true;
    }

    private String[] getAcceptableAudiences(HttpServletRequest req) {
        Function<String, String> tokenEndpointCreator = s -> s + "/as/token.oauth2";
        BiFunction<String, HttpServletRequest, String> currentEndpointCreator = (s, request) -> s + AdapterPathSupport.getRequestUriWithoutContextPath(request);
        HashSet<Object> audiences = new HashSet<Object>();
        String baseUrl = MetaDataFactory.getLocalMetaData().getBaseUrl();
        audiences.add(baseUrl);
        audiences.add(tokenEndpointCreator.apply(baseUrl));
        audiences.add(currentEndpointCreator.apply(baseUrl, req));
        for (String aud : this.oAuthAudienceUtils.getAudienceValues(req)) {
            audiences.add(aud);
            audiences.add(tokenEndpointCreator.apply(aud));
            audiences.add(currentEndpointCreator.apply(aud, req));
        }
        if (StringUtils.isNotBlank((String)this.authServerManager.getTokenEndpointBaseUrl())) {
            String alternateTokenEndpoint = this.authServerManager.getTokenEndpointBaseUrl() + "/as/token.oauth2";
            audiences.add(alternateTokenEndpoint);
        }
        return audiences.toArray(new String[0]);
    }
}

