/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.validate;

import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.oauth20.validate.CredentialsValidator;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class ClientSecretValidator
extends CredentialsValidator {
    private final Log log = LogFactory.getLog(this.getClass());
    private ClientManager clientMgr = GlobalRegistry.getService(ClientManager.class);

    @Override
    public Client getValidClient(HttpServletRequest req) throws AccessTokenRequestException {
        Client client;
        String clientId = ClientSecretValidator.getClientId(req);
        String clientSecret = this.getClientSecret(req);
        if (StringUtils.isNotEmpty((String)clientId)) {
            AsAuditLogger.setPartnerId(clientId);
            try {
                client = this.clientMgr.getCachedClient(clientId);
            }
            catch (ClientManager.ClientManagementException e) {
                AsAuditLogger.log("Database Exception");
                this.log.error((Object)"Unable to get client from client database", (Throwable)e);
                throw new AccessTokenRequestException(null, "Unable to get client from client database.");
            }
            if (client == null || !client.isEnabled()) {
                if (client != null && !client.isEnabled()) {
                    AsAuditLogger.setDescription("The client is disabled.");
                    this.log.debug((Object)("Client " + client.getClientId() + " is disabled"));
                }
                throw ClientSecretValidator.invalidClient("Invalid client or client credentials.");
            }
            if (ClientAuthenticationType.NONE != client.getClientAuthnType() && ClientAuthenticationType.SECRET != client.getClientAuthnType()) {
                throw ClientSecretValidator.invalidClient("Invalid client or client credentials.");
            }
            if (ClientAuthenticationType.SECRET == client.getClientAuthnType() && !client.checkSecret(clientSecret)) {
                throw ClientSecretValidator.invalidClient("Invalid client or client credentials.");
            }
            if (ClientAuthenticationType.NONE == client.getClientAuthnType() && StringUtils.isNotEmpty((String)clientSecret)) {
                throw ClientSecretValidator.invalidClient("Invalid client or client credentials.");
            }
            if (StringUtils.isNotBlank((String)clientSecret)) {
                ClientSecretUtils.setSecretToRequestAttributes(req, clientSecret.getBytes(StandardCharsets.UTF_8));
            }
        } else {
            if (StringUtils.isNotEmpty((String)req.getParameter(Parameters.CLIENT_SECRET))) {
                throw ClientSecretValidator.invalidClient(Parameters.CLIENT_SECRET + " provided without a " + Parameters.CLIENT_ID);
            }
            client = new Client();
        }
        return client;
    }
}

