/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.validate;

import com.pingidentity.crypto.X500Util;
import com.pingidentity.crypto.X509CertPathValidatorSupport;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class ClientValidator {
    public static final String TRUST_ANY = "Trust Any";

    public static boolean isClientCertValid(X509Certificate[] clientCertsFromRequest, Client client) throws AccessTokenRequestException {
        if (ClientValidator.doesIssuerDnMatch(clientCertsFromRequest, client) && ClientValidator.doesSubjectDnMatch(clientCertsFromRequest, client)) {
            return true;
        }
        AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_client);
        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, "No trusted CA issuers found for " + client.getClientId(), 401);
    }

    protected static boolean doesIssuerDnMatch(X509Certificate[] clientCertsFromRequest, Client client) throws AccessTokenRequestException {
        X509CertPathValidatorSupport validatorSupport = new X509CertPathValidatorSupport(clientCertsFromRequest, false);
        TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
        if (TRUST_ANY.equals(client.getClientCertIssuerDn())) {
            validatorSupport.addTrustAnchors(trustedCAsManager.getTrustedCaTrustAnchors());
        } else {
            validatorSupport.addTrustAnchors(trustedCAsManager.getTrustAnchorsByDN(new X500Principal(client.getClientCertIssuerDn())));
        }
        validatorSupport.pruneCertChain();
        if (validatorSupport.isPathValid()) {
            return true;
        }
        AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_client);
        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, String.format("The issuer DN configured for %s does not match an issuer DN in the client certificate chain", client.getClientId()), 401);
    }

    protected static boolean doesSubjectDnMatch(X509Certificate[] clientCertsFromRequest, Client client) throws AccessTokenRequestException {
        X509Certificate clientCertFromRequest = clientCertsFromRequest[0];
        X500Principal configuredSubjectDn = new X500Principal(client.getClientCertSubjectDn());
        if (X500Util.equals(configuredSubjectDn, clientCertFromRequest.getSubjectX500Principal())) {
            return true;
        }
        AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_client);
        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, String.format("The subject DN configured for %s does not match the subject DN of the client certificate in the request", client.getClientId()), 401);
    }

    public static interface UniqueIdChecker {
        public boolean isUnique(String var1);
    }
}

