/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.validate;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.BasicAuthHelp;
import org.sourceid.auth.BasicAuthValue;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public abstract class CredentialsValidator {
    protected static final String OAUTH_CREDENTIALS_VALIDATOR_CONFIG_STORE_FILE = "oauth-credentials-validator";
    private static final Log log = LogFactory.getLog(CredentialsValidator.class);
    private static ConfigStore config = ConfigStoreFarm.getConfig("oauth-credentials-validator");
    private static boolean disallowQueryString = config.getBooleanValue("disallowQueryString", true);

    protected static AccessTokenRequestException invalidClient(String msg) {
        if (AsAuditLogger.isDescriptionBlank()) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_client);
        }
        return new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, msg, 401);
    }

    protected static BasicAuthValue getBasicAuthValue(HttpServletRequest req) throws AccessTokenRequestException {
        String authzHeaderValue = BasicAuthHelp.getAuthTokenFromHeaders(req);
        if (authzHeaderValue != null) {
            try {
                return BasicAuthHelp.getValues(authzHeaderValue, true, true);
            }
            catch (Exception e) {
                String message = "unable to parse Authorization header.";
                log.debug((Object)message, (Throwable)e);
                throw CredentialsValidator.invalidClient(message);
            }
        }
        return null;
    }

    public static String getClientId(HttpServletRequest req) throws AccessTokenRequestException {
        BasicAuthValue basicAuthValue = CredentialsValidator.getBasicAuthValue(req);
        String basicUsername = basicAuthValue != null ? basicAuthValue.getUsername() : null;
        CredentialsValidator.checkQueryStringValue(req, Parameters.CLIENT_ID, true);
        String clientIdParam = req.getParameter(Parameters.CLIENT_ID);
        if (StringUtils.isNotEmpty((String)clientIdParam) && StringUtils.isNotEmpty((String)basicUsername) && !StringUtils.equals((String)clientIdParam, (String)basicUsername)) {
            throw CredentialsValidator.invalidClient(Parameters.CLIENT_ID + " value doesn't match HTTP Basic username value");
        }
        return StringUtils.isNotEmpty((String)clientIdParam) ? clientIdParam : basicUsername;
    }

    public static void checkQueryStringValue(HttpServletRequest req, String key, boolean denyInPostOnly) throws AccessTokenRequestException {
        Map<String, String> map;
        boolean checkAllMethods = true;
        if (denyInPostOnly) {
            checkAllMethods = "POST".equals(req.getMethod());
        }
        if (checkAllMethods && disallowQueryString && req.getQueryString() != null && (map = Util.parseQueryString(req.getQueryString(), true)).containsKey(key)) {
            throw CredentialsValidator.invalidClient(key + " MUST NOT be sent as part of the query string.");
        }
    }

    protected String getClientSecret(HttpServletRequest req) throws AccessTokenRequestException {
        BasicAuthValue basicAuthValue = CredentialsValidator.getBasicAuthValue(req);
        String basicPassword = basicAuthValue != null ? basicAuthValue.getPassword() : null;
        CredentialsValidator.checkQueryStringValue(req, Parameters.CLIENT_SECRET, false);
        String clientSecretParam = req.getParameter(Parameters.CLIENT_SECRET);
        if (StringUtils.isNotEmpty((String)clientSecretParam) && StringUtils.isNotEmpty((String)basicPassword)) {
            throw CredentialsValidator.invalidClient("The client MUST NOT use more than one authentication method in each request.");
        }
        return StringUtils.isNotEmpty((String)clientSecretParam) ? clientSecretParam : basicPassword;
    }

    public static String getSensitiveRequestParam(HttpServletRequest req, String paramKey, boolean denyInPostOnly) throws AccessTokenRequestException {
        CredentialsValidator.checkQueryStringValue(req, paramKey, denyInPostOnly);
        return req.getParameter(paramKey);
    }

    public abstract Client getValidClient(HttpServletRequest var1) throws AccessTokenRequestException;
}

