/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.validate.admin.auth;

import com.fasterxml.jackson.core.JsonPointer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.mgmt.impl.JwtIssuer;

public class JwtAdminApiAuthValidator {
    private static final Log log = LogFactory.getLog(JwtAdminApiAuthValidator.class);
    private static final String ADMIN_AUTH_ERROR_PREFIX = "JWT ADMIN AUTH ERROR: ";
    private static final String ALPHANUMERIC_PERIODS_UNDERSCORES_HYPHENS_REGEX = "^[a-zA-Z0-9._-]+$";
    private final List<JwtIssuer> issuers;

    public JwtAdminApiAuthValidator(List<JwtIssuer> issuers) {
        this.issuers = issuers;
    }

    public boolean validate() {
        if (CollectionUtils.isEmpty(this.issuers)) {
            log.error((Object)"JWT ADMIN AUTH ERROR: No issuer IDs found.");
            return false;
        }
        if (!this.validateConfigurationBetweenJwtIssuers()) {
            return false;
        }
        List invalidIssuerIds = this.issuers.stream().filter(this::isInvalidJwtIssuer).map(JwtIssuer::getIssuerId).collect(Collectors.toList());
        if (!invalidIssuerIds.isEmpty()) {
            log.error((Object)("JWT ADMIN AUTH ERROR: Invalid JWT Issuer found for: " + String.join((CharSequence)", ", invalidIssuerIds)));
            return false;
        }
        return true;
    }

    private boolean validateConfigurationBetweenJwtIssuers() {
        List duplicateIssuerIds = this.issuers.stream().map(jwtIssuer -> jwtIssuer.getIssuerId().toLowerCase()).collect(Collectors.groupingBy(e -> e, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicateIssuerIds.isEmpty()) {
            log.error((Object)("JWT ADMIN AUTH ERROR: Duplicate issuer IDs found: " + String.join((CharSequence)", ", duplicateIssuerIds)));
            return false;
        }
        HashSet duplicateIssuers = new HashSet();
        HashSet issuersVisited = new HashSet();
        this.issuers.forEach(jwtIssuer -> {
            if (issuersVisited.contains(jwtIssuer.getIssuer())) {
                duplicateIssuers.add(jwtIssuer.getIssuer());
            } else {
                issuersVisited.add(jwtIssuer.getIssuer());
            }
        });
        if (!duplicateIssuers.isEmpty()) {
            log.error((Object)("JWT ADMIN AUTH ERROR: Duplicate issuers found: " + String.join((CharSequence)", ", duplicateIssuers)));
            return false;
        }
        return true;
    }

    private boolean isInvalidJwtIssuer(JwtIssuer jwtIssuer) {
        if (jwtIssuer == null) {
            log.error((Object)"JWT ADMIN AUTH ERROR: JWT Issuer is null.");
            return true;
        }
        boolean isInvalid = false;
        if (!jwtIssuer.getIssuerId().matches(ALPHANUMERIC_PERIODS_UNDERSCORES_HYPHENS_REGEX)) {
            log.error((Object)(ADMIN_AUTH_ERROR_PREFIX + jwtIssuer.getIssuerId() + " - Invalid issuer ID found. Issuer ID must only contain alphanumeric characters, periods, underscores, and hyphens."));
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)jwtIssuer.getJwksUri()) && !ValidationUtil.isValidHttpsUrl(jwtIssuer.getJwksUri())) {
            log.error((Object)(ADMIN_AUTH_ERROR_PREFIX + jwtIssuer.getIssuerId() + " - Invalid JWKS Endpoint found: " + jwtIssuer.getJwksUri()));
            isInvalid = true;
        }
        isInvalid = this.isValueMissing(jwtIssuer.getIssuerId(), jwtIssuer.getJwksUri(), "JWKS Endpoint") || isInvalid;
        isInvalid = this.isValueMissing(jwtIssuer.getIssuerId(), jwtIssuer.getIssuer(), "Issuer") || isInvalid;
        isInvalid = this.isValueMissing(jwtIssuer.getIssuerId(), jwtIssuer.getUsernameAttribute(), "Username Attribute") || this.isInvalidJsonPointer(jwtIssuer.getIssuerId(), jwtIssuer.getUsernameAttribute(), "Username Attribute") || isInvalid;
        isInvalid = this.isValueMissing(jwtIssuer.getIssuerId(), jwtIssuer.getRoleSearchAttribute(), "Role Attribute") || this.isInvalidJsonPointer(jwtIssuer.getIssuerId(), jwtIssuer.getRoleSearchAttribute(), "Role Attribute") || isInvalid;
        return isInvalid;
    }

    private boolean isValueMissing(String issuerId, String value, String name) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            log.error((Object)(ADMIN_AUTH_ERROR_PREFIX + issuerId + " - " + name + " is a required value to perform JWT Authentication and cannot be empty."));
            return true;
        }
        return false;
    }

    private boolean isInvalidJsonPointer(String issuerId, String jsonPointer, String name) {
        if (!jsonPointer.startsWith("/")) {
            return false;
        }
        try {
            JsonPointer.compile((String)jsonPointer);
            return false;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)(ADMIN_AUTH_ERROR_PREFIX + issuerId + " - " + name + " is an invalid JSON Pointer: " + jsonPointer));
            return true;
        }
    }
}

