/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.validate.admin.auth;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OAuth2AdminAuthValidator {
    private static final Log log = LogFactory.getLog(OAuth2AdminAuthValidator.class);

    protected boolean validateClientSecret(String value, String friendlyName, String clientAuthType) {
        boolean isRequired = "client_secret_basic".equals(clientAuthType) || "client_secret_post".equals(clientAuthType) || "client_secret_jwt".equals(clientAuthType);
        return this.validateValue(value, isRequired, false, friendlyName);
    }

    protected boolean validateClientAuthType(String value, String friendlyName) {
        boolean isValid = this.validateValue(value, true, false, friendlyName);
        if (!(value == null || "private_key_jwt".equals(value) || "client_secret_basic".equals(value) || "client_secret_post".equals(value) || "client_secret_jwt".equals(value))) {
            log.error((Object)(this.getAdminAuthName() + " ADMIN AUTH ERROR: '" + value + "' is not a valid " + friendlyName + " . The supported authentication types are: client_secret_basic, client_secret_post, private_key_jwt, client_secret_jwt."));
            return false;
        }
        return isValid;
    }

    public boolean validateValue(String value, boolean isRequired, boolean isUri, String name) {
        return this.validateValue(value, isRequired, isUri, name, isUri);
    }

    public boolean validateValue(String value, boolean isRequired, boolean isUri, String name, boolean isHttps) {
        if (isRequired && (value == null || StringUtils.isEmpty((String)value))) {
            log.error((Object)(this.getAdminAuthName() + " ADMIN AUTH ERROR: '" + name + "' is a required value to perform " + this.getAdminAuthName() + " Authentication and cannot be empty."));
            return false;
        }
        if (StringUtils.isNotEmpty((String)value) && isUri) {
            try {
                URI uri = new URI(value);
                String scheme = uri.getScheme();
                if (isHttps && !"https".equalsIgnoreCase(scheme)) {
                    log.error((Object)(this.getAdminAuthName() + " ADMIN AUTH ERROR: The " + name + " '" + value + "' is an invalid HTTPS URI."));
                    return false;
                }
            }
            catch (URISyntaxException e) {
                log.error((Object)(this.getAdminAuthName() + " ADMIN AUTH ERROR: The value '" + value + "' for " + name + " is an invalid URI."));
                return false;
            }
        }
        return true;
    }

    public boolean validateURI(HttpServletRequest request, String adminConsoleHostname, String error) throws URISyntaxException {
        String requestHostname = new URI(request.getRequestURL().toString()).getHost();
        if (requestHostname == null || !requestHostname.equalsIgnoreCase(adminConsoleHostname)) {
            log.error((Object)error);
            return false;
        }
        return true;
    }

    protected abstract String getAdminAuthName();

    public abstract boolean validate();
}

